#ifndef PROCESSINGCONFIGURATION_H
#define PROCESSINGCONFIGURATION_H

#include <QDialog>
#include "ClassicPrint.h"

namespace Ui {
    class ProcessingConfiguration;
}

class ProcessingConfiguration : public QDialog
{
    Q_OBJECT

public:
    explicit ProcessingConfiguration(ClassicPrint* cp, QWidget *parent = 0);
    ~ProcessingConfiguration();

protected:
    void changeEvent(QEvent *e);

private:
    void setCustom();


private:
    Ui::ProcessingConfiguration *ui;

    ClassicPrint*   m_cp;
    bool            m_updating;
	ClassicPrintProcessing* m_processing;

private slots:
	void on_buttonBox_accepted();
 void on_slider_frame_size_sliderMoved(int position);
 void on_combo_light_leak_activated(int index);
	void on_combo_process_activated(QString );
	void on_slider_contrast_valueChanged(int value);
    void on_slider_colourisation_valueChanged(int value);
    void on_btn_delete_clicked();
    void on_btn_save_clicked();
    void on_combo_name_activated(QString );
};

#endif // PROCESSINGCONFIGURATION_H
