#include "filmconfiguration.h"
#include "ui_filmconfiguration.h"
#include "ClassicPrintFilm.h"
#include "enternamedialog.h"
#include "ClassicPrintSettings.h"

FilmConfiguration::FilmConfiguration(ClassicPrint* cp, QWidget *parent) :
    QDialog(parent),
    ui(new Ui::FilmConfiguration)
{
    ui->setupUi(this);

	// Take a local copy of the current film
	m_film = new ClassicPrintFilm();
	if (cp->getCurrentFilm()) {
		*m_film = *cp->getCurrentFilm();
	}

    // Put the icons on the buttons
    QIcon icon_delete(QIcon(ClassicPrintSettings::config_dir() + "/icons/camera_delete.png"));
    icon_delete.addFile(ClassicPrintSettings::config_dir() + "/icons/camera_delete_dimmed.png", QSize(), QIcon::Disabled);
    ui->btn_delete->setIcon(icon_delete);
    QIcon icon_save(QIcon(ClassicPrintSettings::config_dir() + "/icons/notes_save.png"));
    icon_save.addFile(ClassicPrintSettings::config_dir() + "/icons/notes_save_dimmed.png", QSize(), QIcon::Disabled);
    ui->btn_save->setIcon(icon_save);

    m_cp = cp;

    m_updating = true;

    // Setup the controls to reflect the current settings
	ui->slider_temperature->setValue(m_film->temperature());
	ui->slider_noise->setValue(m_film->noise());

	ui->btn_save->setEnabled(false);
    // Populate the combobox with the available film list
    int index = 0;
    ClassicPrintFilm* film;
    QString name;
    ui->combo_name->clear();
    while (m_cp->getFilm(index++, name, &film)) {
        ui->combo_name->addItem(name);
    }
    // If there is more than one left then enable the delete button
    if (ui->combo_name->count() > 1) {
        ui->btn_delete->setEnabled(true);
    }
    else {
        ui->btn_delete->setEnabled(false);
    }
	// If the current item has been modified then ensure it has an entry
	int item = ui->combo_name->findText(m_film->name());
	if (item >= 0) {
		ui->combo_name->setCurrentIndex(item);
	}
	else {
		ui->combo_name->addItem(m_film->name());
		item = ui->combo_name->findText(m_film->name());
		if (item >= 0) {
			ui->combo_name->setCurrentIndex(item);
			ui->btn_save->setEnabled(true);
		}
	}
    m_updating = false;
}

FilmConfiguration::~FilmConfiguration()
{
    delete ui;
	delete m_film;
}

void FilmConfiguration::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void FilmConfiguration::on_combo_name_activated(QString name)
{
	QString				film_name;
	ClassicPrintFilm*	film;
	int					index = 0;

    m_updating = true;
    ui->btn_save->setEnabled(false);

	// Find the selected film
	while (m_cp->getFilm(index++, film_name, &film)) {
		if (film_name == name) {
			*m_film = *film;
			break;
		}
	}

    // Reset the controls
	ui->slider_temperature->setValue(m_film->temperature());
	ui->slider_noise->setValue(m_film->noise());
    // Remove the custom field from the combobox
    int item = ui->combo_name->findText("[Custom]");
    if (item >= 0) {
        ui->combo_name->removeItem(item);
    }
    // If there is more than one item left then enable the delete button
    if (ui->combo_name->count() > 1) {
        ui->btn_delete->setEnabled(true);
    }
    else {
        ui->btn_delete->setEnabled(false);
    }
    m_updating = false;

}

void FilmConfiguration::on_btn_save_clicked()
{
    EnterNameDialog enter_name(this);
    enter_name.setName("");
	if (enter_name.exec() != QDialog::Accepted) {
		return;
	}
	if (enter_name.name().length() > 0) {
        // Add the new film
		m_film->setName(enter_name.name());
        ClassicPrintFilm* film = new ClassicPrintFilm();
		*film = *m_film;
        m_cp->addFilm(film);
        // Repopulate the combobox
        m_updating = true;
        int index = 0;
        QString name;
        ui->combo_name->clear();
        while (m_cp->getFilm(index++, name, &film)) {
            ui->combo_name->addItem(name);
        }
        // If there is more than one left then enable the delete button
        if (ui->combo_name->count() > 1) {
            ui->btn_delete->setEnabled(true);
        }
        else {
            ui->btn_delete->setEnabled(false);
        }
        // If the current item has been modified then ensure it has an entry
		int item = ui->combo_name->findText(m_film->name());
        if (item >= 0) {
            ui->combo_name->setCurrentIndex(item);
        }
        ui->btn_save->setEnabled(false);
        m_updating = false;
    }
}

void FilmConfiguration::on_btn_delete_clicked()
{
    int item = ui->combo_name->currentIndex();
    if (item >= 0) {
        QString name;
        ClassicPrintFilm* film;

        m_cp->deleteFilm(ui->combo_name->currentText());
        ui->combo_name->removeItem(item);
        // This should always work because the button would only be
        // enabled if there was more than one item
        m_cp->getFilm(0, name, &film);
        item = ui->combo_name->findText(name);
        if (item != -1) {
            ui->combo_name->setCurrentIndex(item);
        }
    }

}

void FilmConfiguration::on_slider_temperature_valueChanged(int value)
{
    if (!m_updating) {
		m_film->setTemperature(value);
        setCustom();
    }
}

void FilmConfiguration::on_slider_noise_valueChanged(int value)
{
    if (!m_updating) {
		m_film->setNoise(value);
        setCustom();
    }
}

void FilmConfiguration::setCustom() {
    // See if the custom value is already in the combobox
    if (ui->combo_name->findText("[Custom]") < 0) {
        // No. Add it in
        ui->combo_name->addItem("[Custom]");
        // Make sure it is selected
        ui->combo_name->setCurrentIndex(ui->combo_name->findText("[Custom]"));
        // Make sure the current item has the custom name
		m_film->setName("[Custom]");

        ui->btn_delete->setEnabled(false);
        ui->btn_save->setEnabled(true);
    }
}


void FilmConfiguration::on_buttonBox_accepted()
{
	// Apply our local film settings to the current settings
	if (m_cp->getCurrentFilm()) {
		*m_cp->getCurrentFilm() = *m_film;
	}
	accept();
}
