#include "enternamedialog.h"
#include "ui_enternamedialog.h"

EnterNameDialog::EnterNameDialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::EnterNameDialog)
{
    ui->setupUi(this);
    ui->edit_name->setText(m_name);
}

EnterNameDialog::~EnterNameDialog()
{
    delete ui;
}

void EnterNameDialog::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

const QString& EnterNameDialog::name() {
    return m_name;
}

void EnterNameDialog::setName(const QString& name) {
    m_name = name;
}

void EnterNameDialog::on_edit_name_editingFinished()
{
    m_name = ui->edit_name->text();
}

void EnterNameDialog::on_buttonBox_accepted()
{
	accept();
}
