/* This file is part of Cinaest.
 *
 * Copyright (C) 2009 Philipp Zabel
 *
 * Cinaest is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Cinaest is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Cinaest. If not, see <http://www.gnu.org/licenses/>.
 */

using Gtk;
using Hildon;

public class SourceListWindow : StackableWindow {
	private SourceListView source_list;
	private bool start_movies;
	private string default_source;

	construct {
		set_title ("Cinæst");

		// View menu
		var menu = new SourceListMenu (this);

		set_main_menu (menu);

		var sources = new List<MovieSource> ();
		source_list = new SourceListView (sources);

		var hbox = new HBox (true, 0);
		hbox.pack_start (source_list, true, true, MARGIN_DOUBLE);
		add (hbox);

		source_list.source_activated.connect (on_source_activated);

		var gc = GConf.Client.get_default ();
		try {
			start_movies = gc.get_bool ("/apps/cinaest/start_movies");
			default_source = gc.get_string ("/apps/cinaest/default_source");
		} catch (Error e) {
			stdout.printf ("Error getting GConf option: %s\n", e.message);
		}

		show_all ();
	}

	public void add_sources (List<MovieSource> list) {
		source_list.add_sources (list);
		if (start_movies) {
			foreach (MovieSource source in list) {
				if (default_source == source.get_name ()) {
					var window = new MovieListWindow (source);
					break;
				}
			}
		}
	}

	private void on_source_activated (MovieSource source) {
		var window = new MovieListWindow (source);
	}
}
