#
#  Copyright (c) 2008 INdT - Instituto Nokia de Tecnologia
#
#  This file is part of carman-python.
#
#  carman-python is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  carman-python is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

"""
Implements L{ManageTrips}.

@todo: Document this module.
"""

from main.listctrl import ListView
from trips.edittripctrl import EditTripController
from trips.resettripctrl import ResetTripController
from trips.deletetripctrl import DeleteTripController

class ManageTrips(ListView):
    """
    @todo: Document this class.
    """
    def __init__(self, parent):
        self._parent = parent
        ListView.__init__(self, "list-normal", "list-item-normal",
            "MANAGE TRIPS")

        self.add_item("Reset trip", self.__reset_trip)
        self.add_item("Edit trip", self.__edit_trip)
        self.add_item("Delete trip", self.__delete_trip)

    def __edit_trip(self, obj, item, param):
        edit = EditTripController()
        edit.show()

    def __delete_trip(self, obj, item, param):
        delete = DeleteTripController(self)
        delete.show()

    def __reset_trip(self, obj, item, param):
        reset = ResetTripController(self)
        reset.show()
