#
#  Copyright (c) 2008 INdT - Instituto Nokia de Tecnologia
#
#  This file is part of carman-python.
#
#  carman-python is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  carman-python is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

"""
Implements L{EditTripController}.

@todo: Document this module.
"""

from common.carlog import DEBUG
from main.editdlgview import EditDlgView
from models.tripsmodel import TripsModel
from trips.triplistview import TripListView
from main.messagedlgctrl import MessageDlgController

class EditTripController(object):
    """
    @todo: Document this class.
    """
    def __init__(self):
        self.trips_model = TripsModel()

    def show(self):
        view = TripListView("EDIT TRIP", self.__edit_trip_cb)
        if view.is_empty():
            view.hide(True)
            msg = MessageDlgController()
            msg.show_message("No trips saved", title="EDIT TRIP")
        else:
            view.show()

    def __edit_trip_cb(self, obj, item, param):
        def edited_cb(dlg, text):
            def hide():
                dlg.hide(True)

            if not text:
                text = "<color>(No label)"
                self.trips_model.change_trip_name(param, "")
            else:
                self.trips_model.change_trip_name(param, text)
            item.set_label(text)

            msg = MessageDlgController(confirm_cb=hide)
            msg.show_message("The label for this trip now is %s" % text,
                title="EDIT TRIP")

        name = self.trips_model.get_trip_info(param)[0]
        edit = EditDlgView("EDIT TRIP", "Type a new label", name,
            edited_cb)
        edit.show()
