#
#  Copyright (c) 2008 INdT - Instituto Nokia de Tecnologia
#
#  This file is part of carman-python.
#
#  carman-python is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  carman-python is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

"""
Implements L{ThemeListView}.
"""

import os, edje
from main.listctrl import ListView
from common.carmanconfig import CarmanConfig
from main.messagedlgctrl import MessageDlgController

class ThemeListView(ListView):
    """
    Handles features related to possible themes to be used. All available
    themes are sorted by name.

    @type parent: L{GlobalOptionsView}.
    @param parent: Reference to previous view.
    """
    def __init__(self, parent):
        def change_theme(obj, item, param):
            self.hide()
            parent.hide(True)
            if param != config.get_current_theme_path():
                theme = os.path.join(param, "theme.edj")
                version = edje.file_data_get(theme, "theme.version")
                if version == config.get_app_version():
                    config.set_theme_path(param)
                    parent.set_global_theme()
                else:
                    title = edje.file_data_get(theme, "theme.title")
                    msg = MessageDlgController()
                    msg.show_message("This theme is not compatible with the"
                            + " installed<br>Carman's version. Please "
                            + "install the compatible<br>version"
                            + "(%s) of the %s theme."
                            % (config.get_app_version(), title),
                            title="CHOOSE THEME")


        config = CarmanConfig()
        themes = []

        ListView.__init__(self, "list-theme", "list-item-theme",
            "CHOOSE THEME")

        for root, dirs, files in os.walk(config.get_theme_root_path()):
            if "theme.edj" in files:
                theme = os.path.join(root, "theme.edj")
                title = edje.file_data_get(theme, "theme.title")
                version = edje.file_data_get(theme, "theme.version")
                themes.append((title, root, theme))

        themes.sort()
        for title, root, theme in themes:
            self.add_item(title, change_theme, root, \
                thumbnail=(theme, "images/thumbnail"))
