#
#  Copyright (c) 2008 INdT - Instituto Nokia de Tecnologia
#
#  This file is part of carman-python.
#
#  carman-python is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  carman-python is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

"""
Implements L{Main}.
"""

import os, edje, ecore
import common.ossohelper as osso
from common.carmanconfig import CarmanConfig
from main.mainview import MainView

class Main(object):
    """
    Carman's Main class. Creates a L{MainView} object and a
    L{MainController} object, sets up Carman's initial config
    and initizalizes the C{ecore} main loop.
    """
    def __init__(self):
        osso.application_init("carman_evas")
        osso.display_on()
        if osso.has_osso():
            ecore.timer_add(45, self.__display_blanking)
        config = CarmanConfig()
        theme = config.get_current_theme()
        version = edje.file_data_get(theme, "theme.version")
        if not os.path.exists(theme) or version != config.get_app_version():
            path = os.path.join(config.get_theme_root_path(), "tuning")
            config.set_theme_path(path)
            theme = config.get_current_theme()

        self.view = MainView()
        self.view.show_splashscreen(theme)
        ecore.timer_add(0.1, self.process)
        ecore.main_loop_begin()
        self.main.finalize()
        osso.application_exit()

    def process(self):
        """
        Call for the L{MainController} object.

        @rtype: boolean
        @return: C{False}.
        """
        from main.mainctrl import MainController
        self.main = MainController(self.view)
        self.view.hide_splashscreen()
        return False

    def __display_blanking(self):
        """
        Called for blanking screen. Uses libosso method for
        blanking screen.

        @rtype: boolean
        @return: C{True}.
        """
        osso.display_blanking_pause()
        return True

