#
#  Copyright (c) 2008 INdT - Instituto Nokia de Tecnologia
#
#  This file is part of carman-python.
#
#  carman-python is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  carman-python is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

"""
Implements L{ListRadioView}.
"""

from common.carlog import DEBUG
from main.listctrl import ListView

class ListRadioView(ListView):
    """
    This class is inherited from L{ListView} and implements a Radio List View.

    @type title: string
    @param title: Title of the Radio List View.
    """
    def __init__(self, title):
        ListView.__init__(self, "list-theme", "list-item-thumbcheck",
                title)
        self.selected = None

    def select_item(self, item):
        """
        Called when the list item is selected.

        @type item: string
        @param item: Name of the Edje item group.
        """
        if self.selected and self.selected != item:
            for item_list in self.container.items:
                if self.selected == item_list.param:
                    index = self.container.items.index(item_list)
                    self.container.items[index].signal_emit("unchecked-button", "")

        self.selected = item
