#
#  Copyright (c) 2008 INdT - Instituto Nokia de Tecnologia
#
#  This file is part of carman-python.
#
#  carman-python is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  carman-python is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

"""
Implements L{GlobalOptionsView}.
"""

from main.listctrl import ListView
from options.themelistview import ThemeListView
from options.speedalertdlgctrl import SpeedAlertDlgController
from options.unitlistview import UnitListView

class GlobalOptionsView(ListView):
    """
    Handles default options to all modules(C{Maps}, C{Gauges} and C{Trips}).

    @type parent: object
    @param parent: Reference to previous view.
    """
    def __init__(self, parent):
        self._parent = parent
        ListView.__init__(self, "list-normal", "list-item-normal", "OPTIONS")

    def add_global_items(self):
        """
        Adds callbacks to common options.
        """
        def change_unit(obj, item, param):
            unit = UnitListView(self)
            unit.show()

        def choose_theme(obj, item, param):
            theme = ThemeListView(self)
            theme.show()

        def speed_alert(obj, item, param):
            speed = SpeedAlertDlgController(self)
            speed.show()

        self.add_item("Speed alert", speed_alert)
        self.add_item("Choose theme", choose_theme)
        self.add_item("Change unit", change_unit)

    def set_global_theme(self):
        """
        Calls the parent view to notify L{MainView} that the theme has changed.
        """
        self._parent.set_global_theme()

    def set_global_unit(self, system):
        """
        Calls the parent view to notify L{MainView} that the unit system has
        changed to the given value.

        @type system: boolean
        @param system: C{True} if unit is metric, C{False} if imperial.
        """
        self._parent.set_global_unit(system)
