#
#  Copyright (c) 2008 INdT - Instituto Nokia de Tecnologia
#
#  This file is part of carman-python.
#
#  carman-python is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  carman-python is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

"""
Implements L{ManageMapsController}.
"""

from main.listctrl import ListView
from maps.downloadctrl import DownloadAreaController
#from maps.downloadctrl import DownloadTrackController
#from maps.tracklistview import TrackListView
from models.mapmodel import MapModel
from models.connmodel import ConnectionModel


class ManageMapsController(object):
    """
    Controller class to manage maps options.

    @type   parent: class
    @param  parent: Parent window C{GlobalOptView}.
    """
    def __init__(self, parent):
        self._parent = parent
        self.map_model = MapModel()
        self.view = ListView("list-normal", "list-item-normal", "MANAGE MAPS")

        if not self._parent._parent.is_downloading():
            self.view.add_item("Clear map service cache", \
                               self.__clear_map_service_cache_cb)
            if ConnectionModel().Status() == ConnectionModel.CONNECTED:
                self.view.add_item("Download maps by area", \
                             self.__download_maps_by_area_cb)
#                self.view.add_item("Download maps by track", \
#                             self.__download_maps_by_track_cb)
        else:
            self.view.add_item("Stop current download", \
                self.__stop_current_download_cb)

    def __stop_current_download_cb(self, obj, item, param):
        """
        Callback to be called when "Stop current download" option is selected.

        @type   obj: L{ListView}
        @param  obj: Not used.
        @type   item: L{ListItemView}
        @param  item: Not used.
        @type   param: object
        @param  param: Not used.
        """
        self.view.hide()
        self._parent.hide(True)
        self._parent._parent.stop_download()

    def __clear_map_service_cache_cb(self, obj, item, param):
        """
        Callback to be called when "Clear map service cache" option is selected.

        @type   obj: L{ListView}
        @param  obj: Not used.
        @type   item: L{ListItemView}
        @param  item: Not used.
        @type   param: object
        @param  param: Not used.
        """
        self.view.hide()
        self._parent.hide(True)
        self.map_model.clear_repository_files()

    def __download_maps_by_area_cb(self, obj, item, param):
        """
        Callback to be called when "Download maps by area" option is selected.

        @type   obj: L{ListView}
        @param  obj: Not used.
        @type   item: L{ListItemView}
        @param  item: Not used.
        @type   param: object
        @param  param: Not used.
        """
        download = DownloadAreaController(self)
        download.show()

    '''
    def __download_maps_by_track_cb(self, obj, item, param):
        """
        Callback to be called when "Download maps by track" option is selected.

        @type   obj: L{ListView}
        @param  obj: Not used.
        @type   item: L{ListItemView}
        @param  item: Not used.
        @type   param: object
        @param  param: Not used.
        """
        def track_selected(obj, item, param):
            download = DownloadTrackController(obj, param)
            download.show()

        tracklist = TrackListView(self, False, track_selected)
        tracklist.show()
    '''

    def hide(self, param):
        """
        Hide the L{ListView} object.

        @type   param: boolean
        @param  param: bool
        """
        self.view.hide(param)

    def show(self):
        """
        Displays the L{ListView} object.
        """
        self.view.show()
