/*
 *  Copyright (c) 2008 INdT - Instituto Nokia de Tecnologia
 *
 *  This file is part of carman-python.
 *  
 *  carman-python is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  carman-python is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */


#include <stdio.h>
#include <Eet.h>
#include <Evas.h>
#include <Ecore.h>
#include <Ecore_Evas.h>

int main(int argc, char **argv) {
    Evas *evas;
    void *data;
    Eet_File *ef;
    char buf[256];
    Ecore_Evas *ee;
    Evas_Object *img;
    int w, h, a, bytes;

    if (argc < 4) {
        printf("usage: %s file.edj image_key image_filename\n", argv[0]);
        return 1;
    }

    // Initialize evas core
    eet_init();
    ecore_init();
    ecore_evas_init();
    ee = ecore_evas_buffer_new(1, 1);
    if (!ee) {
        fprintf(stderr, "Error. cannot create buffer engine canvas for "
            "image load.\n");
        return 1;
    }

    // Open edje file
    ef = eet_open(argv[1], EET_FILE_MODE_READ_WRITE);
    if (!ef) {
        fprintf(stderr, "Unable to open %s\n", argv[1]);
        ecore_shutdown();
        eet_shutdown();
        return 1;
    }

    // Load image
    evas = ecore_evas_get(ee);
    img = evas_object_image_add(evas);
    evas_object_image_file_set(img, argv[3], NULL);
    if (evas_object_image_load_error_get(img) != EVAS_LOAD_ERROR_NONE) {
        fprintf(stderr, "Unable to load %s\n", argv[3]);
        eet_close(ef);
        ecore_shutdown();
        eet_shutdown();
        return 1;
    }

    // Get image attributes
    evas_object_image_size_get(img, &w, &h);
    a = evas_object_image_alpha_get(img);
    data = evas_object_image_data_get(img, 0);
    if (!data || w <= 0 || h <= 0) {
        fprintf(stderr, "Unable to load %s\n", argv[3]);
        eet_close(ef);
        ecore_shutdown();
        eet_shutdown();
        return 1;
    }

    // Write image in edje file
    snprintf(buf, sizeof(buf), "images/%s", argv[2]);
    bytes = eet_data_image_write(ef, buf, data, w, h, a, 1, 0, 0);
    if (bytes <= 0) {
        fprintf(stderr, "Unable to write image \"%s\" as \"%s\" entry "
            "to %s\n", argv[3], buf, argv[1]);
        eet_close(ef);
        ecore_shutdown();
        eet_shutdown();
        return 1;
    } else
        printf("Wrote %d bytes in \"%s\" entry from \"%s\"\n", bytes, buf,
            argv[3]);

    // Close evas core
    eet_close(ef);
    ecore_shutdown();
    eet_shutdown();
    return 0;
}
