/*
 * callerid-widget: Shows and allows for the changing of the Caller ID visibility state on the desktop
 *
 * Copyright (C) 2010 Faheem Pervez <trippin1@gmail.com>. All rights reserved.
 *
 * Cairo code from Personal IP Address:
 * 	Copyright (C) 2009 Andrew Olmsted. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *      
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *      
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 */

/* callerid-widget.c */

//#include <string.h>
//#include <libintl.h>
#include <glib.h>
#include <glib-object.h>
#include <cairo/cairo.h>
#include <dbus/dbus-glib.h>
#include <telepathy-glib/dbus.h> /* Suck my cock, Telepathy and Mission Control */
#include <libmcclient/mc-account.h>
#include <gtk/gtk.h>
#include <hildon/hildon.h>
#include <libhildondesktop/libhildondesktop.h>

#define DEFAULT_WIDTH 315
#define DEFAULT_HEIGHT 36
#define _HILDON_SIZE_DEFAULT HILDON_SIZE_FINGER_HEIGHT | HILDON_SIZE_AUTO_WIDTH

#define TELEPATHY_SERVICE "org.freedesktop.Telepathy.AccountManager"
#define TELEPATHY_RING_PATH "/org/freedesktop/Telepathy/Account/ring/tel/ring"
#define TELEPATHY_INTERACE "org.freedesktop.Telepathy.Account"
#define TELEPATHY_ACCOUNT_PROP_CHANGED "AccountPropertyChanged"
#define TELEPATHY_PROPERTY "com.nokia.Telepathy.Connection.Interface.GSM.Privacy"

#define TELEPHONY_MAEMO_SERVICE "org.bluez"
#define TELEPHONY_MAEMO_PATH "/com/nokia/MaemoTelephony"
#define TELEPHONY_MAEMO_INTERFACE "com.nokia.MaemoTelephony"

#define NETWORK_LABEL "Chosen by network"
#define HIDDEN_LABEL "Hidden"
#define SHOWN_LABEL "Shown"
#define NOID "no-id"
#define ID "id"

/* Start of GObject boilerplate shit */

#define CALLERID_TYPE_WIDGET (callerid_widget_get_type ())

#define CALLERID_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), \
						CALLERID_TYPE_WIDGET, CallerIDWidget))

#define CALLERID_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), \
						CALLERID_TYPE_WIDGET, CallerIDWidgetClass))

#define CALLERID_IS_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
						CALLERID_TYPE_WIDGET))

#define CALLERID_IS_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), \
						CALLERID_TYPE_WIDGET))

#define CALLERID_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), \
						CALLERID_TYPE_WIDGET, CallerIDWidgetClass))

#define CALLERID_WIDGET_GET_PRIVATE(obj) (G_TYPE_INSTANCE_GET_PRIVATE ((obj), \
						CALLERID_TYPE_WIDGET, CallerIDWidgetPrivate))

typedef struct _CallerIDWidget CallerIDWidget;
typedef struct _CallerIDWidgetClass CallerIDWidgetClass;
typedef struct _CallerIDWidgetPrivate CallerIDWidgetPrivate;

struct _CallerIDWidget
{
	HDHomePluginItem parent;

	CallerIDWidgetPrivate *priv;
};

struct _CallerIDWidgetClass
{
	HDHomePluginItemClass parent_class;
};

struct _CallerIDWidgetPrivate
{
	McAccount *ring_acc;

	GtkWidget *homeWidget;
	GtkWidget *idLabel;
	GtkWidget *stateLabel;

	gboolean isPressed;

	gchar *new_tp_state;
	gchar *new_bluez_state;

	DBusGConnection *sess_dbus_conn;
	DBusGConnection *sys_dbus_conn;
	DBusGProxy *ring_proxy;
	DBusGProxy *bluez_telephony_proxy;
};

GType callerid_widget_get_type (void);
HD_DEFINE_PLUGIN_MODULE (CallerIDWidget, callerid_widget, HD_TYPE_HOME_PLUGIN_ITEM)

/* End of GObject boilerplate shit */

static gboolean callerid_widget_update_content (CallerIDWidget *self);
static void callerid_widget_done_constructing (GObject *gobject);
static void callerid_widget_on_ready_update (McAccount *account, const GError *error, CallerIDWidget *self);

/*static inline const char* dgettext_localised_or_english (const char* domainname, const char* msgid, const char *fallback_string)*/
/*{*/
/*	const char *retval = dgettext (domainname, msgid);*/

/*	return G_UNLIKELY (!strcmp (retval, msgid)) ? fallback_string : retval;*/
/*}*/

/* --- */

static void callerid_widget_dispose (GObject *gobject)
{
	CallerIDWidget *self = CALLERID_WIDGET (gobject);

	if (self->priv->bluez_telephony_proxy)
		g_object_unref (self->priv->bluez_telephony_proxy);

	if (self->priv->sys_dbus_conn)
		dbus_g_connection_unref (self->priv->sys_dbus_conn);

	if (self->priv->ring_proxy)
		g_object_unref (self->priv->ring_proxy);

	if (self->priv->sess_dbus_conn)
		dbus_g_connection_unref (self->priv->sess_dbus_conn);

	if (self->priv->ring_acc)
		g_object_unref (self->priv->ring_acc);

	G_OBJECT_CLASS (callerid_widget_parent_class)->dispose (gobject);
}

/*static void callerid_widget_finalize (GObject *gobject)*/
/*{*/
/*	CallerIDWidget *self = CALLERID_WIDGET (gobject);*/

/*	g_free (self->priv->new_tp_state);*/
/*	g_free (self->priv->new_bluez_state);*/

/*	G_OBJECT_CLASS (callerid_widget_parent_class)->finalize (gobject);*/
/*}*/

static void callerid_widget_realize (GtkWidget *widget)
{
	GdkScreen *screen = gtk_widget_get_screen (widget);
	gtk_widget_set_colormap (widget, gdk_screen_get_rgba_colormap (screen));
	gtk_widget_set_app_paintable (widget, TRUE);

	GTK_WIDGET_CLASS (callerid_widget_parent_class)->realize (widget);
}

static gboolean callerid_widget_expose_event (GtkWidget *widget, GdkEventExpose *event)
{
	CallerIDWidget *self = CALLERID_WIDGET (widget);
	cairo_t *cr;
	gint width, height, x, y;
	gint radius = 5;

	cr = gdk_cairo_create (GDK_DRAWABLE (widget->window));
	gdk_cairo_region (cr, event->region);
	cairo_clip (cr);

	GdkColor color;
	if (!self->priv->isPressed)
	{
		gtk_style_lookup_color (gtk_rc_get_style(widget), "DefaultBackgroundColor", &color);
		cairo_set_source_rgba (cr, color.red/65535.0, color.green/65335.0, color.blue/65535.0, 0.75);
	}
	else
	{
		gtk_style_lookup_color (gtk_rc_get_style(widget), "SelectionColor", &color);
		cairo_set_source_rgba (cr, color.red/65535.0, color.green/65335.0, color.blue/65535.0, 0.6);
	}

	width = widget->allocation.width;
	height = widget->allocation.height;
	x = widget->allocation.x;
	y = widget->allocation.y;

	cairo_move_to (cr, x + radius, y);
	cairo_line_to (cr, x + width - radius, y);
	cairo_curve_to (cr, x + width - radius, y, x + width, y, x + width,y + radius);
	cairo_line_to (cr, x + width, y + height - radius);
	cairo_curve_to (cr, x + width, y + height - radius, x + width,y + height, x + width - radius, y + height);
	cairo_line_to (cr, x + radius, y + height);
	cairo_curve_to (cr, x + radius, y + height, x, y + height, x,y + height - radius);
	cairo_line_to (cr, x, y + radius);
	cairo_curve_to (cr, x, y + radius, x, y, x + radius, y);

	cairo_set_operator (cr, CAIRO_OPERATOR_SOURCE);

	cairo_fill_preserve (cr);

	gtk_style_lookup_color (gtk_rc_get_style (widget), "ActiveTextColor", &color);
	cairo_set_source_rgba (cr, color.red/65535.0, color.green/65335.0, color.blue/65535.0, 0.5);
	cairo_set_line_width (cr, 1);
	cairo_stroke (cr);

	cairo_destroy (cr);

	return GTK_WIDGET_CLASS (callerid_widget_parent_class)->expose_event (widget, event);
}

static void callerid_widget_class_init (CallerIDWidgetClass *klass)
{
	GObjectClass *object_class = G_OBJECT_CLASS (klass);
	GtkWidgetClass *widget_class = GTK_WIDGET_CLASS (klass);

	object_class->constructed = callerid_widget_done_constructing;
	object_class->dispose = callerid_widget_dispose;
/*	object_class->finalize = (GObjectFinalizeFunc) callerid_widget_finalize;*/

	widget_class->realize = callerid_widget_realize;
	widget_class->expose_event = callerid_widget_expose_event;

	g_type_class_add_private (klass, sizeof (CallerIDWidgetPrivate));
}

static void callerid_widget_class_finalize (CallerIDWidgetClass *klass G_GNUC_UNUSED) {}

/* --- */

static void callerid_widget_new_callerid_combo (CallerIDWidget *self)
{
	GtkWidget *w;
	guint i;
	const gchar *lbl_text;
	gint selIndex;
	GtkWidget *selector;
	HildonTouchSelectorColumn *col;
	GtkCellRenderer *r;
	GtkListStore *store;
	const struct
	{
		const gchar *tp_value;
		const gchar *bluez_value;
		const gchar *text;
	}
	const callerid_touch_selector_items[] =
	{
		{NOID, "allowed", SHOWN_LABEL},
		{ID, "restricted", HIDDEN_LABEL},
		{"", "none", NETWORK_LABEL}
	};

	selIndex = -1;
	lbl_text = gtk_label_get_text (GTK_LABEL (self->priv->stateLabel));
	store = gtk_list_store_new (3, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);
	for (i = 0; i < G_N_ELEMENTS (callerid_touch_selector_items); ++i)
	{
		GtkTreeIter iter;
		gtk_list_store_append (store, &iter);
		gtk_list_store_set (store, &iter, 0, callerid_touch_selector_items[i].tp_value, 1, callerid_touch_selector_items[i].bluez_value, 2, callerid_touch_selector_items[i].text, -1);
		if (g_str_equal (callerid_touch_selector_items[i].text, lbl_text))
			selIndex = i;
	}

	w = hildon_picker_dialog_new (NULL);
	gtk_window_set_title (GTK_WINDOW (w), "Caller ID state:");
	selector = hildon_touch_selector_new ();
	r = gtk_cell_renderer_text_new ();
	g_object_set (r, "width", 1, "xalign", 0.5f, NULL);
	col = hildon_touch_selector_append_column (HILDON_TOUCH_SELECTOR (selector), GTK_TREE_MODEL (store), r, "text", 2, NULL);
	hildon_touch_selector_column_set_text_column (col, 2);
	hildon_picker_dialog_set_selector (HILDON_PICKER_DIALOG (w), HILDON_TOUCH_SELECTOR (selector));
	if (selIndex >= 0)
		hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (selector), 0, selIndex);

	g_object_unref (G_OBJECT (store));

	if (gtk_dialog_run (GTK_DIALOG (w)) == GTK_RESPONSE_OK)
	{
		GtkTreeIter iter;

		if (hildon_touch_selector_get_selected (HILDON_TOUCH_SELECTOR (selector), 0, &iter))
		{
			gtk_tree_model_get (hildon_touch_selector_get_model (HILDON_TOUCH_SELECTOR (selector), 0), &iter, 0, &self->priv->new_tp_state, 1, &self->priv->new_bluez_state, -1);
			mc_account_call_when_ready (self->priv->ring_acc, (McAccountWhenReadyCb) callerid_widget_on_ready_update, self);
		}
	}
	gtk_widget_destroy (GTK_WIDGET (w));
}

static void callerid_widget_on_property_changed (const DBusGProxy *proxy G_GNUC_UNUSED, GHashTable *hash G_GNUC_UNUSED, CallerIDWidget *self)
{
	/* I couldn't give a fuck about what's changed */
	g_idle_add ((GSourceFunc) callerid_widget_update_content, self);
}

static void callerid_widget_on_parameters_update (TpProxy *proxy G_GNUC_UNUSED, const gchar **out_Reconnect_Required G_GNUC_UNUSED, const GError *error, CallerIDWidget *self, GObject *weak_object G_GNUC_UNUSED)
{
	if (!error)
		dbus_g_proxy_call_no_reply (self->priv->bluez_telephony_proxy, "SetCallerId", G_TYPE_STRING, self->priv->new_bluez_state, G_TYPE_INVALID); /* If it sets, then it sets. telephony-maemo.c should be checking Telepathy like how I do so instead of requiring us to set it twice */

	g_free (self->priv->new_tp_state);
	g_free (self->priv->new_bluez_state);
}

static void callerid_widget_on_ready_update (McAccount *account, const GError *error, CallerIDWidget *self)
{
	GValue gvalue = {0};
	GHashTable *parameters, *new_params;
	GHashTableIter iter;
	gpointer key, value;

	g_return_if_fail (error != NULL);

	parameters = mc_account_get_parameters (account);
	g_return_if_fail (parameters != NULL);

	g_hash_table_iter_init (&iter, parameters);
	new_params = g_hash_table_new ((GHashFunc) g_str_hash, (GEqualFunc) g_str_equal);
	while (g_hash_table_iter_next (&iter, &key, &value))
	{
		if (g_str_equal (key, TELEPATHY_PROPERTY))
			continue;

		g_hash_table_insert (new_params, key, value);
	}

	g_value_init (&gvalue, G_TYPE_STRING);
	g_value_set_static_string (&gvalue, self->priv->new_tp_state);
	g_hash_table_insert (new_params, TELEPATHY_PROPERTY, &gvalue);
	mc_cli_account_call_update_parameters (account, -1, new_params, NULL, (mc_cli_account_callback_for_update_parameters) callerid_widget_on_parameters_update, self, NULL, NULL);
}

static void callerid_widget_on_ready_read (McAccount *account, const GError *error, CallerIDWidget *self)
{
	GValue *gvalue;
	GHashTable *parameters;
	const gchar *result;
	gchar *label;

	g_return_if_fail (error != NULL);

	parameters = mc_account_get_parameters (account);
	g_return_if_fail (parameters != NULL);

	gvalue = g_hash_table_lookup (parameters, TELEPATHY_PROPERTY);
	g_return_if_fail (gvalue != NULL);

	result = g_value_get_string (gvalue);

	if (g_str_equal (result, NOID))
		label = SHOWN_LABEL;
	else if (g_str_equal (result, ID))
		label = HIDDEN_LABEL;
	else
		label = NETWORK_LABEL;

	gtk_label_set_text (GTK_LABEL (self->priv->stateLabel), label);
}

/*static gboolean callerid_widget_leave_event (GtkWidget *widget G_GNUC_UNUSED, GdkEventCrossing *event G_GNUC_UNUSED, CallerIDWidget *self)*/
/*{*/
/*	self->priv->isPressed = FALSE;*/
/*	gtk_widget_queue_draw (GTK_WIDGET (self));*/
/*	*/
/*	return FALSE;*/
/*}*/

static gboolean callerid_widget_button_release (GtkWidget *widget, GdkEventButton *event, CallerIDWidget *self)
{
	if (event->button == 1 && self->priv->isPressed)
	{
		self->priv->isPressed = FALSE;

		callerid_widget_new_callerid_combo (self);
		gtk_widget_queue_draw (widget);

		return TRUE;
	}

	return FALSE;
}

static gboolean callerid_widget_button_press (GtkWidget *widget, GdkEventButton *event, CallerIDWidget *self)
{
	if (event->button == 1)
	{
		self->priv->isPressed = TRUE;
		gtk_widget_queue_draw (widget);

		return TRUE;
	}

	return FALSE;
}

static void callerid_widget_content_create (CallerIDWidget *self)
{
	self->priv->idLabel = gtk_label_new ("Caller ID:");
	self->priv->stateLabel = gtk_label_new (NULL);
	//hildon_helper_set_logical_color (self->priv->idLabel, GTK_RC_FG, GTK_STATE_NORMAL, "DefaultTextColor");
	hildon_helper_set_logical_color (self->priv->stateLabel, GTK_RC_FG, GTK_STATE_NORMAL, "ActiveTextColor");
	gtk_misc_set_alignment (GTK_MISC (self->priv->idLabel), 0, 1);
	gtk_misc_set_alignment (GTK_MISC (self->priv->stateLabel), 1, 1);
	gtk_misc_set_padding (GTK_MISC (self->priv->idLabel), HILDON_MARGIN_DEFAULT, HILDON_MARGIN_HALF);
	gtk_misc_set_padding (GTK_MISC (self->priv->stateLabel), HILDON_MARGIN_DEFAULT, HILDON_MARGIN_HALF);
	gtk_widget_set_name (self->priv->idLabel, "hildon-shadow-label");
	gtk_widget_set_name (self->priv->stateLabel, "hildon-shadow-label");
	gtk_box_pack_start (GTK_BOX (self->priv->homeWidget), self->priv->idLabel, TRUE, TRUE, 0);
	gtk_box_pack_start (GTK_BOX (self->priv->homeWidget), self->priv->stateLabel, FALSE, FALSE, 0);

	g_signal_connect (self, "button-release-event", G_CALLBACK (callerid_widget_button_release), self);
	g_signal_connect (self, "button-press-event", G_CALLBACK (callerid_widget_button_press), self);
	//g_signal_connect (self, "leave-notify-event", G_CALLBACK (callerid_widget_leave_event), self);

	gtk_widget_show_all (self->priv->homeWidget);
}

static gboolean callerid_widget_update_content (CallerIDWidget *self)
{
	gtk_label_set_text (GTK_LABEL (self->priv->stateLabel), "...");

	g_return_val_if_fail (self->priv->ring_acc != NULL, FALSE);

	mc_account_call_when_ready (self->priv->ring_acc, (McAccountWhenReadyCb) callerid_widget_on_ready_read, self);

	return FALSE;
}

/* --- */

static void callerid_widget_done_constructing (GObject *gobject)
{
	CallerIDWidget *self = CALLERID_WIDGET (gobject);
	G_OBJECT_CLASS (callerid_widget_parent_class)->constructed (gobject);

	callerid_widget_content_create (self);
	(void) callerid_widget_update_content (self);
}

static void callerid_widget_init (CallerIDWidget *self)
{
	TpDBusDaemon *daemon = tp_dbus_daemon_dup (NULL);

	self->priv = CALLERID_WIDGET_GET_PRIVATE (self);
	g_return_if_fail (G_LIKELY (self->priv != NULL));

	gtk_widget_add_events (GTK_WIDGET (self), GDK_BUTTON_PRESS_MASK | GDK_BUTTON_RELEASE_MASK); //| GDK_LEAVE_NOTIFY_MASK);

	self->priv->ring_acc = mc_account_new (daemon, TELEPATHY_RING_PATH);
	g_object_unref (daemon);

	self->priv->sess_dbus_conn = hd_home_plugin_item_get_dbus_g_connection (HD_HOME_PLUGIN_ITEM (self), DBUS_BUS_SESSION, NULL);
	self->priv->ring_proxy = dbus_g_proxy_new_for_name (self->priv->sess_dbus_conn, TELEPATHY_SERVICE, TELEPATHY_RING_PATH, TELEPATHY_INTERACE);

	dbus_g_proxy_add_signal (self->priv->ring_proxy, TELEPATHY_ACCOUNT_PROP_CHANGED, dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, G_TYPE_VALUE), G_TYPE_INVALID);
	dbus_g_proxy_connect_signal (self->priv->ring_proxy, TELEPATHY_ACCOUNT_PROP_CHANGED, G_CALLBACK (callerid_widget_on_property_changed), self, NULL);

	self->priv->sys_dbus_conn = hd_home_plugin_item_get_dbus_g_connection (HD_HOME_PLUGIN_ITEM (self), DBUS_BUS_SYSTEM, NULL);
	self->priv->bluez_telephony_proxy = dbus_g_proxy_new_for_name (self->priv->sys_dbus_conn, TELEPHONY_MAEMO_SERVICE, TELEPHONY_MAEMO_PATH, TELEPHONY_MAEMO_INTERFACE);

	gtk_window_set_default_size (GTK_WINDOW (self), DEFAULT_WIDTH, DEFAULT_HEIGHT);

	self->priv->homeWidget = gtk_hbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER (self), self->priv->homeWidget);

	GdkGeometry hints = { .min_width = DEFAULT_WIDTH, .min_height = DEFAULT_HEIGHT, .max_width = DEFAULT_WIDTH, .max_height = DEFAULT_HEIGHT };
	gtk_window_set_geometry_hints (GTK_WINDOW (self), self->priv->homeWidget, &hints, GDK_HINT_MIN_SIZE | GDK_HINT_MAX_SIZE);

	gtk_widget_set_size_request (GTK_WIDGET (self), DEFAULT_WIDTH, DEFAULT_HEIGHT);
	gtk_window_resize (GTK_WINDOW (self), DEFAULT_WIDTH, DEFAULT_HEIGHT);
}
