/* {{{
 * CalcRogue, a roguelike game for PCs, calculators and PDAs
 * Copyright (C) 2003 Jim Babcock
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * }}} */
// tiles.c
/// @file
/// @brief Graphical tilesets, and character mapping for Curses.

#include "crogue.h"

#ifdef IS_CALCULATOR

//{{{
// Format: 1B width, 7B data
ECONST unsigned char Font_5x7[128*8] =
{
 //{{{ 00
	0,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000, //}}}
 //{{{ 01
	0,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000, //}}}
 //{{{ 02
	0,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000, //}}}
 //{{{ 03
	0,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000, //}}}
 //{{{ 04
	0,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000, //}}}
 //{{{ 05
	0,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000, //}}}
 //{{{ 06
	0,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000, //}}}
 //{{{ 07
	0,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000, //}}}
 //{{{ 08
	0,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000, //}}}
 //{{{ 09
	0,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000, //}}}
 //{{{ 0A
	0,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000, //}}}
 //{{{ 0B
	0,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000, //}}}
 //{{{ 0C
	0,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000, //}}}
 //{{{ 0D
	0,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000, //}}}
 //{{{ 0E
	0,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000, //}}}
 //{{{ 0F
	0,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000, //}}}
 //{{{ 10
	0,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000, //}}}
 //{{{ 11
	0,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000, //}}}
 //{{{ 12
	0,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000, //}}}
 //{{{ 13
	0,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000, //}}}
 //{{{ 14
	0,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000, //}}}
 //{{{ 15
	0,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000, //}}}
 //{{{ 16
	0,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000, //}}}
 //{{{ 17
	0,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000, //}}}
 //{{{ 18
	0,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000, //}}}
 //{{{ 19
	0,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000, //}}}
 //{{{ 1A
	0,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000, //}}}
 //{{{ 1B
	0,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000, //}}}
 //{{{ 1C
	0,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000, //}}}
 //{{{ 1D
	0,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000, //}}}
 //{{{ 1E
	0,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000, //}}}
 //{{{ 1F
	0,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000, //}}}
 //{{{ 20 space
	3,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000, //}}}
 //{{{ 21 !
	3,
	0b01000000,
	0b01000000,
	0b01000000,
	0b01000000,
	0b00000000,
	0b01000000,
	0b00000000, //}}}
 //{{{ 22 "
	4,
	0b01010000,
	0b01010000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000, //}}}
 //{{{ 23 #
	6,
	0b00000000,
	0b00101000,
	0b01111100,
	0b00101000,
	0b01111100,
	0b00101000,
	0b00000000, //}}}
 //{{{ 24 $
	6,
	0b00010000,
	0b00111000,
	0b01010000,
	0b00111000,
	0b00010100,
	0b01111000,
	0b00010000, //}}}
 //{{{ 25 %
	5,
	0b00000000,
	0b01001000,
	0b00010000,
	0b00100000,
	0b01001000,
	0b00000000,
	0b00000000, //}}}
 //{{{ 26 &
	7,
	0b00110000,
	0b01001000,
	0b00110000,
	0b01010110,
	0b01001000,
	0b00110100,
	0b00000000, //}}}
 //{{{ 27 '
	3,
	0b00100000,
	0b01100000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000, //}}}
 //{{{ 28 (
	3,
	0b00100000,
	0b01000000,
	0b01000000,
	0b01000000,
	0b01000000,
	0b00100000,
	0b00000000, //}}}
 //{{{ 29 )
	3,
	0b01000000,
	0b00100000,
	0b00100000,
	0b00100000,
	0b00100000,
	0b01000000,
	0b00000000, //}}}
 //{{{ 2A *
	6,
	0b00000000,
	0b01000100,
	0b00101000,
	0b01111100,
	0b00101000,
	0b01000100,
	0b00000000, //}}}
 //{{{ 2B +
	4,
	0b00000000,
	0b00000000,
	0b00100000,
	0b01110000,
	0b00100000,
	0b00000000,
	0b00000000, //}}}
 //{{{ 2C ,
	3,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00100000,
	0b01100000,
	0b00000000, //}}}
 //{{{ 2D -
	4,
	0b00000000,
	0b00000000,
	0b00000000,
	0b01110000,
	0b00000000,
	0b00000000,
	0b00000000, //}}}
 //{{{ 2E .
	2,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b01000000,
	0b00000000, //}}}
 //{{{ 2F /
	4,
	0b00010000,
	0b00010000,
	0b00100000,
	0b00100000,
	0b01000000,
	0b01000000,
	0b00000000, //}}}
 //{{{ 30 0
	5,
	0b00111000,
	0b01001000,
	0b01001000,
	0b01001000,
	0b01001000,
	0b01111000,
	0b00000000, //}}}
 //{{{ 31 1
	4,
	0b00100000,
	0b01100000,
	0b00100000,
	0b00100000,
	0b00100000,
	0b01110000,
	0b00000000, //}}}
 //{{{ 32 2
	5,
	0b00110000,
	0b01001000,
	0b00010000,
	0b00100000,
	0b01000000,
	0b01111000,
	0b00000000, //}}}
 //{{{ 33 3
	4,
	0b01110000,
	0b00010000,
	0b01100000,
	0b00010000,
	0b00010000,
	0b01110000,
	0b00000000, //}}}
 //{{{ 34 4
	5,
	0b00011000,
	0b00101000,
	0b01001000,
	0b01111000,
	0b00001000,
	0b00001000,
	0b00000000, //}}}
 //{{{ 35 5
	5,
	0b01111000,
	0b01000000,
	0b01110000,
	0b00001000,
	0b00001000,
	0b01110000,
	0b00000000, //}}}
 //{{{ 36 6
	5,
	0b00111000,
	0b01000000,
	0b01110000,
	0b01001000,
	0b01001000,
	0b00110000,
	0b00000000, //}}}
 //{{{ 37 7
	5,
	0b01111000,
	0b00001000,
	0b00010000,
	0b00100000,
	0b01000000,
	0b01000000,
	0b00000000, //}}}
 //{{{ 38 8
	5,
	0b00110000,
	0b01001000,
	0b00110000,
	0b01001000,
	0b01001000,
	0b00110000,
	0b00000000, //}}}
 //{{{ 39 9
	5,
	0b00110000,
	0b01001000,
	0b00111000,
	0b00001000,
	0b00001000,
	0b00110000,
	0b00000000, //}}}
 //{{{ 3A :
	2,
	0b00000000,
	0b01000000,
	0b00000000,
	0b00000000,
	0b01000000,
	0b00000000,
	0b00000000, //}}}
 //{{{ 3B ;
	3,
	0b00000000,
	0b00100000,
	0b00000000,
	0b00000000,
	0b00100000,
	0b01000000,
	0b00000000, //}}}
 //{{{ 3C <
	4,
	0b00000000,
	0b00010000,
	0b00100000,
	0b01000000,
	0b00100000,
	0b00010000,
	0b00000000, //}}}
 //{{{ 3D =
	4,
	0b00000000,
	0b00000000,
	0b01110000,
	0b00000000,
	0b01110000,
	0b00000000,
	0b00000000, //}}}
 //{{{ 3E >
	4,
	0b00000000,
	0b01000000,
	0b00100000,
	0b00010000,
	0b00100000,
	0b01000000,
	0b00000000, //}}}
 //{{{ 3F ?
	4,
	0b00100000,
	0b01010000,
	0b00010000,
	0b00100000,
	0b00000000,
	0b00100000,
	0b00000000, //}}}
 //{{{ 40 @
	5,
	0b00110000,
	0b01001000,
	0b01011000,
	0b01011000,
	0b01000000,
	0b00111000,
	0b00000000, //}}}
 //{{{ 41 A
	5,
	0b00110000,
	0b01001000,
	0b01001000,
	0b01111000,
	0b01001000,
	0b01001000,
	0b00000000, //}}}
 //{{{ 42 B
	5,
	0b01110000,
	0b01001000,
	0b01110000,
	0b01001000,
	0b01001000,
	0b01110000,
	0b00000000, //}}}
 //{{{ 43 C
	5,
	0b00110000,
	0b01001000,
	0b01000000,
	0b01000000,
	0b01001000,
	0b00110000,
	0b00000000, //}}}
 //{{{ 44 D
	5,
	0b01110000,
	0b01001000,
	0b01001000,
	0b01001000,
	0b01001000,
	0b01110000,
	0b00000000, //}}}
 //{{{ 45 E
	5,
	0b01111000,
	0b01000000,
	0b01110000,
	0b01000000,
	0b01000000,
	0b01111000,
	0b00000000, //}}}
 //{{{ 46 F
	5,
	0b01111000,
	0b01000000,
	0b01000000,
	0b01110000,
	0b01000000,
	0b01000000,
	0b00000000, //}}}
 //{{{ 47 G
	5,
	0b00110000,
	0b01001000,
	0b01000000,
	0b01011000,
	0b01001000,
	0b00111000,
	0b00000000, //}}}
 //{{{ 48 H
	5,
	0b01001000,
	0b01001000,
	0b01111000,
	0b01001000,
	0b01001000,
	0b01001000,
	0b00000000, //}}}
 //{{{ 49 I
	4,
	0b01110000,
	0b00100000,
	0b00100000,
	0b00100000,
	0b00100000,
	0b01110000,
	0b00000000, //}}}
 //{{{ 4A J
	5,
	0b00111000,
	0b00010000,
	0b00010000,
	0b00010000,
	0b01010000,
	0b01110000,
	0b00000000, //}}}
 //{{{ 4B K
	5,
	0b01001000,
	0b01010000,
	0b01100000,
	0b01010000,
	0b01001000,
	0b01001000,
	0b00000000, //}}}
 //{{{ 4C L
	5,
	0b01000000,
	0b01000000,
	0b01000000,
	0b01000000,
	0b01000000,
	0b01111000,
	0b00000000, //}}}
 //{{{ 4D M
	6,
	0b01000100,
	0b01101100,
	0b01111100,
	0b01010100,
	0b01010100,
	0b01010100,
	0b00000000, //}}}
 //{{{ 4E N
	6,
	0b01000100,
	0b01100100,
	0b01110100,
	0b01011100,
	0b01001100,
	0b01000100,
	0b00000000, //}}}
 //{{{ 4F O
	5,
	0b01111000,
	0b01001000,
	0b01001000,
	0b01001000,
	0b01001000,
	0b01111000,
	0b00000000, //}}}
 //{{{ 50 P
	5,
	0b01110000,
	0b01001000,
	0b01001000,
	0b01110000,
	0b01000000,
	0b01000000,
	0b00000000, //}}}
 //{{{ 51 Q
	6,
	0b00110000,
	0b01001000,
	0b01001000,
	0b01001000,
	0b01011000,
	0b00110100,
	0b00000000, //}}}
 //{{{ 52 R
	5,
	0b01110000,
	0b01001000,
	0b01001000,
	0b01110000,
	0b01001000,
	0b01001000,
	0b00000000, //}}}
 //{{{ 53 S
	5,
	0b00111000,
	0b01000000,
	0b00110000,
	0b00001000,
	0b00001000,
	0b01110000,
	0b00000000, //}}}
 //{{{ 54 T
	6,
	0b01111100,
	0b00010000,
	0b00010000,
	0b00010000,
	0b00010000,
	0b00010000,
	0b00000000, //}}}
 //{{{ 55 U
	5,
	0b01001000,
	0b01001000,
	0b01001000,
	0b01001000,
	0b01001000,
	0b00110000,
	0b00000000, //}}}
 //{{{ 56 V
	6,
	0b01000100,
	0b01000100,
	0b01000100,
	0b01000100,
	0b00101000,
	0b00010000,
	0b00000000, //}}}
 //{{{ 57 W
	6,
	0b01000100,
	0b01000100,
	0b01000100,
	0b01010100,
	0b01010100,
	0b00101000,
	0b00000000, //}}}
 //{{{ 58 X
	5,
	0b01001000,
	0b01001000,
	0b00110000,
	0b00110000,
	0b01001000,
	0b01001000,
	0b00000000, //}}}
 //{{{ 59 Y
	6,
	0b01000100,
	0b01000100,
	0b00101000,
	0b00010000,
	0b00010000,
	0b00010000,
	0b00000000, //}}}
 //{{{ 5A Z
	5,
	0b01111000,
	0b00001000,
	0b00010000,
	0b00100000,
	0b01000000,
	0b01111000,
	0b00000000, //}}}
 //{{{ 5B [
	3,
	0b01100000,
	0b01000000,
	0b01000000,
	0b01000000,
	0b01000000,
	0b01100000,
	0b00000000, //}}}
 //{{{ 5C \ backslash 
	4,
	0b01000000,
	0b01000000,
	0b00100000,
	0b00100000,
	0b00010000,
	0b00010000,
	0b00000000, //}}}
 //{{{ 5D ]
	3,
	0b01100000,
	0b00100000,
	0b00100000,
	0b00100000,
	0b00100000,
	0b01100000,
	0b00000000, //}}}
 //{{{ 5E ^
	4,
	0b00100000,
	0b01010000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000, //}}}
 //{{{ 5F _
	4,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b01110000,
	0b00000000, //}}}
 //{{{ 60 `
	3,
	0b01000000,
	0b00100000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000, //}}}
 //{{{ 61 a
	5,
	0b00000000,
	0b00000000,
	0b00111000,
	0b01001000,
	0b01011000,
	0b01101000,
	0b00000000, //}}}
 //{{{ 62 b
	5,
	0b01000000,
	0b01000000,
	0b01110000,
	0b01001000,
	0b01001000,
	0b01110000,
	0b00000000, //}}}
 //{{{ 63 c
	4,
	0b00000000,
	0b00000000,
	0b00110000,
	0b01000000,
	0b01000000,
	0b00110000,
	0b00000000, //}}}
 //{{{ 64 d
	5,
	0b00001000,
	0b00001000,
	0b00111000,
	0b01001000,
	0b01001000,
	0b00111000,
	0b00000000, //}}}
 //{{{ 65 e
	5,
	0b00000000,
	0b00000000,
	0b00110000,
	0b01111000,
	0b01000000,
	0b00110000,
	0b00000000, //}}}
 //{{{ 66 f
	4,
	0b00110000,
	0b00100000,
	0b01110000,
	0b00100000,
	0b00100000,
	0b00100000,
	0b00000000, //}}}
 //{{{ 67 g
	5,
	0b00000000,
	0b00000000,
	0b00111000,
	0b01001000,
	0b00111000,
	0b00001000,
	0b01110000, //}}}
 //{{{ 68 h
	5,
	0b01000000,
	0b01000000,
	0b01110000,
	0b01001000,
	0b01001000,
	0b01001000,
	0b00000000, //}}}
 //{{{ 69 i
	2,
	0b01000000,
	0b00000000,
	0b01000000,
	0b01000000,
	0b01000000,
	0b01000000,
	0b00000000, //}}}
 //{{{ 6A j
	3,
	0b00100000,
	0b00000000,
	0b00100000,
	0b00100000,
	0b00100000,
	0b00100000,
	0b01000000, //}}}
 //{{{ 6B k
	5,
	0b01000000,
	0b01000000,
	0b01010000,
	0b01100000,
	0b01010000,
	0b01001000,
	0b00000000, //}}}
 //{{{ 6C l
	3,
	0b01100000,
	0b00100000,
	0b00100000,
	0b00100000,
	0b00100000,
	0b00100000,
	0b00000000, //}}}
 //{{{ 6D m
	6,
	0b00000000,
	0b00000000,
	0b01101100,
	0b01010100,
	0b01010100,
	0b01010100,
	0b00000000, //}}}
 //{{{ 6E n
	5,
	0b00000000,
	0b00000000,
	0b01110000,
	0b01001000,
	0b01001000,
	0b01001000,
	0b00000000, //}}}
 //{{{ 6F o
	5,
	0b00000000,
	0b00000000,
	0b00110000,
	0b01001000,
	0b01001000,
	0b00110000,
	0b00000000, //}}}
 //{{{ 70 p
	5,
	0b00000000,
	0b00000000,
	0b01110000,
	0b01001000,
	0b01001000,
	0b01110000,
	0b01000000, //}}}
 //{{{ 71 q
	5,
	0b00000000,
	0b00000000,
	0b00111000,
	0b01001000,
	0b01001000,
	0b00111000,
	0b00001000, //}}}
 //{{{ 72 r
	5,
	0b00000000,
	0b00000000,
	0b01110000,
	0b01001000,
	0b01000000,
	0b01000000,
	0b00000000, //}}}
 //{{{ 73 s
	4,
	0b00000000,
	0b00000000,
	0b01110000,
	0b01100000,
	0b00010000,
	0b01110000,
	0b00000000, //}}}
 //{{{ 74 t
	4,
	0b00100000,
	0b00100000,
	0b01110000,
	0b00100000,
	0b00100000,
	0b00110000,
	0b00000000, //}}}
 //{{{ 75 u
	5,
	0b00000000,
	0b00000000,
	0b01001000,
	0b01001000,
	0b01001000,
	0b00111000,
	0b00000000, //}}}
 //{{{ 76 v
	4,
	0b00000000,
	0b00000000,
	0b01010000,
	0b01010000,
	0b01010000,
	0b00100000,
	0b00000000, //}}}
 //{{{ 77 w
	6,
	0b00000000,
	0b00000000,
	0b01000100,
	0b01000100,
	0b01010100,
	0b00101000,
	0b00000000, //}}}
 //{{{ 78 x
	5,
	0b00000000,
	0b00000000,
	0b01001000,
	0b00110000,
	0b00110000,
	0b01001000,
	0b00000000, //}}}
 //{{{ 79 y
	4,
	0b00000000,
	0b00000000,
	0b01010000,
	0b01010000,
	0b01110000,
	0b00010000,
	0b01100000, //}}}
 //{{{ 7A z
	5,
	0b00000000,
	0b00000000,
	0b01111000,
	0b00010000,
	0b00100000,
	0b01111000,
	0b00000000, //}}}
 //{{{ 7B {
	4,
	0b00000000,
	0b00110000,
	0b00100000,
	0b01000000,
	0b00100000,
	0b00110000,
	0b00000000, //}}}
 //{{{ 7C |
	2,
	0b00000000,
	0b01000000,
	0b01000000,
	0b00000000,
	0b01000000,
	0b01000000,
	0b00000000, //}}}
 //{{{ 7D }
	4,
	0b00000000,
	0b01100000,
	0b00100000,
	0b00010000,
	0b00100000,
	0b01100000,
	0b00000000, //}}}
 //{{{ 7E ~
	5,
	0b00101000,
	0b01010000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000, //}}}
 //{{{ 7F 
	0,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000, //}}}
};
//}}}
#ifdef USE_8859_1
//{{{
ECONST unsigned char Font_Latin_1_5x7[128*7] =
{
 //{{{ A0 NO-BREAK SPACE
	3,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
//}}}
 //{{{ A1 INVERTED EXCLAMATION MARK
	3,
	0b01000000,
	0b00000000,
	0b01000000,
	0b01000000,
	0b01000000,
	0b01000000,
	0b00000000,
//}}}
 //{{{ A2 CENT SIGN
	5,
	0b00010000,
	0b00111000,
	0b01010000,
	0b01010000,
	0b00111000,
	0b00010000,
	0b00000000,
//}}}
 //{{{ A3 POUND SIGN
	5,
	0b00011000,
	0b00100000,
	0b01110000,
	0b00100000,
	0b00100000,
	0b00111100,
	0b00000000,
//}}}
 //{{{ A4 CURRENCY SIGN
	6,
	0b00000000,
	0b01001000,
	0b00110000,
	0b00110000,
	0b01001000,
	0b00000000,
	0b00000000,
//}}}
 //{{{ A5 YEN SIGN
	6,
	0b01000100,
	0b00101000,
	0b01111100,
	0b00010000,
	0b01111100,
	0b00010000,
	0b00000000,
//}}}
 //{{{ A6 BROKEN BAR
	3,
	0b00000000,
	0b01000000,
	0b01000000,
	0b00000000,
	0b01000000,
	0b01000000,
	0b00000000,
//}}}
 //{{{ A7 SECTION SIGN
	5,
	0b00110000,
	0b01000000,
	0b01111000,
	0b01111000,
	0b00001000,
	0b00110000,
	0b00000000,
//}}}
 //{{{ A8 DIAERESIS
	4,
	0b01010000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
//}}}
 //{{{ A9 COPYRIGHT SIGN
	8,
	0b00100010,
	0b01011101,
	0b01010001,
	0b01010001,
	0b01011101,
	0b00100010,
	0b00000000,
//}}}
 //{{{ AA FEMININE ORDINAL INDICATOR
	4,
	0b00110000,
	0b01010000,
	0b01010000,
	0b00110000,
	0b00000000,
	0b01110000,
	0b00000000,
//}}}
 //{{{ AB LEFT-POINTING DOUBLE ANGLE QUOTATION MARK
	6,
	0b00000000,
	0b00010100,
	0b00101000,
	0b01010000,
	0b00101000,
	0b00010100,
	0b00000000,
//}}}
 //{{{ AC NOT SIGN
	5,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b01111000,
	0b00001000,
	0b00000000,
//}}}
 //{{{ AD SOFT HYPHEN
	5,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b01111000,
	0b00000000,
//}}}
 //{{{ AE REGISTERED SIGN
	8,
	0b00100010,
	0b01011001,
	0b01010101,
	0b01011001,
	0b01010101,
	0b00110110,
	0b00000000,
//}}}
 //{{{ AF MACRON
	5,
	0b01111000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
//}}}
 //{{{ B0 DEGREE SIGN
	4,
	0b01110000,
	0b01010000,
	0b01110000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
//}}}
 //{{{ B1 PLUS-MINUS SIGN
	4,
	0b00000000,
	0b00100000,
	0b01110000,
	0b00100000,
	0b00000000,
	0b01110000,
	0b00000000,
//}}}
 //{{{ B2 SUPERSCRIPT TWO
	3,
	0b01100000,
	0b00100000,
	0b01000000,
	0b01100000,
	0b00000000,
	0b00000000,
	0b00000000,
//}}}
 //{{{ B3 SUPERSCRIPT THREE
	3,
	0b01100000,
	0b00100000,
	0b01000000,
	0b00100000,
	0b01100000,
	0b00000000,
	0b00000000,
//}}}
 //{{{ B4 ACUTE ACCENT
	3,
	0b00100000,
	0b01000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
//}}}
 //{{{ B5 MICRO SIGN
	4,
	0b00000000,
	0b00000000,
	0b01010000,
	0b01010000,
	0b01110000,
	0b01000000,
	0b00000000,
//}}}
 //{{{ B6 PILCROW SIGN
	6,
	0b00111100,
	0b01110100,
	0b00110100,
	0b00010100,
	0b00010100,
	0b00010100,
	0b00000000,
//}}}
 //{{{ B7 MIDDLE DOT
	3,
	0b00000000,
	0b00000000,
	0b01100000,
	0b01100000,
	0b00000000,
	0b00000000,
	0b00000000,
//}}}
 //{{{ B8 CEDILLA
	3,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00100000,
	0b01000000,
	0b00000000,
//}}}
 //{{{ B9 SUPERSCRIPT ONE
	3,
	0b00100000,
	0b01100000,
	0b00100000,
	0b00100000,
	0b00000000,
	0b00000000,
	0b00000000,
//}}}
 //{{{ BA MASCULINE ORDINAL INDICATOR
	4,
	0b00100000,
	0b01010000,
	0b00100000,
	0b00000000,
	0b01110000,
	0b00000000,
	0b00000000,
//}}}
 //{{{ BB RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK
	6,
	0b00000000,
	0b01010000,
	0b00101000,
	0b00010100,
	0b00101000,
	0b01010000,
	0b00000000,
//}}}
 //{{{ BC VULGAR FRACTION ONE QUARTER
	7,
	0b01000100,
	0b01001000,
	0b01010000,
	0b00101010,
	0b01001110,
	0b00000010,
	0b00000000,
//}}}
 //{{{ BD VULGAR FRACTION ONE HALF
	0,
	0b01000100,
	0b01001000,
	0b01010110,
	0b00100010,
	0b01000100,
	0b00000110,
	0b00000000,
//}}}
 //{{{ BE VULGAR FRACTION THREE QUARTERS
	4,
	0b00000000, // No *way* this can be legible at this size
	0b01110000,
	0b01010000,
	0b01010000,
	0b01010000,
	0b01110000,
	0b00000000,
//}}}
 //{{{ BF INVERTED QUESTION MARK
	4,
	0b00100000,
	0b00000000,
	0b00100000,
	0b01000000,
	0b01010000,
	0b00100000,
	0b00000000,
//}}}
 //{{{ C0 LATIN CAPITAL LETTER A WITH GRAVE
	5,
	0b00100000,
	0b00010000,
	0b00110000,
	0b01001000,
	0b01111000,
	0b01001000,
	0b00000000,
//}}}
 //{{{ C1 LATIN CAPITAL LETTER A WITH ACUTE
	0,
	0b00010000,
	0b00100000,
	0b00110000,
	0b01001000,
	0b01111000,
	0b01001000,
	0b00000000,
//}}}
 //{{{ C2 LATIN CAPITAL LETTER A WITH CIRCUMFLEX
	5,
	0b00010000,
	0b00101000,
	0b00110000,
	0b01001000,
	0b01111000,
	0b01001000,
	0b00000000,
//}}}
 //{{{ C3 LATIN CAPITAL LETTER A WITH TILDE
	5,
	0b00101000,
	0b01010000,
	0b00110000,
	0b01001000,
	0b01111000,
	0b01001000,
	0b00000000,
//}}}
 //{{{ C4 LATIN CAPITAL LETTER A WITH DIAERESIS
	5,
	0b00101000,
	0b00000000,
	0b00110000,
	0b01001000,
	0b01111000,
	0b01001000,
	0b00000000,
//}}}
 //{{{ C5 LATIN CAPITAL LETTER A WITH RING ABOVE
	5,
	0b00110000,
	0b00000000,
	0b00110000,
	0b01001000,
	0b01111000,
	0b01001000,
	0b00000000,
//}}}
 //{{{ C6 LATIN CAPITAL LETTER AE
	6,
	0b00111100,
	0b01010000,
	0b01111100,
	0b01010000,
	0b01010000,
	0b01011100,
	0b00000000,
//}}}
 //{{{ C7 LATIN CAPITAL LETTER C WITH CEDILLA
	4,
	0b01110000,
	0b01000000,
	0b01000000,
	0b01000000,
	0b01110000,
	0b00100000,
	0b01000000,
//}}}
 //{{{ C8 LATIN CAPITAL LETTER E WITH GRAVE
	4,
	0b00100000,
	0b01110000,
	0b01000000,
	0b01100000,
	0b01000000,
	0b01110000,
	0b00000000,
//}}}
 //{{{ C9 LATIN CAPITAL LETTER E WITH ACUTE
	4,
	0b00100000,
	0b01110000,
	0b01000000,
	0b01100000,
	0b01000000,
	0b01110000,
	0b00000000,
//}}}
 //{{{ CA LATIN CAPITAL LETTER E WITH CIRCUMFLEX
	4,
	0b00100000,
	0b01110000,
	0b01000000,
	0b01100000,
	0b01000000,
	0b01110000,
	0b00000000,
//}}}
 //{{{ CB LATIN CAPITAL LETTER E WITH DIAERESIS
	4,
	0b01010000,
	0b01110000,
	0b01000000,
	0b01100000,
	0b01000000,
	0b01110000,
	0b00000000,
//}}}
 //{{{ CC LATIN CAPITAL LETTER I WITH GRAVE
	3,
	0b01100000,
	0b00000000,
	0b00100000,
	0b00100000,
	0b00100000,
	0b00100000,
	0b00000000,
//}}}
 //{{{ CD LATIN CAPITAL LETTER I WITH ACUTE
	3,
	0b01100000,
	0b00000000,
	0b01000000,
	0b01000000,
	0b01000000,
	0b01000000,
	0b00000000,
//}}}
 //{{{ CE LATIN CAPITAL LETTER I WITH CIRCUMFLEX
	4,
	0b01110000,
	0b00000000,
	0b00100000,
	0b00100000,
	0b00100000,
	0b00100000,
	0b00000000,
//}}}
 //{{{ CF LATIN CAPITAL LETTER I WITH DIAERESIS
	4,
	0b01010000,
	0b00000000,
	0b00100000,
	0b00100000,
	0b00100000,
	0b00100000,
	0b00000000,
//}}}
 //{{{ D0 LATIN CAPITAL LETTER ETH (Icelandic)
	6,
	0b00111000,
	0b00100100,
	0b01110100,
	0b00100100,
	0b00100100,
	0b00111000,
	0b00000000,
//}}}
 //{{{ D1 LATIN CAPITAL LETTER N WITH TILDE
	5,
	0b00110000,
	0b00000000,
	0b01001000,
	0b01101000,
	0b01011000,
	0b01001000,
	0b00000000,
//}}}
 //{{{ D2 LATIN CAPITAL LETTER O WITH GRAVE
	4,
	0b01100000,
	0b00000000,
	0b01110000,
	0b01010000,
	0b01010000,
	0b01110000,
	0b00000000,
//}}}
 //{{{ D3 LATIN CAPITAL LETTER O WITH ACUTE
	4,
	0b00110000,
	0b00000000,
	0b01110000,
	0b01010000,
	0b01010000,
	0b01110000,
	0b00000000,
//}}}
 //{{{ D4 LATIN CAPITAL LETTER O WITH CIRCUMFLEX
	4,
	0b01110000,
	0b00000000,
	0b01110000,
	0b01010000,
	0b01010000,
	0b01110000,
	0b00000000,
//}}}
 //{{{ D5 LATIN CAPITAL LETTER O WITH TILDE
	4,
	0b01110000,
	0b00000000,
	0b01110000,
	0b01010000,
	0b01010000,
	0b01110000,
	0b00000000,
//}}}
 //{{{ D6 LATIN CAPITAL LETTER O WITH DIAERESIS
	4,
	0b01010000,
	0b00000000,
	0b01110000,
	0b01010000,
	0b01010000,
	0b01110000,
	0b00000000,
//}}}
 //{{{ D7 MULTIPLICATION SIGN
	4,
	0b00000000,
	0b00000000,
	0b01010000,
	0b00100000,
	0b01010000,
	0b00000000,
	0b00000000,
//}}}
 //{{{ D8 LATIN CAPITAL LETTER O WITH STROKE
	5,
	0b01111000,
	0b01001000,
	0b01011000,
	0b01101000,
	0b01001000,
	0b01111000,
	0b00000000,
//}}}
 //{{{ D9 LATIN CAPITAL LETTER U WITH GRAVE
	4,
	0b00110000,
	0b00000000,
	0b01010000,
	0b01010000,
	0b01010000,
	0b01110000,
	0b00000000,
//}}}
 //{{{ DA LATIN CAPITAL LETTER U WITH ACUTE
	4,
	0b01100000,
	0b00000000,
	0b01010000,
	0b01010000,
	0b01010000,
	0b01110000,
	0b00000000,
//}}}
 //{{{ DB LATIN CAPITAL LETTER U WITH CIRCUMFLEX
	4,
	0b01110000,
	0b00000000,
	0b01010000,
	0b01010000,
	0b01010000,
	0b01110000,
	0b00000000,
//}}}
 //{{{ DC LATIN CAPITAL LETTER U WITH DIAERESIS
	4,
	0b01010000,
	0b00000000,
	0b01010000,
	0b01010000,
	0b01010000,
	0b01110000,
	0b00000000,
//}}}
 //{{{ DD LATIN CAPITAL LETTER Y WITH ACUTE
	4,
	0b00110000,
	0b00000000,
	0b01010000,
	0b01010000,
	0b00100000,
	0b00100000,
	0b00000000,
//}}}
 //{{{ DE LATIN CAPITAL LETTER THORN (Icelandic)
	5,
	0b01000000,
	0b01110000,
	0b01001000,
	0b01001000,
	0b01110000,
	0b01000000,
	0b00000000,
//}}}
 //{{{ DF LATIN SMALL LETTER SHARP S (German)
	5,
	0b01100000,
	0b01010000,
	0b01110000,
	0b01001000,
	0b01001000,
	0b01110000,
	0b00000000,
//}}}
 //{{{ E0 LATIN SMALL LETTER A WITH GRAVE
	5,
	0b00011000,
	0b00000000,
	0b00111000,
	0b01001000,
	0b01011000,
	0b01101000,
	0b00000000,
//}}}
 //{{{ E1 LATIN SMALL LETTER A WITH ACUTE
	5,
	0b00110000,
	0b00000000,
	0b00111000,
	0b01001000,
	0b01011000,
	0b01101000,
	0b00000000,
//}}}
 //{{{ E2 LATIN SMALL LETTER A WITH CIRCUMFLEX
	5,
	0b00111000,
	0b00000000,
	0b00111000,
	0b01001000,
	0b01011000,
	0b01101000,
	0b00000000,
//}}}
 //{{{ E3 LATIN SMALL LETTER A WITH TILDE
	5,
	0b00111000,
	0b00000000,
	0b00111000,
	0b01001000,
	0b01011000,
	0b01101000,
	0b00000000,
//}}}
 //{{{ E4 LATIN SMALL LETTER A WITH DIAERESIS
	5,
	0b00101000,
	0b00000000,
	0b00111000,
	0b01001000,
	0b01011000,
	0b01101000,
	0b00000000,
//}}}
 //{{{ E5 LATIN SMALL LETTER A WITH RING ABOVE
	5,
	0b00010000,
	0b00000000,
	0b00111000,
	0b01001000,
	0b01011000,
	0b01101000,
	0b00000000,
//}}}
 //{{{ E6 LATIN SMALL LETTER AE
	6,
	0b00000000,
	0b01111100,
	0b00010100,
	0b01111100,
	0b01010000,
	0b01111100,
	0b00000000,
//}}}
 //{{{ E7 LATIN SMALL LETTER C WITH CEDILLA
	4,
	0b00000000,
	0b01110000,
	0b01000000,
	0b01000000,
	0b01110000,
	0b00100000,
	0b01000000,
//}}}
 //{{{ E8 LATIN SMALL LETTER E WITH GRAVE
	5,
	0b01100000,
	0b00000000,
	0b00110000,
	0b01111000,
	0b01000000,
	0b00110000,
	0b00000000,
//}}}
 //{{{ E9 LATIN SMALL LETTER E WITH ACUTE
	5,
	0b00011000,
	0b00000000,
	0b00110000,
	0b01111000,
	0b01000000,
	0b00110000,
	0b00000000,
//}}}
 //{{{ EA LATIN SMALL LETTER E WITH CIRCUMFLEX
	5,
	0b00110000,
	0b00000000,
	0b00110000,
	0b01111000,
	0b01000000,
	0b00110000,
	0b00000000,
//}}}
 //{{{ EB LATIN SMALL LETTER E WITH DIAERESIS
	5,
	0b00101000,
	0b00000000,
	0b00110000,
	0b01111000,
	0b01000000,
	0b00110000,
	0b00000000,
//}}}
 //{{{ EC LATIN SMALL LETTER I WITH GRAVE
	3,
	0b01000000,
	0b00100000,
	0b00000000,
	0b00100000,
	0b00100000,
	0b00100000,
	0b00000000,
//}}}
 //{{{ ED LATIN SMALL LETTER I WITH ACUTE
	3,
	0b00100000,
	0b01000000,
	0b00000000,
	0b01000000,
	0b01000000,
	0b01000000,
	0b00000000,
//}}}
 //{{{ EE LATIN SMALL LETTER I WITH CIRCUMFLEX
	4,
	0b00100000,
	0b01010000,
	0b00000000,
	0b00100000,
	0b00100000,
	0b00100000,
	0b00000000,
//}}}
 //{{{ EF LATIN SMALL LETTER I WITH DIAERESIS
	4,
	0b01010000,
	0b00000000,
	0b00100000,
	0b00100000,
	0b00100000,
	0b00100000,
	0b00000000,
//}}}
 //{{{ F0 LATIN SMALL LETTER ETH (Icelandic)
	4,
	0b01010000,
	0b00100000,
	0b01010000,
	0b00110000,
	0b01010000,
	0b01110000,
	0b00000000,
//}}}
 //{{{ F1 LATIN SMALL LETTER N WITH TILDE
	5,
	0b01010000,
	0b00101000,
	0b00000000,
	0b00110000,
	0b01001000,
	0b01001000,
	0b00000000,
//}}}
 //{{{ F2 LATIN SMALL LETTER O WITH GRAVE
	5,
	0b01100000,
	0b00000000,
	0b00110000,
	0b01001000,
	0b01001000,
	0b00110000,
	0b00000000,
//}}}
 //{{{ F3 LATIN SMALL LETTER O WITH ACUTE
	5,
	0b00011000,
	0b00000000,
	0b00110000,
	0b01001000,
	0b01001000,
	0b00110000,
	0b00000000,
//}}}
 //{{{ F4 LATIN SMALL LETTER O WITH CIRCUMFLEX
	5,
	0b00110000,
	0b00000000,
	0b00110000,
	0b01001000,
	0b01001000,
	0b00110000,
	0b00000000,
//}}}
 //{{{ F5 LATIN SMALL LETTER O WITH TILDE
	5,
	0b00110000,
	0b00000000,
	0b00110000,
	0b01001000,
	0b01001000,
	0b00110000,
	0b00000000,
//}}}
 //{{{ F6 LATIN SMALL LETTER O WITH DIAERESIS
	5,
	0b00101000,
	0b00000000,
	0b00110000,
	0b01001000,
	0b01001000,
	0b00110000,
	0b00000000,
//}}}
 //{{{ F7 DIVISION SIGN
	4,
	0b00000000,
	0b00100000,
	0b00000000,
	0b01110000,
	0b00000000,
	0b00100000,
	0b00000000,
//}}}
 //{{{ F8 LATIN SMALL LETTER O WITH STROKE
	5,
	0b00000000,
	0b01111000,
	0b01011000,
	0b01101000,
	0b01001000,
	0b01111000,
	0b00000000,
//}}}
 //{{{ F9 LATIN SMALL LETTER U WITH GRAVE
	4,
	0b01100000,
	0b00000000,
	0b01010000,
	0b01010000,
	0b01010000,
	0b01110000,
	0b00000000,
//}}}
 //{{{ FA LATIN SMALL LETTER U WITH ACUTE
	4,
	0b00110000,
	0b00000000,
	0b01010000,
	0b01010000,
	0b01010000,
	0b01110000,
	0b00000000,
//}}}
 //{{{ FB LATIN SMALL LETTER U WITH CIRCUMFLEX
	4,
	0b01110000,
	0b00000000,
	0b01010000,
	0b01010000,
	0b01010000,
	0b01110000,
	0b00000000,
//}}}
 //{{{ FC LATIN SMALL LETTER U WITH DIAERESIS
	4,
	0b01010000,
	0b00000000,
	0b01010000,
	0b01010000,
	0b01010000,
	0b01110000,
	0b00000000,
//}}}
 //{{{ FD LATIN SMALL LETTER Y WITH ACUTE
	4,
	0b00110000,
	0b00000000,
	0b01010000,
	0b01010000,
	0b00100000,
	0b01000000,
	0b00000000,
//}}}
 //{{{ FE LATIN SMALL LETTER THORN (Icelandic)
	4,
	0b01000000,
	0b01110000,
	0b01010000,
	0b01100000,
	0b01000000,
	0b01000000,
	0b00000000,
//}}}
 //{{{ FF LATIN SMALL LETTER Y WITH DIAERESIS
	4,
	0b01010000,
	0b00000000,
	0b01010000,
	0b01010000,
	0b00100000,
	0b01000000,
	0b00000000,
//}}}
};
//}}}
#endif
#ifdef USE_8859_2
//{{{
// Implements ISO Character Set 8859-2 (Latin 2)
ECONST unsigned char Font_Latin_2_4x6[128*7] = {
 //{{{ A0 NO-BREAK SPACE
    0,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000, //}}}
 //{{{ A1 LATIN CAPITAL LETTER A WITH OGONEK
    5,
	0b00100000,
	0b01010000,
	0b01110000,
	0b01010000,
	0b01010000,
	0b00011000, //}}}
 //{{{ A2 BREVE
    4,
	0b01010000,
	0b00100000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000, //}}}
 //{{{ A3 LATIN CAPITAL LETTER L WITH STROKE
    5,
	0b00100000,
	0b00110000,
	0b01100000,
	0b00100000,
	0b00111000,
	0b00000000, //}}}
 //{{{ A4 CURRENCY SIGN
    5,
	0b00000000,
	0b01001000,
	0b00110000,
	0b00110000,
	0b01001000,
	0b00000000, //}}}
 //{{{ A5 LATIN CAPITAL LETTER L WITH CARON
    4,
	0b01010000,
	0b00100000,
	0b01000000,
	0b01000000,
	0b01110000,
	0b00000000, //}}}
 //{{{ A6 LATIN CAPITAL LETTER S WITH ACUTE
    4,
	0b01110000,
	0b01000000,
	0b01110000,
	0b00010000,
	0b01110000,
	0b00000000, //}}}
 //{{{ A7 SECTION SIGN
    4,
	0b00110000,
	0b01100000,
	0b01110000,
	0b00110000,
	0b01100000,
	0b00000000, //}}}
 //{{{ A8 DIAERESIS
    4,
	0b01010000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000, //}}}
 //{{{ A9 LATIN CAPITAL LETTER S WITH CARON
    4,
	0b01110000,
	0b01000000,
	0b01110000,
	0b00010000,
	0b01110000,
	0b00000000, //}}}
 //{{{ AA LATIN CAPITAL LETTER S WITH CEDILLA
    4,
	0b01110000,
	0b01000000,
	0b01110000,
	0b00010000,
	0b01110000,
	0b00100000, //}}}
 //{{{ AB LATIN CAPITAL LETTER T WITH CARON
    4,
	0b01110000,
	0b00100000,
	0b00100000,
	0b00100000,
	0b00100000,
	0b00000000, //}}}
 //{{{ AC LATIN CAPITAL LETTER Z WITH ACUTE
    4,
	0b01110000,
	0b00010000,
	0b00100000,
	0b01000000,
	0b01110000,
	0b00000000, //}}}
 //{{{ AD SOFT HYPHEN
    4,
	0b00000000,
	0b00000000,
	0b01110000,
	0b00000000,
	0b00000000,
	0b00000000, //}}}
 //{{{ AE LATIN CAPITAL LETTER Z WITH CARON
    4,
	0b01110000,
	0b00010000,
	0b00100000,
	0b01000000,
	0b01110000,
	0b00000000, //}}}
 //{{{ AF LATIN CAPITAL LETTER Z WITH DOT ABOVE
    4,
	0b01110000,
	0b00010000,
	0b00100000,
	0b01000000,
	0b01110000,
	0b00000000, //}}}
 //{{{ B0 DEGREE SIGN
    5,
	0b00110000,
	0b01001000,
	0b01001000,
	0b00110000,
	0b00000000,
	0b00000000, //}}}
 //{{{ B1 LATIN SMALL LETTER A WITH OGONEK
    4,
	0b00000000,
	0b00110000,
	0b01010000,
	0b01010000,
	0b00110000,
	0b00100000, //}}}
 //{{{ B2 OGONEK
    3,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b01000000,
	0b00100000, //}}}
 //{{{ B3 LATIN SMALL LETTER L WITH STROKE
    4,
	0b00100000,
	0b00110000,
	0b00100000,
	0b01100000,
	0b00100000,
	0b00000000, //}}}
 //{{{ B4 ACUTE ACCENT
    3,
	0b00100000,
	0b01000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000, //}}}
 //{{{ B5 LATIN SMALL LETTER L WITH CARON
    3,
	0b01100000,
	0b00100000,
	0b00100000,
	0b00100000,
	0b00100000,
	0b00000000, //}}}
 //{{{ B6 LATIN SMALL LETTER S WITH ACUTE
    3,
	0b00000000,
	0b01100000,
	0b01000000,
	0b00100000,
	0b01100000,
	0b00000000, //}}}
 //{{{ B7 CARON
    4,
	0b01010000,
	0b00100000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000, //}}}
 //{{{ B8 CEDILLA
    3,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00100000,
	0b01000000, //}}}
 //{{{ B9 LATIN SMALL LETTER S WITH CARON
    3,
	0b00000000,
	0b01100000,
	0b01000000,
	0b00100000,
	0b01100000,
	0b00000000, //}}}
 //{{{ BA LATIN SMALL LETTER S WITH CEDILLA
    3,
	0b00000000,
	0b01100000,
	0b01000000,
	0b00100000,
	0b01100000,
	0b00100000, //}}}
 //{{{ BB LATIN SMALL LETTER T WITH CARON
    5,
	0b00101000,
	0b00100000,
	0b01110000,
	0b00100000,
	0b00100000,
	0b00000000, //}}}
 //{{{ BC LATIN SMALL LETTER Z WITH ACUTE
    5,
	0b00100000,
	0b01111000,
	0b00010000,
	0b00100000,
	0b01111000,
	0b00000000, //}}}
 //{{{ BD DOUBLE ACUTE ACCENT
    5,
	0b00101000,
	0b01010000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000, //}}}
 //{{{ BE LATIN SMALL LETTER Z WITH CARON
    5,
	0b00100000,
	0b01111000,
	0b00010000,
	0b00100000,
	0b01111000,
	0b00000000, //}}}
 //{{{ BF LATIN SMALL LETTER Z WITH DOT ABOVE
    5,
	0b00100000,
	0b01111000,
	0b00010000,
	0b00100000,
	0b01111000,
	0b00000000, //}}}
 //{{{ C0 LATIN CAPITAL LETTER R WITH ACUTE
    4,
	0b01100000,
	0b01010000,
	0b01100000,
	0b01010000,
	0b01010000,
	0b00000000, //}}}
 //{{{ C1 LATIN CAPITAL LETTER A WITH ACUTE
    4,
	0b00100000,
	0b01010000,
	0b01110000,
	0b01010000,
	0b01010000,
	0b00000000, //}}}
 //{{{ C2 LATIN CAPITAL LETTER A WITH CIRCUMFLEX
    4,
	0b00100000,
	0b01010000,
	0b01110000,
	0b01010000,
	0b01010000,
	0b00000000, //}}}
 //{{{ C3 LATIN CAPITAL LETTER A WITH BREVE
    4,
	0b00100000,
	0b01010000,
	0b01110000,
	0b01010000,
	0b01010000,
	0b00000000, //}}}
 //{{{ C4 LATIN CAPITAL LETTER A WITH DIAERESIS
    4,
	0b00100000,
	0b01010000,
	0b01110000,
	0b01010000,
	0b01010000,
	0b00000000, //}}}
 //{{{ C5 LATIN CAPITAL LETTER L WITH ACUTE
    4,
	0b00010000,
	0b01000000,
	0b01000000,
	0b01000000,
	0b01110000,
	0b00000000, //}}}
 //{{{ C6 LATIN CAPITAL LETTER C WITH ACUTE
    4,
	0b00000000,
	0b00110000,
	0b01000000,
	0b01000000,
	0b00110000,
	0b00000000, //}}}
 //{{{ C7 LATIN CAPITAL LETTER C WITH CEDILLA
    4,
	0b00000000,
	0b00110000,
	0b01000000,
	0b01000000,
	0b00110000,
	0b00100000, //}}}
 //{{{ C8 LATIN CAPITAL LETTER C WITH CARON
    4,
	0b00000000,
	0b00110000,
	0b01000000,
	0b01000000,
	0b00110000,
	0b00000000, //}}}
 //{{{ C9 LATIN CAPITAL LETTER E WITH ACUTE
    4,
	0b01110000,
	0b01000000,
	0b01100000,
	0b01000000,
	0b01110000,
	0b00000000, //}}}
 //{{{ CA LATIN CAPITAL LETTER E WITH OGONEK
    4,
	0b01110000,
	0b01000000,
	0b01100000,
	0b01000000,
	0b01110000,
	0b00010000, //}}}
 //{{{ CB LATIN CAPITAL LETTER E WITH DIAERESIS
    4,
	0b01110000,
	0b01000000,
	0b01100000,
	0b01000000,
	0b01110000,
	0b00000000, //}}}
 //{{{ CC LATIN CAPITAL LETTER E WITH CARON
    4,
	0b01110000,
	0b01000000,
	0b01100000,
	0b01000000,
	0b01110000,
	0b00000000, //}}}
 //{{{ CD LATIN CAPITAL LETTER I WITH ACUTE
    3,
	0b00100000,
	0b01000000,
	0b01000000,
	0b01000000,
	0b01000000,
	0b00000000, //}}}
 //{{{ CE LATIN CAPITAL LETTER I WITH CIRCUMFLEX
    4,
	0b01010000,
	0b00100000,
	0b00100000,
	0b00100000,
	0b00100000,
	0b00000000, //}}}
 //{{{ CF LATIN CAPITAL LETTER D WITH CARON
    4,
	0b01100000,
	0b01010000,
	0b01010000,
	0b01010000,
	0b01100000,
	0b00000000, //}}}
 //{{{ D0 LATIN CAPITAL LETTER D WITH STROKE
    4,
	0b01100000,
	0b01010000,
	0b01010000,
	0b01010000,
	0b01100000,
	0b00000000, //}}}
 //{{{ D1 LATIN CAPITAL LETTER N WITH ACUTE
    5,
	0b01001000,
	0b01101000,
	0b01111000,
	0b01011000,
	0b01001000,
	0b00000000, //}}}
 //{{{ D2 LATIN CAPITAL LETTER N WITH CARON
    5,
	0b01001000,
	0b01101000,
	0b01111000,
	0b01011000,
	0b01001000,
	0b00000000, //}}}
 //{{{ D3 LATIN CAPITAL LETTER O WITH ACUTE
    4,
	0b01110000,
	0b01010000,
	0b01010000,
	0b01010000,
	0b01110000,
	0b00000000, //}}}
 //{{{ D4 LATIN CAPITAL LETTER O WITH CIRCUMFLEX
    4,
	0b01110000,
	0b01010000,
	0b01010000,
	0b01010000,
	0b01110000,
	0b00010000, //}}}
 //{{{ D5 LATIN CAPITAL LETTER O WITH DOUBLE ACUTE
    4,
	0b01110000,
	0b01010000,
	0b01010000,
	0b01010000,
	0b01110000,
	0b00000000, //}}}
 //{{{ D6 LATIN CAPITAL LETTER O WITH DIAERESIS
    4,
	0b01110000,
	0b01010000,
	0b01010000,
	0b01010000,
	0b01110000,
	0b00000000, //}}}
 //{{{ D7 MULTIPLICATION SIGN
    4,
	0b00000000,
	0b01010000,
	0b00100000,
	0b01010000,
	0b00000000,
	0b00000000, //}}}
 //{{{ D8 LATIN CAPITAL LETTER R WITH CARON
    0,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000, //}}}
 //{{{ D9 LATIN CAPITAL LETTER U WITH RING ABOVE
    0,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000, //}}}
 //{{{ DA LATIN CAPITAL LETTER U WITH ACUTE
    0,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000, //}}}
 //{{{ DB LATIN CAPITAL LETTER U WITH DOUBLE ACUTE
    0,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000, //}}}
 //{{{ DC LATIN CAPITAL LETTER U WITH DIAERESIS
    0,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000, //}}}
 //{{{ DD LATIN CAPITAL LETTER Y WITH ACUTE
    0,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000, //}}}
 //{{{ DE LATIN CAPITAL LETTER T WITH CEDILLA
    0,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000, //}}}
 //{{{ DF LATIN SMALL LETTER SHARP S
    0,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000, //}}}
 //{{{ E0 LATIN SMALL LETTER R WITH ACUTE
    0,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000, //}}}
 //{{{ E1 LATIN SMALL LETTER A WITH ACUTE
    0,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000, //}}}
 //{{{ E2 LATIN SMALL LETTER A WITH CIRCUMFLEX
    0,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000, //}}}
 //{{{ E3 LATIN SMALL LETTER A WITH BREVE
    0,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000, //}}}
 //{{{ E4 LATIN SMALL LETTER A WITH DIAERESIS
    0,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000, //}}}
 //{{{ E5 LATIN SMALL LETTER L WITH ACUTE
    0,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000, //}}}
 //{{{ E6 LATIN SMALL LETTER C WITH ACUTE
    0,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000, //}}}
 //{{{ E7 LATIN SMALL LETTER C WITH CEDILLA
    0,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000, //}}}
 //{{{ E8 LATIN SMALL LETTER C WITH CARON
    0,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000, //}}}
 //{{{ E9 LATIN SMALL LETTER E WITH ACUTE
    0,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000, //}}}
 //{{{ EA LATIN SMALL LETTER E WITH OGONEK
    0,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000, //}}}
 //{{{ EB LATIN SMALL LETTER E WITH DIAERESIS
    0,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000, //}}}
 //{{{ EC LATIN SMALL LETTER E WITH CARON
    0,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000, //}}}
 //{{{ ED LATIN SMALL LETTER I WITH ACUTE
    0,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000, //}}}
 //{{{ EE LATIN SMALL LETTER I WITH CIRCUMFLEX
    0,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000, //}}}
 //{{{ EF LATIN SMALL LETTER D WITH CARON
    0,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000, //}}}
 //{{{ F0 LATIN SMALL LETTER D WITH STROKE
    0,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000, //}}}
 //{{{ F1 LATIN SMALL LETTER N WITH ACUTE
    0,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000, //}}}
 //{{{ F2 LATIN SMALL LETTER N WITH CARON
    0,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000, //}}}
 //{{{ F3 LATIN SMALL LETTER O WITH ACUTE
    0,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000, //}}}
 //{{{ F4 LATIN SMALL LETTER O WITH CIRCUMFLEX
    0,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000, //}}}
 //{{{ F5 LATIN SMALL LETTER O WITH DOUBLE ACUTE
    0,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000, //}}}
 //{{{ F6 LATIN SMALL LETTER O WITH DIAERESIS
    0,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000, //}}}
 //{{{ F7 DIVISION SIGN
    0,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000, //}}}
 //{{{ F8 LATIN SMALL LETTER R WITH CARON
    0,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000, //}}}
 //{{{ F9 LATIN SMALL LETTER U WITH RING ABOVE
    0,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000, //}}}
 //{{{ FA LATIN SMALL LETTER U WITH ACUTE
    0,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000, //}}}
 //{{{ FB LATIN SMALL LETTER U WITH DOUBLE ACUTE
    0,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000, //}}}
 //{{{ FC LATIN SMALL LETTER U WITH DIAERESIS
    0,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000, //}}}
 //{{{ FD LATIN SMALL LETTER Y WITH ACUTE
    0,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000, //}}}
 //{{{ FE LATIN SMALL LETTER T WITH CEDILLA
    0,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000, //}}}
 //{{{ FF DOT ABOVE
    0,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000, //}}}
	};
//}}}
/// @todo Make Font_Latin_2_5x7
#endif
#ifdef USE_8859_5
//{{{
// Implements ISO Character Set 8859-5 (Cyrillic)
ECONST unsigned char Font_Cyrillic_4x6[128*7] = {
 //{{{ A0 = NO-BREAK SPACE
    0,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000, //}}}
 //{{{ A1 = CYRILLIC CAPITAL LETTER IO
    4,
	0b01110000,
	0b01000000,
	0b01100000,
	0b01000000,
	0b01110000,
	0b00000000, //}}}
 //{{{ A2 = CYRILLIC CAPITAL LETTER DJE
    5,
	0b01110000,
	0b00100000,
	0b00111000,
	0b00101000,
	0b00111000,
	0b00000000, //}}}
 //{{{ A3 = CYRILLIC CAPITAL LETTER GJE
    5,
	0b01111000,
	0b01001000,
	0b01000000,
	0b01000000,
	0b01000000,
	0b00000000, //}}}
 //{{{ A4 = CYRILLIC CAPITAL LETTER UKRAINIAN IE
    4,
	0b00110000,
	0b01000000,
	0b01110000,
	0b01000000,
	0b00110000,
	0b00000000, //}}}
 //{{{ A5 = CYRILLIC CAPITAL LETTER DZE
    4,
	0b01110000,
	0b01000000,
	0b01110000,
	0b00010000,
	0b01110000,
	0b00000000, //}}}
 //{{{ A6 = CYRILLIC CAPITAL LETTER BYELORUSSIAN-UKRAINIAN I
    4,
	0b01110000,
	0b00100000,
	0b00100000,
	0b00100000,
	0b01110000,
	0b00000000, //}}}
 //{{{ A7 = CYRILLIC CAPITAL LETTER YI
    4,
	0b01010000,
	0b00000000,
	0b01110000,
	0b00100000,
	0b01110000,
	0b00000000, //}}}
 //{{{ A8 = CYRILLIC CAPITAL LETTER JE
    5,
	0b01111000,
	0b00010000,
	0b00010000,
	0b01010000,
	0b01110000,
	0b00000000, //}}}
 //{{{ A9 = CYRILLIC CAPITAL LETTER LJE
    7,
	0b01111000,
	0b00101000,
	0b00101110,
	0b00101010,
	0b01101110,
	0b00000000, //}}}
 //{{{ AA = CYRILLIC CAPITAL LETTER NJE
    6,
	0b01010000,
	0b01010000,
	0b01111100,
	0b01010100,
	0b01011100,
	0b00000000, //}}}
 //{{{ AB = CYRILLIC CAPITAL LETTER TSHE
    5,
	0b01111000,
	0b00100000,
	0b00111000,
	0b00101000,
	0b00101000,
	0b00000000, //}}}
 //{{{ AC = CYRILLIC CAPITAL LETTER KJE
    4,
	0b01010000,
	0b01010000,
	0b01100000,
	0b01010000,
	0b01010000,
	0b00000000, //}}}
 //{{{ AD = SOFT HYPHEN
    4,
	0b00000000,
	0b00000000,
	0b01110000,
	0b00000000,
	0b00000000,
	0b00000000, //}}}
 //{{{ AE = CYRILLIC CAPITAL LETTER SHORT U
    4,
	0b01110000,
	0b00000000,
	0b01010000,
	0b00100000,
	0b01000000,
	0b00000000, //}}}
 //{{{ AF = CYRILLIC CAPITAL LETTER DZHE
    4,
	0b01010000,
	0b01010000,
	0b01010000,
	0b01110000,
	0b00100000,
	0b00000000, //}}}
 //{{{ B0 = CYRILLIC CAPITAL LETTER A
    4,
	0b00100000,
	0b01010000,
	0b01110000,
	0b01010000,
	0b01010000,
	0b00000000, //}}}
 //{{{ B1 = CYRILLIC CAPITAL LETTER BE
    4,
	0b01110000,
	0b01000000,
	0b01110000,
	0b01010000,
	0b01110000,
	0b00000000, //}}}
 //{{{ B2 = CYRILLIC CAPITAL LETTER VE
    4,
	0b01100000,
	0b01010000,
	0b01100000,
	0b01010000,
	0b01100000,
	0b00000000, //}}}
 //{{{ B3 = CYRILLIC CAPITAL LETTER GHE
    5,
	0b01111000,
	0b01000000,
	0b01000000,
	0b01000000,
	0b01000000,
	0b00000000, //}}}
 //{{{ B4 = CYRILLIC CAPITAL LETTER DE
    5,
	0b00111000,
	0b00101000,
	0b00101000,
	0b01111000,
	0b01001000,
	0b00000000, //}}}
 //{{{ B5 = CYRILLIC CAPITAL LETTER IE
    4,
	0b01110000,
	0b01000000,
	0b01100000,
	0b01000000,
	0b01110000,
	0b00000000, //}}}
 //{{{ B6 = CYRILLIC CAPITAL LETTER ZHE
    6,
	0b01010100,
	0b00111000,
	0b01010100,
	0b01010100,
	0b01010100,
	0b00000000, //}}}
 //{{{ B7 = CYRILLIC CAPITAL LETTER ZE
    4,
	0b01100000,
	0b00010000,
	0b00100000,
	0b00010000,
	0b01100000,
	0b00000000, //}}}
 //{{{ B8 = CYRILLIC CAPITAL LETTER I
    5,
	0b01001000,
	0b01011000,
	0b01111000,
	0b01101000,
	0b01001000,
	0b00000000, //}}}
 //{{{ B9 = CYRILLIC CAPITAL LETTER SHORT I
    5,
	0b01001000,
	0b01011000,
	0b01111000,
	0b01101000,
	0b01001000,
	0b00000000, //}}}
 //{{{ BA = CYRILLIC CAPITAL LETTER KA
    5,
	0b01010000,
	0b01100000,
	0b01010000,
	0b01010000,
	0b01001000,
	0b00000000, //}}}
 //{{{ BB = CYRILLIC CAPITAL LETTER EL
    6,
	0b00011100,
	0b00010100,
	0b00010100,
	0b01010100,
	0b01110100,
	0b00000000, //}}}
 //{{{ BC = CYRILLIC CAPITAL LETTER EM
    6,
	0b01000100,
	0b01101100,
	0b01010100,
	0b01000100,
	0b01000100,
	0b00000000, //}}}
 //{{{ BD = CYRILLIC CAPITAL LETTER EN
    4,
	0b01010000,
	0b01010000,
	0b01110000,
	0b01010000,
	0b01010000,
	0b00000000, //}}}
 //{{{ BE = CYRILLIC CAPITAL LETTER O
    4,
	0b01110000,
	0b01010000,
	0b01010000,
	0b01010000,
	0b01110000,
	0b00000000, //}}}
 //{{{ BF = CYRILLIC CAPITAL LETTER PE
    4,
	0b01110000,
	0b01010000,
	0b01010000,
	0b01010000,
	0b01010000,
	0b00000000, //}}}
 //{{{ C0 = CYRILLIC CAPITAL LETTER ER
    4,
	0b01110000,
	0b01010000,
	0b01110000,
	0b01000000,
	0b01000000,
	0b00000000, //}}}
 //{{{ C1 = CYRILLIC CAPITAL LETTER ES
    4,
	0b01110000,
	0b01000000,
	0b01000000,
	0b01000000,
	0b01110000,
	0b00000000, //}}}
 //{{{ C2 = CYRILLIC CAPITAL LETTER TE
    4,
	0b01110000,
	0b00100000,
	0b00100000,
	0b00100000,
	0b00100000,
	0b00000000, //}}}
 //{{{ C3 = CYRILLIC CAPITAL LETTER U
    4,
	0b00000000,
	0b01010000,
	0b01010000,
	0b00100000,
	0b01000000,
	0b00000000, //}}}
 //{{{ C4 = CYRILLIC CAPITAL LETTER EF
    6,
	0b00010000,
	0b01111100,
	0b01010100,
	0b01111100,
	0b00010000,
	0b00000000, //}}}
 //{{{ C5 = CYRILLIC CAPITAL LETTER HA
    4,
	0b01010000,
	0b01010000,
	0b00100000,
	0b01010000,
	0b01010000,
	0b00000000, //}}}
 //{{{ C6 = CYRILLIC CAPITAL LETTER TSE
    5,
	0b01010000,
	0b01010000,
	0b01010000,
	0b01110000,
	0b00001000,
	0b00000000, //}}}
 //{{{ C7 = CYRILLIC CAPITAL LETTER CHE
    4,
	0b01010000,
	0b01010000,
	0b01110000,
	0b00010000,
	0b00010000,
	0b00000000, //}}}
 //{{{ C8 = CYRILLIC CAPITAL LETTER SHA
    6,
	0b01010100,
	0b01010100,
	0b01010100,
	0b01010100,
	0b01111100,
	0b00000000, //}}}
 //{{{ C9 = CYRILLIC CAPITAL LETTER SHCHA
    7,
	0b01010100,
	0b01010100,
	0b01010100,
	0b01010100,
	0b01111110,
	0b00000010, //}}}
 //{{{ CA = CYRILLIC CAPITAL LETTER HARD SIGN
    5,
	0b01100000,
	0b00100000,
	0b00111000,
	0b00101000,
	0b00111000,
	0b00000000, //}}}
 //{{{ CB = CYRILLIC CAPITAL LETTER YERU
    6,
	0b01000100,
	0b01000100,
	0b01110100,
	0b01010100,
	0b01110100,
	0b00000000, //}}}
 //{{{ CC = CYRILLIC CAPITAL LETTER SOFT SIGN
    4,
	0b01000000,
	0b01000000,
	0b01110000,
	0b01010000,
	0b01110000,
	0b00000000, //}}}
 //{{{ CD = CYRILLIC CAPITAL LETTER E
    4,
	0b01100000,
	0b00010000,
	0b00110000,
	0b00010000,
	0b01100000,
	0b00000000, //}}}
 //{{{ CE = CYRILLIC CAPITAL LETTER YU
    6,
	0b01011100,
	0b01010100,
	0b01100100,
	0b01010100,
	0b01011100,
	0b00000000, //}}}
 //{{{ CF = CYRILLIC CAPITAL LETTER YA
    4,
	0b01110000,
	0b01010000,
	0b00110000,
	0b01010000,
	0b01010000,
	0b00000000, //}}}
 //{{{ D0 = CYRILLIC SMALL LETTER A
    4,
	0b00000000,
	0b00110000,
	0b01010000,
	0b01010000,
	0b00110000,
	0b00000000, //}}}
 //{{{ D1 = CYRILLIC SMALL LETTER BE
    4,
	0b00110000,
	0b01000000,
	0b01110000,
	0b01010000,
	0b01110000,
	0b00000000, //}}}
 //{{{ D2 = CYRILLIC SMALL LETTER VE
    4,
	0b01100000,
	0b01010000,
	0b01100000,
	0b01010000,
	0b01100000,
	0b00000000, //}}}
 //{{{ D3 = CYRILLIC SMALL LETTER GHE
    4,
	0b00000000,
	0b01110000,
	0b01000000,
	0b01000000,
	0b01000000,
	0b00000000, //}}}
 //{{{ D4 = CYRILLIC SMALL LETTER DE
    5,
	0b00000000,
	0b00111000,
	0b00101000,
	0b01111000,
	0b01001000,
	0b00000000, //}}}
 //{{{ D5 = CYRILLIC SMALL LETTER IE
    4,
	0b00000000,
	0b00100000,
	0b01010000,
	0b01100000,
	0b00110000,
	0b00000000, //}}}
 //{{{ D6 = CYRILLIC SMALL LETTER ZHE
    6,
	0b00000000,
	0b01010100,
	0b00111000,
	0b01010100,
	0b01010100,
	0b00000000, //}}}
 //{{{ D7 = CYRILLIC SMALL LETTER ZE
    4,
	0b01100000,
	0b00010000,
	0b00110000,
	0b00010000,
	0b01100000,
	0b00000000, //}}}
 //{{{ D8 = CYRILLIC SMALL LETTER I
    5,
	0b00000000,
	0b01001000,
	0b01011000,
	0b01101000,
	0b01001000,
	0b00000000, //}}}
 //{{{ D9 = CYRILLIC SMALL LETTER SHORT I
    5,
	0b00110000,
	0b00000000,
	0b01011000,
	0b01101000,
	0b01001000,
	0b00000000, //}}}
 //{{{ DA = CYRILLIC SMALL LETTER KA
    4,
	0b00000000,
	0b01010000,
	0b01100000,
	0b01010000,
	0b01010000,
	0b00000000, //}}}
 //{{{ DB = CYRILLIC SMALL LETTER EL
    5,
	0b00000000,
	0b00111000,
	0b00101000,
	0b00101000,
	0b01101000,
	0b00000000, //}}}
 //{{{ DC = CYRILLIC SMALL LETTER EM
    6,
	0b00000000,
	0b01000100,
	0b01101100,
	0b01010100,
	0b01000100,
	0b00000000, //}}}
 //{{{ DD = CYRILLIC SMALL LETTER EN
    4,
	0b00000000,
	0b01010000,
	0b01110000,
	0b01010000,
	0b01010000,
	0b00000000, //}}}
 //{{{ DE = CYRILLIC SMALL LETTER O
    4,
	0b00000000,
	0b01110000,
	0b01010000,
	0b01010000,
	0b01110000,
	0b00000000, //}}}
 //{{{ DF = CYRILLIC SMALL LETTER PE
    4,
	0b00000000,
	0b01110000,
	0b01010000,
	0b01010000,
	0b01010000,
	0b00000000, //}}}
 //{{{ E0 = CYRILLIC SMALL LETTER ER
    4,
	0b00000000,
	0b01110000,
	0b01010000,
	0b01110000,
	0b01000000,
	0b00000000, //}}}
 //{{{ E1 = CYRILLIC SMALL LETTER ES
    4,
	0b00000000,
	0b01110000,
	0b01000000,
	0b01000000,
	0b01110000,
	0b00000000, //}}}
 //{{{ E2 = CYRILLIC SMALL LETTER TE
    4,
	0b00000000,
	0b01110000,
	0b00100000,
	0b00100000,
	0b00100000,
	0b00000000, //}}}
 //{{{ E3 = CYRILLIC SMALL LETTER U
    4,
	0b00000000,
	0b01010000,
	0b01010000,
	0b00100000,
	0b01000000,
	0b00000000, //}}}
 //{{{ E4 = CYRILLIC SMALL LETTER EF
    6,
	0b00010000,
	0b01111100,
	0b01010100,
	0b01111100,
	0b00010000,
	0b00000000, //}}}
 //{{{ E5 = CYRILLIC SMALL LETTER HA
    4,
	0b00000000,
	0b01010000,
	0b00100000,
	0b01010000,
	0b01010000,
	0b00000000, //}}}
 //{{{ E6 = CYRILLIC SMALL LETTER TSE
    5,
	0b00000000,
	0b01010000,
	0b01010000,
	0b01010000,
	0b01111000,
	0b00000000, //}}}
 //{{{ E7 = CYRILLIC SMALL LETTER CHE
    4,
	0b00000000,
	0b01010000,
	0b01010000,
	0b01110000,
	0b00010000,
	0b00000000, //}}}
 //{{{ E8 = CYRILLIC SMALL LETTER SHA
    6,
	0b00000000,
	0b01010100,
	0b01010100,
	0b01010100,
	0b01111100,
	0b00000000, //}}}
 //{{{ E9 = CYRILLIC SMALL LETTER SHCHA
    7,
	0b00000000,
	0b01010100,
	0b01010100,
	0b01010100,
	0b01111110,
	0b00000010, //}}}
 //{{{ EA = CYRILLIC SMALL LETTER HARD SIGN
    5,
	0b00000000,
	0b01100000,
	0b00111000,
	0b00101000,
	0b00111000,
	0b00000000, //}}}
 //{{{ EB = CYRILLIC SMALL LETTER YERU
    7,
	0b00000000,
	0b01100010,
	0b00111010,
	0b00101010,
	0b00111010,
	0b00000000, //}}}
 //{{{ EC = CYRILLIC SMALL LETTER SOFT SIGN
    4,
	0b00000000,
	0b01000000,
	0b01110000,
	0b01010000,
	0b01110000,
	0b00000000, //}}}
 //{{{ ED = CYRILLIC SMALL LETTER E
    4,
	0b01100000,
	0b00010000,
	0b00110000,
	0b00010000,
	0b01100000,
	0b00000000, //}}}
 //{{{ EE = CYRILLIC SMALL LETTER YU
    5,
	0b00000000,
	0b01010000,
	0b01101000,
	0b01101000,
	0b01010000,
	0b00000000, //}}}
 //{{{ EF = CYRILLIC SMALL LETTER YA
    4,
	0b00000000,
	0b01110000,
	0b01010000,
	0b00110000,
	0b01010000,
	0b00000000, //}}}
 //{{{ F0 = NUMERO SIGN
    7,
	0b01001110,
	0b01101110,
	0b01111000,
	0b01011110,
	0b01001000,
	0b00000000, //}}}
 //{{{ F1 = CYRILLIC SMALL LETTER IO
    4,
	0b01010000,
	0b00100000,
	0b01010000,
	0b01100000,
	0b00110000,
	0b00000000, //}}}
 //{{{ F2 = CYRILLIC SMALL LETTER DJE
    5,
	0b00100000,
	0b01110000,
	0b00100000,
	0b00111000,
	0b00111000,
	0b00000000, //}}}
 //{{{ F3 = CYRILLIC SMALL LETTER GJE
    4,
	0b01110000,
	0b00000000,
	0b01110000,
	0b01000000,
	0b01000000,
	0b00000000, //}}}
 //{{{ F4 = CYRILLIC SMALL LETTER UKRAINIAN IE
    4,
	0b00110000,
	0b01000000,
	0b01100000,
	0b01000000,
	0b00110000,
	0b00000000, //}}}
 //{{{ F5 = CYRILLIC SMALL LETTER DZE
    3,
	0b00000000,
	0b01100000,
	0b01000000,
	0b00100000,
	0b01100000,
	0b00000000, //}}}
 //{{{ F6 = CYRILLIC SMALL LETTER BYELORUSSIAN-UKRAINIAN I
    2,
	0b01000000,
	0b00000000,
	0b01000000,
	0b01000000,
	0b01000000,
	0b00000000, //}}}
 //{{{ F7 = CYRILLIC SMALL LETTER YI
    4,
	0b01010000,
	0b00000000,
	0b00100000,
	0b00100000,
	0b00100000,
	0b00000000, //}}}
 //{{{ F8 = CYRILLIC SMALL LETTER JE
    3,
	0b00100000,
	0b00000000,
	0b00100000,
	0b00100000,
	0b01000000,
	0b00000000, //}}}
 //{{{ F9 = CYRILLIC SMALL LETTER LJE
    7,
	0b00111000,
	0b00101000,
	0b00101100,
	0b00101010,
	0b01001100,
	0b00000000, //}}}
 //{{{ FA = CYRILLIC SMALL LETTER NJE
    6,
	0b00000000,
	0b01010000,
	0b01111100,
	0b01010100,
	0b01011100,
	0b00000000, //}}}
 //{{{ FB = CYRILLIC SMALL LETTER TSHE
    5,
	0b01110000,
	0b00100000,
	0b00111000,
	0b00101000,
	0b00101000,
	0b00000000, //}}}
 //{{{ FC = CYRILLIC SMALL LETTER KJE
    4,
	0b00110000,
	0b01000000,
	0b01010000,
	0b01100000,
	0b01010000,
	0b00000000, //}}}
 //{{{ FD = SECTION SIGN
    4,
	0b00110000,
	0b01100000,
	0b01110000,
	0b00110000,
	0b01100000,
	0b00000000, //}}}
 //{{{ FE = CYRILLIC SMALL LETTER SHORT U
    4,
	0b01110000,
	0b00000000,
	0b01010000,
	0b00100000,
	0b01000000,
	0b00000000, //}}}
 //{{{ FF = CYRILLIC SMALL LETTER DZHE
    4,
	0b00000000,
	0b01010000,
	0b01010000,
	0b01110000,
	0b00100000,
	0b00000000, //}}}
	};
//}}}
//{{{
ECONST unsigned char Font_Cyrillic_5x7[128*8] =
{
 //{{{ A0 = NO-BREAK SPACE
    3,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000, //}}}
 //{{{ A1 = CYRILLIC CAPITAL LETTER IO
    4,
	0b01010000,
	0b01110000,
	0b01000000,
	0b01100000,
	0b01000000,
	0b01110000,
	0b00000000, //}}}
 //{{{ A2 = CYRILLIC CAPITAL LETTER DJE
    5,
	0b01111000,
	0b00100000,
	0b00111000,
	0b00101000,
	0b00101000,
	0b00111000,
	0b00000000, //}}}
 //{{{ A3 = CYRILLIC CAPITAL LETTER GJE
    5,
	0b01111000,
	0b01001000,
	0b01000000,
	0b01000000,
	0b01000000,
	0b01000000,
	0b00000000, //}}}
 //{{{ A4 = CYRILLIC CAPITAL LETTER UKRAINIAN IE
    5,
	0b00111000,
	0b01000000,
	0b01110000,
	0b01000000,
	0b01000000,
	0b00111000,
	0b00000000, //}}}
 //{{{ A5 = CYRILLIC CAPITAL LETTER DZE
    5,
	0b00111000,
	0b01000000,
	0b00110000,
	0b00001000,
	0b00001000,
	0b01110000,
	0b00000000, //}}}
 //{{{ A6 = CYRILLIC CAPITAL LETTER BYELORUSSIAN-UKRAINIAN I
    4,
	0b01110000,
	0b00100000,
	0b00100000,
	0b00100000,
	0b00100000,
	0b01110000,
	0b00000000, //}}}
 //{{{ A7 = CYRILLIC CAPITAL LETTER YI
    4,
	0b01010000,
	0b00100000,
	0b00100000,
	0b00100000,
	0b00100000,
	0b00100000,
	0b00000000, //}}}
 //{{{ A8 = CYRILLIC CAPITAL LETTER JE
    5,
	0b01111000,
	0b00010000,
	0b00010000,
	0b00010000,
	0b01010000,
	0b01110000,
	0b00000000, //}}}
 //{{{ A9 = CYRILLIC CAPITAL LETTER LJE
    7,
	0b01111000,
	0b00101000,
	0b00101110,
	0b00101010,
	0b00101010,
	0b01101110,
	0b00000000, //}}}
 //{{{ AA = CYRILLIC CAPITAL LETTER NJE
    6,
	0b01010000,
	0b01010000,
	0b01111100,
	0b01010100,
	0b01010100,
	0b01011100,
	0b00000000, //}}}
 //{{{ AB = CYRILLIC CAPITAL LETTER TSHE
    5,
	0b01111000,
	0b00100000,
	0b00111000,
	0b00101000,
	0b00101000,
	0b00101000,
	0b00000000, //}}}
 //{{{ AC = CYRILLIC CAPITAL LETTER KJE
    4,
	0b00110000,
	0b00000000,
	0b01010000,
	0b01100000,
	0b01010000,
	0b01010000,
	0b00000000, //}}}
 //{{{ AD = SOFT HYPHEN
    4,
	0b00000000,
	0b00000000,
	0b00000000,
	0b01110000,
	0b00000000,
	0b00000000,
	0b00000000, //}}}
 //{{{ AE = CYRILLIC CAPITAL LETTER SHORT U
    4,
	0b01110000,
	0b00000000,
	0b01010000,
	0b01010000,
	0b00100000,
	0b01000000,
	0b00000000, //}}}
 //{{{ AF = CYRILLIC CAPITAL LETTER DZHE
    5,
	0b01001000,
	0b01001000,
	0b01001000,
	0b01001000,
	0b01111000,
	0b00010000,
	0b00000000, //}}}
 //{{{ B0 = CYRILLIC CAPITAL LETTER A
    5,
	0b00110000,
	0b01001000,
	0b01001000,
	0b01111000,
	0b01001000,
	0b01001000,
	0b00000000, //}}}
 //{{{ B1 = CYRILLIC CAPITAL LETTER BE
    5,
	0b01110000,
	0b01000000,
	0b01110000,
	0b01001000,
	0b01001000,
	0b01110000,
	0b00000000, //}}}
 //{{{ B2 = CYRILLIC CAPITAL LETTER VE
    5,
	0b01110000,
	0b01001000,
	0b01110000,
	0b01001000,
	0b01001000,
	0b01110000,
	0b00000000, //}}}
 //{{{ B3 = CYRILLIC CAPITAL LETTER GHE
    5,
	0b01111000,
	0b01001000,
	0b01000000,
	0b01000000,
	0b01000000,
	0b01000000,
	0b00000000, //}}}
 //{{{ B4 = CYRILLIC CAPITAL LETTER DE
    6,
	0b00111100,
	0b00100100,
	0b00100100,
	0b00100100,
	0b01111100,
	0b01000100,
	0b00000000, //}}}
 //{{{ B5 = CYRILLIC CAPITAL LETTER IE
    5,
	0b01111000,
	0b01000000,
	0b01110000,
	0b01000000,
	0b01000000,
	0b01111000,
	0b00000000, //}}}
 //{{{ B6 = CYRILLIC CAPITAL LETTER ZHE
    6,
	0b01010100,
	0b01010100,
	0b00111000,
	0b01010100,
	0b01010100,
	0b01010100,
	0b00000000, //}}}
 //{{{ B7 = CYRILLIC CAPITAL LETTER ZE
    5,
	0b01110000,
	0b00001000,
	0b00110000,
	0b00001000,
	0b00001000,
	0b01110000,
	0b00000000, //}}}
 //{{{ B8 = CYRILLIC CAPITAL LETTER I
    6,
	0b01000100,
	0b01001100,
	0b01011100,
	0b01110100,
	0b01100100,
	0b01000100,
	0b00000000, //}}}
 //{{{ B9 = CYRILLIC CAPITAL LETTER SHORT I
    6,
	0b00101000,
	0b00010000,
	0b01000100,
	0b01001100,
	0b01010100,
	0b01100100,
	0b00000000, //}}}
 //{{{ BA = CYRILLIC CAPITAL LETTER KA
    5,
	0b01001000,
	0b01010000,
	0b01100000,
	0b01010000,
	0b01010000,
	0b01001000,
	0b00000000, //}}}
 //{{{ BB = CYRILLIC CAPITAL LETTER EL
    6,
	0b00011100,
	0b00010100,
	0b00010100,
	0b00010100,
	0b01010100,
	0b01110100,
	0b00000000, //}}}
 //{{{ BC = CYRILLIC CAPITAL LETTER EM
    6,
	0b01000100,
	0b01101100,
	0b01111100,
	0b01010100,
	0b01010100,
	0b01010100,
	0b00000000, //}}}
 //{{{ BD = CYRILLIC CAPITAL LETTER EN
    5,
	0b01001000,
	0b01001000,
	0b01111000,
	0b01001000,
	0b01001000,
	0b01001000,
	0b00000000, //}}}
 //{{{ BE = CYRILLIC CAPITAL LETTER O
    5,
	0b01111000,
	0b01001000,
	0b01001000,
	0b01001000,
	0b01001000,
	0b01111000,
	0b00000000, //}}}
 //{{{ BF = CYRILLIC CAPITAL LETTER PE
    5,
	0b01111000,
	0b01001000,
	0b01001000,
	0b01001000,
	0b01001000,
	0b01001000,
	0b00000000, //}}}
 //{{{ C0 = CYRILLIC CAPITAL LETTER ER
    5,
	0b01110000,
	0b01001000,
	0b01001000,
	0b01110000,
	0b01000000,
	0b01000000,
	0b00000000, //}}}
 //{{{ C1 = CYRILLIC CAPITAL LETTER ES
    5,
	0b00111000,
	0b01000000,
	0b01000000,
	0b01000000,
	0b01000000,
	0b00111000,
	0b00000000, //}}}
 //{{{ C2 = CYRILLIC CAPITAL LETTER TE
    6,
	0b01111100,
	0b00010000,
	0b00010000,
	0b00010000,
	0b00010000,
	0b00010000,
	0b00000000, //}}}
 //{{{ C3 = CYRILLIC CAPITAL LETTER U
    5,
	0b01001000,
	0b01001000,
	0b00110000,
	0b00010000,
	0b00100000,
	0b01000000,
	0b00000000, //}}}
 //{{{ C4 = CYRILLIC CAPITAL LETTER EF
    6,
	0b00010000,
	0b01111100,
	0b01010100,
	0b01010100,
	0b01111100,
	0b00010000,
	0b00000000, //}}}
 //{{{ C5 = CYRILLIC CAPITAL LETTER HA
    5,
	0b01001000,
	0b01001000,
	0b00110000,
	0b00110000,
	0b01001000,
	0b01001000,
	0b00000000, //}}}
 //{{{ C6 = CYRILLIC CAPITAL LETTER TSE
    6,
	0b01001000,
	0b01001000,
	0b01001000,
	0b01001000,
	0b01001000,
	0b01111000,
	0b00000100, //}}}
 //{{{ C7 = CYRILLIC CAPITAL LETTER CHE
    4,
	0b01010000,
	0b01010000,
	0b01110000,
	0b00010000,
	0b00010000,
	0b00010000,
	0b00000000, //}}}
 //{{{ C8 = CYRILLIC CAPITAL LETTER SHA
    6,
	0b01010100,
	0b01010100,
	0b01010100,
	0b01010100,
	0b01010100,
	0b01111100,
	0b00000000, //}}}
 //{{{ C9 = CYRILLIC CAPITAL LETTER SHCHA
    7,
	0b01010100,
	0b01010100,
	0b01010100,
	0b01010100,
	0b01010100,
	0b01111110,
	0b00000010, //}}}
 //{{{ CA = CYRILLIC CAPITAL LETTER HARD SIGN
    5,
	0b01100000,
	0b00100000,
	0b00111000,
	0b00101000,
	0b00101000,
	0b00111000,
	0b00000000, //}}}
 //{{{ CB = CYRILLIC CAPITAL LETTER YERU
    6,
	0b01000100,
	0b01000100,
	0b01110100,
	0b01010100,
	0b01010100,
	0b01110100,
	0b00000000, //}}}
 //{{{ CC = CYRILLIC CAPITAL LETTER SOFT SIGN
    4,
	0b01000000,
	0b01000000,
	0b01110000,
	0b01010000,
	0b01010000,
	0b01110000,
	0b00000000, //}}}
 //{{{ CD = CYRILLIC CAPITAL LETTER E
    5,
	0b01110000,
	0b00001000,
	0b00111000,
	0b00001000,
	0b00001000,
	0b01110000,
	0b00000000, //}}}
 //{{{ CE = CYRILLIC CAPITAL LETTER YU
    6,
	0b01011100,
	0b01010100,
	0b01100100,
	0b01100100,
	0b01010100,
	0b01011100,
	0b00000000, //}}}
 //{{{ CF = CYRILLIC CAPITAL LETTER YA
    5,
	0b00111000,
	0b01001000,
	0b00111000,
	0b01001000,
	0b01001000,
	0b01001000,
	0b00000000, //}}}
 //{{{ D0 = CYRILLIC SMALL LETTER A
    5,
	0b00000000,
	0b00000000,
	0b00111000,
	0b01001000,
	0b01011000,
	0b01101000,
	0b00000000, //}}}
 //{{{ D1 = CYRILLIC SMALL LETTER BE
    4,
	0b00000000,
	0b01110000,
	0b01000000,
	0b01110000,
	0b01010000,
	0b01110000,
	0b00000000, //}}}
 //{{{ D2 = CYRILLIC SMALL LETTER VE
    4,
	0b00000000,
	0b01100000,
	0b01010000,
	0b01100000,
	0b01010000,
	0b01100000,
	0b00000000, //}}}
 //{{{ D3 = CYRILLIC SMALL LETTER GHE
    4,
	0b00000000,
	0b01110000,
	0b01000000,
	0b01000000,
	0b01000000,
	0b01000000,
	0b00000000, //}}}
 //{{{ D4 = CYRILLIC SMALL LETTER DE
    5,
	0b00000000,
	0b00111000,
	0b00101000,
	0b00101000,
	0b01111000,
	0b01001000,
	0b00000000, //}}}
 //{{{ D5 = CYRILLIC SMALL LETTER IE
    5,
	0b00000000,
	0b00000000,
	0b00110000,
	0b01111000,
	0b01000000,
	0b00110000,
	0b00000000, //}}}
 //{{{ D6 = CYRILLIC SMALL LETTER ZHE
    6,
	0b00000000,
	0b01010100,
	0b01010100,
	0b00111000,
	0b01010100,
	0b01010100,
	0b00000000, //}}}
 //{{{ D7 = CYRILLIC SMALL LETTER ZE
    4,
	0b00000000,
	0b01100000,
	0b00010000,
	0b00110000,
	0b00010000,
	0b01100000,
	0b00000000, //}}}
 //{{{ D8 = CYRILLIC SMALL LETTER I
    5,
	0b00000000,
	0b01001000,
	0b01011000,
	0b01111000,
	0b01101000,
	0b01001000,
	0b00000000, //}}}
 //{{{ D9 = CYRILLIC SMALL LETTER SHORT I
    5,
	0b00110000,
	0b00000000,
	0b01001000,
	0b01011000,
	0b01101000,
	0b01001000,
	0b00000000, //}}}
 //{{{ DA = CYRILLIC SMALL LETTER KA
    4,
	0b00000000,
	0b01010000,
	0b01010000,
	0b01100000,
	0b01010000,
	0b01010000,
	0b00000000, //}}}
 //{{{ DB = CYRILLIC SMALL LETTER EL
    5,
	0b00000000,
	0b00111000,
	0b00101000,
	0b00101000,
	0b00101000,
	0b01101000,
	0b00000000, //}}}
 //{{{ DC = CYRILLIC SMALL LETTER EM
    6,
	0b00000000,
	0b01000100,
	0b01101100,
	0b01010100,
	0b01010100,
	0b01000100,
	0b00000000, //}}}
 //{{{ DD = CYRILLIC SMALL LETTER EN
    4,
	0b00000000,
	0b01010000,
	0b01010000,
	0b01110000,
	0b01010000,
	0b01010000,
	0b00000000, //}}}
 //{{{ DE = CYRILLIC SMALL LETTER O
    4,
	0b00000000,
	0b01110000,
	0b01010000,
	0b01010000,
	0b01010000,
	0b01110000,
	0b00000000, //}}}
 //{{{ DF = CYRILLIC SMALL LETTER PE
    4,
	0b00000000,
	0b01110000,
	0b01010000,
	0b01010000,
	0b01010000,
	0b01010000,
	0b00000000, //}}}
 //{{{ E0 = CYRILLIC SMALL LETTER ER
    4,
	0b00000000,
	0b01110000,
	0b01010000,
	0b01110000,
	0b01000000,
	0b01000000,
	0b00000000, //}}}
 //{{{ E1 = CYRILLIC SMALL LETTER ES
    4,
	0b00000000,
	0b01110000,
	0b01000000,
	0b01000000,
	0b01000000,
	0b01110000,
	0b00000000, //}}}
 //{{{ E2 = CYRILLIC SMALL LETTER TE
    4,
	0b00000000,
	0b01110000,
	0b00100000,
	0b00100000,
	0b00100000,
	0b00100000,
	0b00000000, //}}}
 //{{{ E3 = CYRILLIC SMALL LETTER U
    4,
	0b00000000,
	0b01010000,
	0b01010000,
	0b00110000,
	0b00010000,
	0b01100000,
	0b00000000, //}}}
 //{{{ E4 = CYRILLIC SMALL LETTER EF
    6,
	0b00000000,
	0b00010000,
	0b01111100,
	0b01010100,
	0b01111100,
	0b00010000,
	0b00000000, //}}}
 //{{{ E5 = CYRILLIC SMALL LETTER HA
    4,
	0b00000000,
	0b01010000,
	0b01010000,
	0b00100000,
	0b01010000,
	0b01010000,
	0b00000000, //}}}
 //{{{ E6 = CYRILLIC SMALL LETTER TSE
    5,
	0b00000000,
	0b01010000,
	0b01010000,
	0b01010000,
	0b01010000,
	0b01111000,
	0b00000000, //}}}
 //{{{ E7 = CYRILLIC SMALL LETTER CHE
    4,
	0b00000000,
	0b01010000,
	0b01010000,
	0b01010000,
	0b01110000,
	0b00010000,
	0b00000000, //}}}
 //{{{ E8 = CYRILLIC SMALL LETTER SHA
    6,
	0b00000000,
	0b01010100,
	0b01010100,
	0b01010100,
	0b01010100,
	0b01111100,
	0b00000000, //}}}
 //{{{ E9 = CYRILLIC SMALL LETTER SHCHA
    7,
	0b00000000,
	0b01010100,
	0b01010100,
	0b01010100,
	0b01010100,
	0b01111110,
	0b00000010, //}}}
 //{{{ EA = CYRILLIC SMALL LETTER HARD SIGN
    5,
	0b00000000,
	0b01100000,
	0b00100000,
	0b00111000,
	0b00101000,
	0b00111000,
	0b00000000, //}}}
 //{{{ EB = CYRILLIC SMALL LETTER YERU
    7,
	0b00000000,
	0b01100010,
	0b00100010,
	0b00111010,
	0b00101010,
	0b00111010,
	0b00000000, //}}}
 //{{{ EC = CYRILLIC SMALL LETTER SOFT SIGN
    4,
	0b00000000,
	0b01000000,
	0b01000000,
	0b01110000,
	0b01010000,
	0b01110000,
	0b00000000, //}}}
 //{{{ ED = CYRILLIC SMALL LETTER E
    4,
	0b00000000,
	0b01100000,
	0b00010000,
	0b00110000,
	0b00010000,
	0b01100000,
	0b00000000, //}}}
 //{{{ EE = CYRILLIC SMALL LETTER YU
    5,
	0b00000000,
	0b01010000,
	0b01101000,
	0b01001000,
	0b01101000,
	0b01010000,
	0b00000000, //}}}
 //{{{ EF = CYRILLIC SMALL LETTER YA
    4,
	0b00000000,
	0b00110000,
	0b01010000,
	0b00110000,
	0b01010000,
	0b01010000,
	0b00000000, //}}}
 //{{{ F0 = NUMERO SIGN
    6,
	0b00001100,
	0b00000100,
	0b01001000,
	0b01101000,
	0b01011000,
	0b01001000,
	0b00000000, //}}}
 //{{{ F1 = CYRILLIC SMALL LETTER IO
    5,
	0b00101000,
	0b00000000,
	0b00110000,
	0b01111000,
	0b01000000,
	0b00110000,
	0b00000000, //}}}
 //{{{ F2 = CYRILLIC SMALL LETTER DJE
    5,
	0b00100000,
	0b01110000,
	0b00100000,
	0b00111000,
	0b00101000,
	0b00111000,
	0b00000000, //}}}
 //{{{ F3 = CYRILLIC SMALL LETTER GJE
    4,
	0b00110000,
	0b00000000,
	0b01110000,
	0b01000000,
	0b01000000,
	0b01000000,
	0b00000000, //}}}
 //{{{ F4 = CYRILLIC SMALL LETTER UKRAINIAN IE
    4,
	0b00000000,
	0b00110000,
	0b01000000,
	0b01100000,
	0b01000000,
	0b00110000,
	0b00000000, //}}}
 //{{{ F5 = CYRILLIC SMALL LETTER DZE
    3,
	0b00000000,
	0b01110000,
	0b01000000,
	0b01110000,
	0b00010000,
	0b01110000,
	0b00000000, //}}}
 //{{{ F6 = CYRILLIC SMALL LETTER BYELORUSSIAN-UKRAINIAN I
    2,
	0b01000000,
	0b00000000,
	0b01000000,
	0b01000000,
	0b01000000,
	0b01000000,
	0b00000000, //}}}
 //{{{ F7 = CYRILLIC SMALL LETTER YI
    4,
	0b01010000,
	0b00000000,
	0b00100000,
	0b00100000,
	0b00100000,
	0b00100000,
	0b00000000, //}}}
 //{{{ F8 = CYRILLIC SMALL LETTER JE
    3,
	0b00100000,
	0b00000000,
	0b00100000,
	0b00100000,
	0b00100000,
	0b01000000,
	0b00000000, //}}}
 //{{{ F9 = CYRILLIC SMALL LETTER LJE
    7,
	0b00000000,
	0b00111000,
	0b00101000,
	0b00101100,
	0b00101010,
	0b01001100,
	0b00000000, //}}}
 //{{{ FA = CYRILLIC SMALL LETTER NJE
    6,
	0b00000000,
	0b01010000,
	0b01010000,
	0b01111100,
	0b01010100,
	0b01011100,
	0b00000000, //}}}
 //{{{ FB = CYRILLIC SMALL LETTER TSHE
    5,
	0b00100000,
	0b01110000,
	0b00100000,
	0b00111000,
	0b00101000,
	0b00101000,
	0b00000000, //}}}
 //{{{ FC = CYRILLIC SMALL LETTER KJE
    4,
	0b00110000,
	0b00000000,
	0b01000000,
	0b01010000,
	0b01100000,
	0b01010000,
	0b00000000, //}}}
 //{{{ FD = SECTION SIGN
    4,
	0b00110000,
	0b01000000,
	0b01110000,
	0b01110000,
	0b00010000,
	0b01100000,
	0b00000000, //}}}
 //{{{ FE = CYRILLIC SMALL LETTER SHORT U
    4,
	0b00110000,
	0b00000000,
	0b01010000,
	0b01010000,
	0b00100000,
	0b01000000,
	0b00000000, //}}}
 //{{{ FF = CYRILLIC SMALL LETTER DZHE
    4,
	0b00000000,
	0b01010000,
	0b01010000,
	0b01010000,
	0b01110000,
	0b00100000,
	0b00000000, //}}}
};
//}}}
#endif

#endif

#ifdef IS_CALCULATOR
//{{{
ECONST uchar tiles_5x5[128*5] =
{
 //{{{ 0 Mask
	0b00000111,
	0b00000111,
	0b00000111,
	0b00000111,
	0b00000111,
//}}}
 //{{{ 1 Blacktile
	0b11111000,
	0b11111000,
	0b11111000,
	0b11111000,
	0b11111000,
//}}}
 //{{{ 2 Whitetile
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
//}}}
 //{{{ 3 Unlit floor
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
//}}}
 //{{{ 4 Lit floor
	0b00000000,
	0b00000000,
	0b00100000,
	0b00000000,
	0b00000000,
//}}}
 //{{{ 5 Wall
	0b11111000,
	0b11111000,
	0b11111000,
	0b11111000,
	0b11111000,
//}}}
 //{{{ 6 Water
	0b01010000,
	0b10100000,
	0b00000000,
	0b01010000,
	0b00000000,
//}}}
 //{{{ 7 Plains
	0b00000000,
	0b00000000,
	0b00000000,
	0b00100000,
	0b00000000,
//}}}
 //{{{ 8 Road
	0b00000000,
	0b00000000,
	0b00000000,
	0b01110000,
	0b00000000,
//}}}
 //{{{ 9 Mountain 1
	0b00000000,
	0b00000000,
	0b00100000,
	0b01010000,
	0b10001000,
//}}}
 //{{{ 10 Mountain 2
	0b00000000,
	0b00100000,
	0b01010000,
	0b10001000,
	0b00000000,
//}}}
 //{{{ 11 Horizontal beam
	0b00000000,
	0b01000000,
	0b10101000,
	0b00010000,
	0b00000000,
//}}}
 //{{{ 12 Vertical beam
	0b00100000,
	0b00010000,
	0b00100000,
	0b01000000,
	0b00100000,
//}}}
 //{{{ 13 First diagonal beam
	0b10000000,
	0b10000000,
	0b01100000,
	0b00100000,
	0b00011000,
//}}}
 //{{{ 14 Second diagonal beam
	0b00001000,
	0b00001000,
	0b00110000,
	0b00100000,
	0b11000000,
//}}}
 //{{{ 15 Sign
	0b00000000,
	0b11111000,
	0b11111000,
	0b00100000,
	0b00000000,
//}}}
 //{{{ 16 Spider web
	0b10101000,
	0b01010000,
	0b10101000,
	0b01010000,
	0b10101000,
//}}}
 //{{{ 17 Unexplored
	0b00001000,
	0b00010000,
	0b00100000,
	0b01000000,
	0b10000000,
//}}}
 //{{{ 18 Fountain
	0b01010000,
	0b10101000,
	0b00100000,
	0b11111000,
	0b01110000,
//}}}
 //{{{ 19 Town
	0b00000000,
	0b01010000,
	0b11111000,
	0b11111000,
	0b00000000,
//}}}
 //{{{ 20 Cave
	0b00000000,
	0b01110000,
	0b10101000,
	0b10001000,
	0b01110000,
//}}}
 //{{{ 21
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
//}}}
 //{{{ 22
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
//}}}
 //{{{ 23
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
//}}}
 //{{{ 24
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
//}}}
 //{{{ 25
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
//}}}
 //{{{ 26
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
//}}}
 //{{{ 27
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
//}}}
 //{{{ 28
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
//}}}
 //{{{ 29
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
//}}}
 //{{{ 30
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
//}}}
 //{{{ 31
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
//}}}
 //{{{ 32
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
//}}}
 //{{{ 33 !
	0b00100000,
	0b00100000,
	0b00100000,
	0b00000000,
	0b00100000,
//}}}
 //{{{ 34 "
	0b01010000,
	0b01010000,
	0b00000000,
	0b00000000,
	0b00000000,
//}}}
 //{{{ 35 #
	0b01010000,
	0b11111000,
	0b01010000,
	0b11111000,
	0b01010000,
//}}}
 //{{{ 36 $
	0b01110000,
	0b10100000,
	0b01110000,
	0b00101000,
	0b01110000,
//}}}
 //{{{ 37 %
	0b00000000,
	0b10010000,
	0b00100000,
	0b01001000,
	0b00000000,
//}}}
 //{{{ 38 &
	0b00000000,
	0b01100000,
	0b00101000,
	0b01010000,
	0b00101000,
//}}}
 //{{{ 39 '
	0b00100000,
	0b00100000,
	0b00000000,
	0b00000000,
	0b00000000,
//}}}
 //{{{ 40 (
	0b00000000,
	0b00100000,
	0b01000000,
	0b01000000,
	0b00100000,
//}}}
 //{{{ 41 )
	0b00000000,
	0b00100000,
	0b00010000,
	0b00010000,
	0b00100000,
//}}}
 //{{{ 42 *
	0b00000000,
	0b00110000,
	0b01010000,
	0b01100000,
	0b00000000,
//}}}
 //{{{ 43 +
	0b00000000,
	0b00100000,
	0b01110000,
	0b00100000,
	0b00000000,
//}}}
 //{{{ 44 ,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00100000,
	0b01000000,
//}}}
 //{{{ 45 -
	0b00000000,
	0b00000000,
	0b01110000,
	0b00000000,
	0b00000000,
//}}}
 //{{{ 46 .
	0b00000000,
	0b00000000,
	0b00000000,
	0b00110000,
	0b00110000,
//}}}
 //{{{ 47 /
	0b00000000,
	0b00010000,
	0b00100000,
	0b01000000,
	0b10000000,
//}}}
 //{{{ 48 0
	0b00000000,
	0b01110000,
	0b01010000,
	0b01010000,
	0b01110000,
//}}}
 //{{{ 49 1
	0b00000000,
	0b00100000,
	0b00100000,
	0b00100000,
	0b00100000,
//}}}
 //{{{ 50 2
	0b00000000,
	0b01100000,
	0b00010000,
	0b00100000,
	0b01110000,
//}}}
 //{{{ 51 3
	0b01100000,
	0b00010000,
	0b00110000,
	0b00010000,
	0b01100000,
//}}}
 //{{{ 52 4
	0b00000000,
	0b00110000,
	0b01010000,
	0b01110000,
	0b00010000,
//}}}
 //{{{ 53 5
	0b00000000,
	0b01110000,
	0b01000000,
	0b00110000,
	0b01100000,
//}}}
 //{{{ 54 6
	0b00000000,
	0b00110000,
	0b01000000,
	0b01110000,
	0b01110000,
//}}}
 //{{{ 55 7
	0b00000000,
	0b01110000,
	0b00010000,
	0b00100000,
	0b01000000,
//}}}
 //{{{ 56 8
	0b00100000,
	0b01010000,
	0b00100000,
	0b01010000,
	0b00100000,
//}}}
 //{{{ 57 9
	0b00000000,
	0b01110000,
	0b01110000,
	0b00010000,
	0b01110000,
//}}}
 //{{{ 58 :
	0b00000000,
	0b00100000,
	0b00000000,
	0b00100000,
	0b00000000,
//}}}
 //{{{ 59 ;
	0b00000000,
	0b00100000,
	0b00000000,
	0b00100000,
	0b01000000,
//}}}
 //{{{ 60 <
	0b00010000,
	0b00100000,
	0b01000000,
	0b00100000,
	0b00010000,
//}}}
 //{{{ 61 =
	0b00000000,
	0b01110000,
	0b00000000,
	0b01110000,
	0b00000000,
//}}}
 //{{{ 62 >
	0b01000000,
	0b00100000,
	0b00010000,
	0b00100000,
	0b01000000,
//}}}
 //{{{ 63 ?
	0b01100000,
	0b00010000,
	0b00100000,
	0b00000000,
	0b00100000,
//}}}
 //{{{ 64 @
	0b01110000,
	0b11111000,
	0b11111000,
	0b11111000,
	0b01110000,
//}}}
 //{{{ 65 A
	0b00110000,
	0b01001000,
	0b01111000,
	0b01001000,
	0b01001000,
//}}}
 //{{{ 66 B
	0b01110000,
	0b01001000,
	0b01110000,
	0b01001000,
	0b01110000,
//}}}
 //{{{ 67 C
	0b01110000,
	0b01000000,
	0b01000000,
	0b01000000,
	0b01110000,
//}}}
 //{{{ 68 D
	0b01110000,
	0b01001000,
	0b01001000,
	0b01001000,
	0b01110000,
//}}}
 //{{{ 69 E
	0b01110000,
	0b01000000,
	0b01110000,
	0b01000000,
	0b01110000,
//}}}
 //{{{ 70 F
	0b01110000,
	0b01000000,
	0b01110000,
	0b01000000,
	0b01000000,
//}}}
 //{{{ 71 G
	0b01110000,
	0b01000000,
	0b01010000,
	0b01010000,
	0b01110000,
//}}}
 //{{{ 72 H
	0b01001000,
	0b01001000,
	0b01111000,
	0b01001000,
	0b01001000,
//}}}
 //{{{ 73 I
	0b01110000,
	0b00100000,
	0b00100000,
	0b00100000,
	0b01110000,
//}}}
 //{{{ 74 J
	0b01111000,
	0b00010000,
	0b00010000,
	0b01010000,
	0b01110000,
//}}}
 //{{{ 75 K
	0b01001000,
	0b01010000,
	0b01100000,
	0b01010000,
	0b01001000,
//}}}
 //{{{ 76 L
	0b01000000,
	0b01000000,
	0b01000000,
	0b01000000,
	0b01111000,
//}}}
 //{{{ 77 M
	0b01001000,
	0b01111000,
	0b01111000,
	0b01111000,
	0b01001000,
//}}}
 //{{{ 78 N
	0b01001000,
	0b01101000,
	0b01101000,
	0b01011000,
	0b01011000,
//}}}
 //{{{ 79 O
	0b01111000,
	0b01001000,
	0b01001000,
	0b01001000,
	0b01111000,
//}}}
 //{{{ 80 P
	0b01110000,
	0b01010000,
	0b01110000,
	0b01000000,
	0b01000000,
//}}}
 //{{{ 81 Q
	0b00110000,
	0b01001000,
	0b01001000,
	0b01011000,
	0b00111000,
//}}}
 //{{{ 82 R
	0b01110000,
	0b01001000,
	0b01110000,
	0b01001000,
	0b01001000,
//}}}
 //{{{ 83 S
	0b01111000,
	0b01000000,
	0b01111000,
	0b00001000,
	0b01111000,
//}}}
 //{{{ 84 T
	0b11111000,
	0b00100000,
	0b00100000,
	0b00100000,
	0b00100000,
//}}}
 //{{{ 85 U
	0b01001000,
	0b01001000,
	0b01001000,
	0b01001000,
	0b01111000,
//}}}
 //{{{ 86 V
	0b01001000,
	0b01001000,
	0b01001000,
	0b00110000,
	0b00110000,
//}}}
 //{{{ 87 W
	0b10001000,
	0b10101000,
	0b10101000,
	0b01110000,
	0b01110000,
//}}}
 //{{{ 88 X
	0b01001000,
	0b01001000,
	0b00110000,
	0b01001000,
	0b01001000,
//}}}
 //{{{ 89 Y
	0b10001000,
	0b10001000,
	0b01010000,
	0b00100000,
	0b00100000,
//}}}
 //{{{ 90 Z
	0b01110000,
	0b00010000,
	0b00100000,
	0b01000000,
	0b01110000,
//}}}
 //{{{ 91 [
	0b00000000,
	0b01100000,
	0b01000000,
	0b01000000,
	0b01100000,
//}}}
 //{{{ 92 \ backslash 
	0b00000000,
	0b10000000,
	0b01000000,
	0b00100000,
	0b00010000,
//}}}
 //{{{ 93 ]
	0b00000000,
	0b01100000,
	0b00100000,
	0b00100000,
	0b01100000,
//}}}
 //{{{ 94 ^
	0b00100000,
	0b01010000,
	0b00000000,
	0b00000000,
	0b00000000,
//}}}
 //{{{ 95 _
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b11111000,
//}}}
 //{{{ 96 `
	0b01000000,
	0b00100000,
	0b00000000,
	0b00000000,
	0b00000000,
//}}}
 //{{{ 97 a
	0b00000000,
	0b01110000,
	0b00010000,
	0b01110000,
	0b01110000,
//}}}
 //{{{ 98 b
	0b01000000,
	0b01000000,
	0b01110000,
	0b01010000,
	0b01110000,
//}}}
 //{{{ 99 c
	0b00000000,
	0b01110000,
	0b01000000,
	0b01000000,
	0b01110000,
//}}}
 //{{{ 100 d
	0b00010000,
	0b00010000,
	0b01110000,
	0b01010000,
	0b01110000,
//}}}
 //{{{ 101 e
	0b00000000,
	0b01110000,
	0b01110000,
	0b01000000,
	0b01110000,
//}}}
 //{{{ 102 f
	0b00010000,
	0b00100000,
	0b01110000,
	0b00100000,
	0b00100000,
//}}}
 //{{{ 103 g
	0b00000000,
	0b01110000,
	0b01110000,
	0b00010000,
	0b01100000,
//}}}
 //{{{ 104 h
	0b01000000,
	0b01000000,
	0b01110000,
	0b01010000,
	0b01010000,
//}}}
 //{{{ 105 i
	0b00100000,
	0b00000000,
	0b00100000,
	0b00100000,
	0b00100000,
//}}}
 //{{{ 106 j
	0b00010000,
	0b00000000,
	0b00110000,
	0b00010000,
	0b01110000,
//}}}
 //{{{ 107 k
	0b00000000,
	0b01010000,
	0b01100000,
	0b01010000,
	0b01010000,
//}}}
 //{{{ 108 l
	0b00000000,
	0b00100000,
	0b00100000,
	0b00100000,
	0b00100000,
//}}}
 //{{{ 109 m
	0b00000000,
	0b01010000,
	0b01110000,
	0b01110000,
	0b01010000,
//}}}
 //{{{ 110 n
	0b00000000,
	0b01100000,
	0b01010000,
	0b01010000,
	0b01010000,
//}}}
 //{{{ 111 o
	0b00000000,
	0b01110000,
	0b01010000,
	0b01010000,
	0b01110000,
//}}}
 //{{{ 112 p
	0b00000000,
	0b01100000,
	0b01010000,
	0b01100000,
	0b01000000,
//}}}
 //{{{ 113 q
	0b00000000,
	0b00110000,
	0b01010000,
	0b00110000,
	0b00010000,
//}}}
 //{{{ 114 r
	0b00000000,
	0b00110000,
	0b01000000,
	0b01000000,
	0b01000000,
//}}}
 //{{{ 115 s
	0b00000000,
	0b01110000,
	0b01100000,
	0b00010000,
	0b01110000,
//}}}
 //{{{ 116 t
	0b00100000,
	0b00100000,
	0b01110000,
	0b00100000,
	0b00100000,
//}}}
 //{{{ 117 u
	0b00000000,
	0b01010000,
	0b01010000,
	0b01010000,
	0b01110000,
//}}}
 //{{{ 118 v
	0b00000000,
	0b00000000,
	0b01010000,
	0b01010000,
	0b00100000,
//}}}
 //{{{ 119 w
	0b00000000,
	0b00000000,
	0b01010000,
	0b01110000,
	0b01110000,
//}}}
 //{{{ 120 x
	0b00000000,
	0b00000000,
	0b01010000,
	0b00100000,
	0b01010000,
//}}}
 //{{{ 121 y
	0b00000000,
	0b01010000,
	0b01010000,
	0b00100000,
	0b01000000,
//}}}
 //{{{ 122 z
	0b00000000,
	0b01110000,
	0b00010000,
	0b00100000,
	0b01110000,
//}}}
 //{{{ 123 {
	0b00100000,
	0b01000000,
	0b01100000,
	0b01000000,
	0b00100000,
//}}}
 //{{{ 124 |
	0b00100000,
	0b00100000,
	0b00000000,
	0b00100000,
	0b00100000,
//}}}
 //{{{ 125 }
	0b00100000,
	0b00010000,
	0b00110000,
	0b00010000,
	0b00100000,
//}}}
 //{{{ 126 ~
	0b00000000,
	0b00101000,
	0b01010000,
	0b00000000,
	0b00000000,
//}}}
 //{{{ 127 
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
//}}}
};
//}}}
//{{{
ECONST uchar tiles_7x7[128*7] =
{
// 0 Mask
	0b00000001,
	0b00000001,
	0b00000001,
	0b00000001,
	0b00000001,
	0b00000001,
	0b00000001,

// 1 Blacktile
	0b11111110,
	0b11111110,
	0b11111110,
	0b11111110,
	0b11111110,
	0b11111110,
	0b11111110,

// 2 Whitetile
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,

// 3 Unlit floor
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,

// 4 Lit floor
	0b00000000,
	0b00000000,
	0b00000000,
	0b00010000,
	0b00000000,
	0b00000000,
	0b00000000,

// 5 Wall
	0b11111110,
	0b11111110,
	0b11111110,
	0b11111110,
	0b11111110,
	0b11111110,
	0b11111110,


// 6 Water
	0b00000000,
	0b01010100,
	0b10101000,
	0b00000000,
	0b01010100,
	0b10101000,
	0b00000000,

// 7 Plains
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00110000,
	0b00110000,
	0b00000000,

// 8 Road
	0b00000000,
	0b00000000,
	0b00000000,
	0b01111100,
	0b00000000,
	0b00000000,
	0b00000000,

// 9 Mountain 1
	0b00000000,
	0b00010000,
	0b00101000,
	0b01000100,
	0b10000010,
	0b00000000,
	0b00000000,

// 10 Mountain 2
	0b00010000,
	0b00101000,
	0b01000100,
	0b10000010,
	0b00000000,
	0b00000000,
	0b00000000,

// 11 Horizontal beam
	0b00000000,
	0b00000000,
	0b10101010,
	0b01010100,
	0b00000000,
	0b00000000,
	0b00000000,

// 12 Vertical beam
	0b00010000,
	0b00001000,
	0b00001000,
	0b00010000,
	0b00100000,
	0b00100000,
	0b00010000,

// 13 First diagonal beam
	0b10000000,
	0b10000000,
	0b01100000,
	0b00100000,
	0b00011000,
	0b00000100,
	0b00000110,

// 14 Second diagonal beam
	0b00000010,
	0b00000110,
	0b00011000,
	0b00010000,
	0b01100000,
	0b01000000,
	0b10000000,

// 15 Sign
	0b00000000,
	0b11111110,
	0b11111110,
	0b11111110,
	0b00010000,
	0b00010000,
	0b00000000,

// 16 Spider web
	0b10101010,
	0b01010100,
	0b10101010,
	0b01010100,
	0b10101010,
	0b01010100,
	0b10101010,

// 17 Unexplored
	0b00000000,
	0b00000100,
	0b00001000,
	0b00010000,
	0b00100000,
	0b01000000,
	0b00000000,

// 18 Fountain
	0b00000000,
	0b00000000,
	0b00101000,
	0b01010100,
	0b01010100,
	0b11111110,
	0b01111100,

// 19 Town
	0b00000000,
	0b00000000,
	0b01000000,
	0b10100100,
	0b11101010,
	0b00001110,
	0b00000000,

// 20 Cave
	0b00000000,
	0b01111100,
	0b11101110,
	0b10100010,
	0b10000010,
	0b01111100,
	0b00000000,

// 21
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,

// 22
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,

// 23
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,

// 24
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,

// 25
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,

// 26
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,

// 27
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,

// 28
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,

// 29
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,

// 30
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,

// 31
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,

// 32
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,

// 33 !
	0b00010000,
	0b00010000,
	0b00010000,
	0b00010000,
	0b00000000,
	0b00010000,
	0b00000000,

// 34 "
	0b01101100,
	0b01101100,
	0b00101000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,

// 35 #
	0b01000100,
	0b11111110,
	0b01000100,
	0b01000100,
	0b01000100,
	0b11111110,
	0b01000100,

// 36 $
	0b00010000,
	0b00111100,
	0b01010000,
	0b00111000,
	0b00010100,
	0b01111000,
	0b00010000,
	
// 37 %
	0b00000000,
	0b01000100,
	0b00001000,
	0b00010000,
	0b00100000,
	0b01000100,
	0b00000000,

// 38 &
	0b00100000,
	0b01010000,
	0b00100000,
	0b01010100,
	0b01011000,
	0b00100100,
	0b00000000,

// 39 '
	0b00001000,
	0b00001000,
	0b00010000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,

// 40 (
	0b00010000,
	0b00100000,
	0b01000000,
	0b01000000,
	0b00100000,
	0b00010000,
	0b00000000,

// 41 )
	0b00100000,
	0b00010000,
	0b00001000,
	0b00001000,
	0b00010000,
	0b00100000,
	0b00000000,

// 42 *
	0b00000000,
	0b00011100,
	0b00100100,
	0b01000100,
	0b01001000,
	0b01110000,
	0b00000000,

// 43 +
	0b00000000,
	0b00010000,
	0b00010000,
	0b01111100,
	0b00010000,
	0b00010000,
	0b00000000,

// 44 ,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00001000,
	0b00001000,
	0b00110000,
	0b00000000,

// 45 -
	0b00000000,
	0b00000000,
	0b00000000,
	0b01111100,
	0b00000000,
	0b00000000,
	0b00000000,

// 46 .
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00110000,
	0b00110000,
	0b00000000,

// 47 /
	0b00000000,
	0b00000100,
	0b00001000,
	0b00010000,
	0b00100000,
	0b01000000,
	0b00000000,

// 48 0
	0b01111000,
	0b01000100,
	0b01000100,
	0b01000100,
	0b01000100,
	0b01111100,
	0b00000000,

// 49 1
	0b00010000,
	0b00110000,
	0b00010000,
	0b00010000,
	0b00010000,
	0b00111000,
	0b00000000,

// 50 2
	0b00011000,
	0b00100100,
	0b00000100,
	0b00001000,
	0b00010000,
	0b00111100,
	0b00000000,

// 51 3
	0b00111000,
	0b00000100,
	0b00011000,
	0b00000100,
	0b00000100,
	0b00111000,
	0b00000000,

// 52 4
	0b00011000,
	0b00101000,
	0b01001000,
	0b01111000,
	0b00001000,
	0b00001000,
	0b00000000,

// 53 5
	0b00111100,
	0b00100000,
	0b00111000,
	0b00000100,
	0b00000100,
	0b00111000,
	0b00000000,

// 54 6
	0b00011100,
	0b00100000,
	0b00100000,
	0b00111100,
	0b00100100,
	0b00111100,
	0b00000000,

// 55 7
	0b00111100,
	0b00000100,
	0b00000100,
	0b00001000,
	0b00010000,
	0b00010000,
	0b00000000,

// 56 8
	0b00111000,
	0b01000100,
	0b00111000,
	0b01000100,
	0b01000100,
	0b00111000,
	0b00000000,

// 57 9
	0b00111100,
	0b00100100,
	0b00100100,
	0b00111100,
	0b00000100,
	0b00111100,
	0b00000000,

// 58 :
	0b00000000,
	0b00011000,
	0b00011000,
	0b00000000,
	0b00011000,
	0b00011000,
	0b00000000,

// 59 ;
	0b00011000,
	0b00011000,
	0b00000000,
	0b00011000,
	0b00011000,
	0b00110000,
	0b00000000,

// 60 <
	0b00001000,
	0b00010000,
	0b00100000,
	0b01000000,
	0b00100000,
	0b00010000,
	0b00001000,

// 61 =
	0b00000000,
	0b01111100,
	0b00000000,
	0b00000000,
	0b01111100,
	0b00000000,
	0b00000000,

// 62 >
	0b00100000,
	0b00010000,
	0b00001000,
	0b00000100,
	0b00001000,
	0b00010000,
	0b00100000,

// 63 ?
	0b00111000,
	0b00001000,
	0b00001000,
	0b00010000,
	0b00000000,
	0b00010000,
	0b00000000,

// 64 @
	0b00111100,
	0b01000010,
	0b01011010,
	0b01011010,
	0b01011110,
	0b01000000,
	0b00111100,

// 65 A
	0b00011000,
	0b00100100,
	0b00100100,
	0b00111100,
	0b00100100,
	0b00100100,
	0b00000000,

// 66 B
	0b00111000,
	0b00100100,
	0b00111000,
	0b00100100,
	0b00100100,
	0b00111000,
	0b00000000,

// 67 C
	0b00111000,
	0b01000100,
	0b01000000,
	0b01000000,
	0b01000100,
	0b00111000,
	0b00000000,

// 68 D
	0b01110000,
	0b01001000,
	0b01000100,
	0b01000100,
	0b01001000,
	0b01110000,
	0b00000000,

// 69 E
	0b01111100,
	0b01000000,
	0b01111000,
	0b01000000,
	0b01000000,
	0b01111100,
	0b00000000,

// 70 F
	0b01111100,
	0b01000000,
	0b01000000,
	0b01111000,
	0b01000000,
	0b01000000,
	0b00000000,

// 71 G
	0b01111100,
	0b01000000,
	0b01000000,
	0b01001100,
	0b01000100,
	0b01111100,
	0b00000000,

// 72 H
	0b01000100,
	0b01000100,
	0b01111100,
	0b01000100,
	0b01000100,
	0b01000100,
	0b00000000,

// 73 I
	0b00111000,
	0b00010000,
	0b00010000,
	0b00010000,
	0b00010000,
	0b00111000,
	0b00000000,

// 74 J
	0b01111100,
	0b00010000,
	0b00010000,
	0b00010000,
	0b10010000,
	0b01110000,
	0b00000000,

// 75 K
	0b01000100,
	0b01001000,
	0b01110000,
	0b01001000,
	0b01000100,
	0b01000100,
	0b00000000,

// 76 L
	0b01000000,
	0b01000000,
	0b01000000,
	0b01000000,
	0b01000000,
	0b01111100,
	0b00000000,

// 77 M
	0b01000100,
	0b01101100,
	0b01111100,
	0b01010100,
	0b01010100,
	0b01000100,
	0b00000000,

// 78 N
	0b01000100,
	0b01100100,
	0b01100100,
	0b01010100,
	0b01001100,
	0b01001100,
	0b00000000,

// 79 O
	0b01111100,
	0b01000100,
	0b01000100,
	0b01000100,
	0b01000100,
	0b01111100,
	0b00000000,

// 80 P
	0b01111000,
	0b01001000,
	0b01001000,
	0b01111000,
	0b01000000,
	0b01000000,
	0b00000000,

// 81 Q
	0b00111000,
	0b01000100,
	0b01000100,
	0b01000100,
	0b01001000,
	0b00110110,
	0b00000000,

// 82 R
	0b01111000,
	0b01001000,
	0b01110000,
	0b01001000,
	0b01000100,
	0b01000100,
	0b00000000,

// 83 S
	0b00111100,
	0b01000000,
	0b00111000,
	0b00000100,
	0b00000100,
	0b01111000,
	0b00000000,

// 84 T
	0b11111110,
	0b00010000,
	0b00010000,
	0b00010000,
	0b00010000,
	0b00010000,
	0b00000000,

// 85 U
	0b01000100,
	0b01000100,
	0b01000100,
	0b01000100,
	0b01000100,
	0b01111100,
	0b00000000,

// 86 V
	0b01000100,
	0b01000100,
	0b01000100,
	0b00101000,
	0b00101000,
	0b00010000,
	0b00000000,

// 87 W
	0b01000100,
	0b01000100,
	0b01010100,
	0b01010100,
	0b00101000,
	0b00101000,
	0b00000000,

// 88 X
	0b01000100,
	0b00101000,
	0b00010000,
	0b00101000,
	0b01000100,
	0b01000100,
	0b00000000,

// 89 Y
	0b01000100,
	0b01000100,
	0b00101000,
	0b00010000,
	0b00010000,
	0b00010000,
	0b00000000,

// 90 Z
	0b00111100,
	0b00000100,
	0b00001000,
	0b00010000,
	0b00100000,
	0b00111100,
	0b00000000,

// 91 [
	0b00110000,
	0b00100000,
	0b00100000,
	0b00100000,
	0b00100000,
	0b00110000,
	0b00000000,

// 92 \ backslash 
	0b01000000,
	0b00100000,
	0b00010000,
	0b00001000,
	0b00000100,
	0b00000010,
	0b00000000,

// 93 ]
	0b00110000,
	0b00010000,
	0b00010000,
	0b00010000,
	0b00010000,
	0b00110000,
	0b00000000,

// 94 ^
	0b00010000,
	0b00101000,
	0b01000100,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,

// 95 _
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b11111110,
	0b00000000,

// 96 `
	0b00100000,
	0b00100000,
	0b00010000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,

// 97 a
	0b00000000,
	0b00110000,
	0b00001000,
	0b00111000,
	0b01001000,
	0b00110100,
	0b00000000,

// 98 b
	0b00100000,
	0b00100000,
	0b00111000,
	0b00100100,
	0b00100100,
	0b00111000,
	0b00000000,

// 99 c
	0b00000000,
	0b00000000,
	0b00111000,
	0b00100000,
	0b00100000,
	0b00111000,
	0b00000000,

// 100 d
	0b00001000,
	0b00001000,
	0b00001000,
	0b00111000,
	0b00101000,
	0b00111000,
	0b00000000,

// 101 e
	0b00000000,
	0b00110000,
	0b01001000,
	0b01111000,
	0b01000000,
	0b00110000,
	0b00000000,

// 102 f
	0b00011000,
	0b00100000,
	0b00100000,
	0b01111000,
	0b00100000,
	0b00100000,
	0b00000000,

// 103 g
	0b00000000,
	0b00000000,
	0b00111100,
	0b00100100,
	0b00111100,
	0b00000100,
	0b00111000,

// 104 h
	0b00100000,
	0b00100000,
	0b00110000,
	0b00101000,
	0b00101000,
	0b00101000,
	0b00000000,

// 105 i
	0b00010000,
	0b00000000,
	0b00010000,
	0b00010000,
	0b00010000,
	0b00010000,
	0b00000000,

// 106 j
	0b00001000,
	0b00000000,
	0b00011000,
	0b00001000,
	0b00001000,
	0b00101000,
	0b00011000,

// 107 k
	0b00100000,
	0b00100000,
	0b00101000,
	0b00110000,
	0b00101000,
	0b00100100,
	0b00000000,

// 108 l
	0b00110000,
	0b00010000,
	0b00010000,
	0b00010000,
	0b00010000,
	0b00010000,
	0b00000000,

// 109 m
	0b00000000,
	0b00000000,
	0b01101100,
	0b01010100,
	0b01010100,
	0b01000100,
	0b00000000,

// 110 n
	0b00000000,
	0b00000000,
	0b00111000,
	0b00100100,
	0b00100100,
	0b00100100,
	0b00000000,

// 111 o
	0b00000000,
	0b00000000,
	0b00011000,
	0b00100100,
	0b00100100,
	0b00011000,
	0b00000000,

// 112 p
	0b00000000,
	0b00000000,
	0b00111000,
	0b00100100,
	0b00111000,
	0b00100000,
	0b00100000,

// 113 q
	0b00000000,
	0b00000000,
	0b00011100,
	0b00100100,
	0b00011100,
	0b00000100,
	0b00000100,

// 114 r
	0b00000000,
	0b00000000,
	0b01011100,
	0b01100000,
	0b01000000,
	0b01000000,
	0b00000000,

// 115 s
	0b00000000,
	0b00111000,
	0b00100000,
	0b00111000,
	0b00001000,
	0b00111000,
	0b00000000,

// 116 t
	0b00010000,
	0b00010000,
	0b00111100,
	0b00010000,
	0b00010000,
	0b00011000,
	0b00000000,

// 117 u
	0b00000000,
	0b00000000,
	0b01001000,
	0b01001000,
	0b01001000,
	0b00110100,
	0b00000000,

// 118 v
	0b00000000,
	0b00000000,
	0b01000100,
	0b01000100,
	0b00101000,
	0b00010000,
	0b00000000,

// 119 w
	0b00000000,
	0b00000000,
	0b01000100,
	0b01000100,
	0b01010100,
	0b00101000,
	0b00000000,

// 120 x
	0b00000000,
	0b01000100,
	0b00101000,
	0b00010000,
	0b00101000,
	0b01000100,
	0b00000000,

// 121 y
	0b00000000,
	0b00000000,
	0b00100100,
	0b00100100,
	0b00011000,
	0b00001000,
	0b00110000,

// 122 z
	0b00000000,
	0b00000000,
	0b00111100,
	0b00001000,
	0b00010000,
	0b00111100,
	0b00000000,

// 123 {
	0b00011000,
	0b00010000,
	0b00010000,
	0b00100000,
	0b00010000,
	0b00010000,
	0b00011000,

// 124 |
	0b00010000,
	0b00010000,
	0b00010000,
	0b00000000,
	0b00010000,
	0b00010000,
	0b00010000,

// 125
	0b00110000,
	0b00010000,
	0b00010000,
	0b00001000,
	0b00010000,
	0b00010000,
	0b00110000,

// 126 ~
	0b00000000,
	0b00110010,
	0b01001100,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,

// 127 
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
	0b00000000,
};
//}}}
#endif
#if 0
//{{{
ECONST uchar tiles_5x5[128*5] SEG(4) =
{
 /* 0     Mask        */ 0x07, 0x07, 0x07, 0x07, 0x07,
 /* 1     Blacktile   */ 0xF8, 0xF8, 0xF8, 0xF8, 0xF8,
 /* 2     Whitetile   */ 0x00, 0x00, 0x00, 0x00, 0x00,
 /* 3     Unlit floor */ 0x00, 0x00, 0x00, 0x00, 0x00,
 /* 4     Lit floor   */ 0x00, 0x00, 0x20, 0x00, 0x00,
 /* 5     Wall        */ 0xF8, 0xF8, 0xF8, 0xF8, 0xF8,
 /* 6     Water       */ 0x50, 0xA0, 0x00, 0x50, 0x00,
 /* 7     Plains      */ 0x00, 0x00, 0x00, 0x20, 0x00,
 /* 8     Road        */ 0x00, 0x00, 0x00, 0x70, 0x00,
 /* 9     Mountain 1  */ 0x00, 0x00, 0x20, 0x50, 0x88,
 /* 10    Mountain 2  */ 0x00, 0x20, 0x50, 0x88, 0x00,
 /* 11    Horizontal beam */ 0x00, 0x40, 0xA8, 0x10, 0x00,
 /* 12    Vertical beam */ 0x20, 0x10, 0x20, 0x40, 0x20,
 /* 13    First diagonal beam */ 0x80, 0x80, 0x60, 0x20, 0x18,
 /* 14    Second diagonal beam */ 0x08, 0x08, 0x30, 0x20, 0xC0,
 /* 15    Sign        */ 0x00, 0xF8, 0xF8, 0x20, 0x00,
 /* 16    Spider web  */ 0xA8, 0x50, 0xA8, 0x50, 0xA8,
 /* 17    Unexplored  */ 0x08, 0x10, 0x20, 0x40, 0x80,
 /* 18    Fountain    */ 0x50, 0xA8, 0x20, 0xF8, 0x70,
 /* 19    Town        */ 0x00, 0x50, 0xF8, 0xF8, 0x00,
 /* 20    Cave        */ 0x00, 0x70, 0xA8, 0x88, 0x70,
 /* 21                */ 0x00, 0x00, 0x00, 0x00, 0x00,
 /* 22                */ 0x00, 0x00, 0x00, 0x00, 0x00,
 /* 23                */ 0x00, 0x00, 0x00, 0x00, 0x00,
 /* 24                */ 0x00, 0x00, 0x00, 0x00, 0x00,
 /* 25                */ 0x00, 0x00, 0x00, 0x00, 0x00,
 /* 26                */ 0x00, 0x00, 0x00, 0x00, 0x00,
 /* 27                */ 0x00, 0x00, 0x00, 0x00, 0x00,
 /* 28                */ 0x00, 0x00, 0x00, 0x00, 0x00,
 /* 29                */ 0x00, 0x00, 0x00, 0x00, 0x00,
 /* 30                */ 0x00, 0x00, 0x00, 0x00, 0x00,
 /* 31                */ 0x00, 0x00, 0x00, 0x00, 0x00,
 /* 32                */ 0x00, 0x00, 0x00, 0x00, 0x00,
 /* 33 !              */ 0x20, 0x20, 0x20, 0x00, 0x20,
 /* 34 "              */ 0x50, 0x50, 0x00, 0x00, 0x00,
 /* 35 #              */ 0x50, 0xF8, 0x50, 0xF8, 0x50,
 /* 36 $              */ 0x70, 0xA0, 0x70, 0x28, 0x70,
 /* 37 %              */ 0x00, 0x90, 0x20, 0x48, 0x00,
 /* 38 &              */ 0x00, 0x60, 0x28, 0x50, 0x28,
 /* 39 '              */ 0x20, 0x20, 0x00, 0x00, 0x00,
 /* 40 (              */ 0x00, 0x20, 0x40, 0x40, 0x20,
 /* 41 )              */ 0x00, 0x20, 0x10, 0x10, 0x20,
 /* 42 *              */ 0x00, 0x30, 0x50, 0x60, 0x00,
 /* 43 +              */ 0x00, 0x20, 0x70, 0x20, 0x00,
 /* 44 ,              */ 0x00, 0x00, 0x00, 0x20, 0x40,
 /* 45 -              */ 0x00, 0x00, 0x70, 0x00, 0x00,
 /* 46 .              */ 0x00, 0x00, 0x00, 0x30, 0x30,
 /* 47 /              */ 0x00, 0x10, 0x20, 0x40, 0x80,
 /* 48 0              */ 0x00, 0x70, 0x50, 0x50, 0x70,
 /* 49 1              */ 0x00, 0x20, 0x20, 0x20, 0x20,
 /* 50 2              */ 0x00, 0x60, 0x10, 0x20, 0x70,
 /* 51 3              */ 0x60, 0x10, 0x30, 0x10, 0x60,
 /* 52 4              */ 0x00, 0x30, 0x50, 0x70, 0x10,
 /* 53 5              */ 0x00, 0x70, 0x40, 0x30, 0x60,
 /* 54 6              */ 0x00, 0x30, 0x40, 0x70, 0x70,
 /* 55 7              */ 0x00, 0x70, 0x10, 0x20, 0x40,
 /* 56 8              */ 0x20, 0x50, 0x20, 0x50, 0x20,
 /* 57 9              */ 0x00, 0x70, 0x70, 0x10, 0x70,
 /* 58 :              */ 0x00, 0x20, 0x00, 0x20, 0x00,
 /* 59 ;              */ 0x00, 0x20, 0x00, 0x20, 0x40,
 /* 60 <              */ 0x10, 0x20, 0x40, 0x20, 0x10,
 /* 61 =              */ 0x00, 0x70, 0x00, 0x70, 0x00,
 /* 62 >              */ 0x40, 0x20, 0x10, 0x20, 0x40,
 /* 63 ?              */ 0x60, 0x10, 0x20, 0x00, 0x20,
 /* 64 @              */ 0x70, 0xF8, 0xF8, 0xF8, 0x70,
 /* 65 A              */ 0x30, 0x48, 0x78, 0x48, 0x48,
 /* 66 B              */ 0x70, 0x48, 0x70, 0x48, 0x70,
 /* 67 C              */ 0x70, 0x40, 0x40, 0x40, 0x70,
 /* 68 D              */ 0x70, 0x48, 0x48, 0x48, 0x70,
 /* 69 E              */ 0x70, 0x40, 0x70, 0x40, 0x70,
 /* 70 F              */ 0x70, 0x40, 0x70, 0x40, 0x40,
 /* 71 G              */ 0x70, 0x40, 0x50, 0x50, 0x70,
 /* 72 H              */ 0x48, 0x48, 0x78, 0x48, 0x48,
 /* 73 I              */ 0x70, 0x20, 0x20, 0x20, 0x70,
 /* 74 J              */ 0x78, 0x10, 0x10, 0x50, 0x70,
 /* 75 K              */ 0x48, 0x50, 0x60, 0x50, 0x48,
 /* 76 L              */ 0x40, 0x40, 0x40, 0x40, 0x78,
 /* 77 M              */ 0x48, 0x78, 0x78, 0x78, 0x48,
 /* 78 N              */ 0x48, 0x68, 0x68, 0x58, 0x58,
 /* 79 O              */ 0x78, 0x48, 0x48, 0x48, 0x78,
 /* 80 P              */ 0x70, 0x50, 0x70, 0x40, 0x40,
 /* 81 Q              */ 0x30, 0x48, 0x48, 0x58, 0x38,
 /* 82 R              */ 0x70, 0x48, 0x70, 0x48, 0x48,
 /* 83 S              */ 0x78, 0x40, 0x78, 0x08, 0x78,
 /* 84 T              */ 0xF8, 0x20, 0x20, 0x20, 0x20,
 /* 85 U              */ 0x48, 0x48, 0x48, 0x48, 0x78,
 /* 86 V              */ 0x48, 0x48, 0x48, 0x30, 0x30,
 /* 87 W              */ 0x88, 0xA8, 0xA8, 0x70, 0x70,
 /* 88 X              */ 0x48, 0x48, 0x30, 0x48, 0x48,
 /* 89 Y              */ 0x88, 0x88, 0x50, 0x20, 0x20,
 /* 90 Z              */ 0x70, 0x10, 0x20, 0x40, 0x70,
 /* 91 [              */ 0x00, 0x60, 0x40, 0x40, 0x60,
 /* 92 \ backslash    */ 0x00, 0x80, 0x40, 0x20, 0x10,
 /* 93 ]              */ 0x00, 0x60, 0x20, 0x20, 0x60,
 /* 94 ^              */ 0x20, 0x50, 0x00, 0x00, 0x00,
 /* 95 _              */ 0x00, 0x00, 0x00, 0x00, 0xF8,
 /* 96 `              */ 0x40, 0x20, 0x00, 0x00, 0x00,
 /* 97 a              */ 0x00, 0x70, 0x10, 0x70, 0x70,
 /* 98 b              */ 0x40, 0x40, 0x70, 0x50, 0x70,
 /* 99 c              */ 0x00, 0x70, 0x40, 0x40, 0x70,
 /* 100 d             */ 0x10, 0x10, 0x70, 0x50, 0x70,
 /* 101 e             */ 0x00, 0x70, 0x70, 0x40, 0x70,
 /* 102 f             */ 0x10, 0x20, 0x70, 0x20, 0x20,
 /* 103 g             */ 0x00, 0x70, 0x70, 0x10, 0x60,
 /* 104 h             */ 0x40, 0x40, 0x70, 0x50, 0x50,
 /* 105 i             */ 0x20, 0x00, 0x20, 0x20, 0x20,
 /* 106 j             */ 0x10, 0x00, 0x30, 0x10, 0x70,
 /* 107 k             */ 0x00, 0x50, 0x60, 0x50, 0x50,
 /* 108 l             */ 0x00, 0x20, 0x20, 0x20, 0x20,
 /* 109 m             */ 0x00, 0x50, 0x70, 0x70, 0x50,
 /* 110 n             */ 0x00, 0x60, 0x50, 0x50, 0x50,
 /* 111 o             */ 0x00, 0x70, 0x50, 0x50, 0x70,
 /* 112 p             */ 0x00, 0x60, 0x50, 0x60, 0x40,
 /* 113 q             */ 0x00, 0x30, 0x50, 0x30, 0x10,
 /* 114 r             */ 0x00, 0x30, 0x40, 0x40, 0x40,
 /* 115 s             */ 0x00, 0x70, 0x60, 0x10, 0x70,
 /* 116 t             */ 0x20, 0x20, 0x70, 0x20, 0x20,
 /* 117 u             */ 0x00, 0x50, 0x50, 0x50, 0x70,
 /* 118 v             */ 0x00, 0x00, 0x50, 0x50, 0x20,
 /* 119 w             */ 0x00, 0x00, 0x50, 0x70, 0x70,
 /* 120 x             */ 0x00, 0x00, 0x50, 0x20, 0x50,
 /* 121 y             */ 0x00, 0x50, 0x50, 0x20, 0x40,
 /* 122 z             */ 0x00, 0x70, 0x10, 0x20, 0x70,
 /* 123 {             */ 0x20, 0x40, 0x60, 0x40, 0x20,
 /* 124 |             */ 0x20, 0x20, 0x00, 0x20, 0x20,
 /* 125 }             */ 0x20, 0x10, 0x30, 0x10, 0x20,
 /* 126 ~             */ 0x00, 0x28, 0x50, 0x00, 0x00,
 /* 127               */ 0x00, 0x00, 0x00, 0x00, 0x00,
};
//}}}
#endif

#ifndef USE_TILES
//{{{
ECONST uchar tiles[128] = {
0,   ' ', 2,   '.', '.', '#', '~', '.', '.', '^', '^', '-', '|', '\\','/', 't',
'%', ' ', '}', '*', '*', 21,  22,  23,  24,  25,  26,  27,  28,  29,  30,  31,  
32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,  45,  46,  47,  
48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,  60,  61,  62,  63,  
64,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,  75,  76,  77,  78,  79,  
80,  81,  82,  83,  84,  85,  86,  87,  88,  89,  90,  91,  92,  93,  94,  95,  
96,  97,  98,  99,  100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 
112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
}; 
//}}}
#endif //USE_TILES
