#include <QDebug>
#include <QVBoxLayout>
#include <QGroupBox>
#include <QScrollArea>
#include <QDialogButtonBox>
#include <QGeoServiceProvider>
#include <QLabel>
#include <QSettings>

#include "settingsdialog.h"

void SettingsDialog::applyChanges() {
  qDebug() << __FUNCTION__;

  int type = m_typeCombo->itemData(m_typeCombo->currentIndex()).toInt();
  QString serviceStr = m_serviceCombo->currentText();
  bool hiRez = m_hiRez->isChecked();

  QSettings settings;
  settings.beginGroup("Map");
  settings.setValue("Type", type);
  settings.setValue("Service", serviceStr);
  settings.setValue("HiRez", hiRez);
  settings.endGroup();

  settings.beginGroup("Account");
  settings.setValue("Name", m_name->text());
  settings.setValue("Password", m_password->text());
  settings.endGroup();

  // type and hirez is handled immediately
  m_mapWidget->setMapType((QGraphicsGeoMap::MapType)type);
  m_mapWidget->setHiRez(hiRez);
}

SettingsDialog::SettingsDialog(MapWidget *mapWidget, 
			       CacheProvider *cacheProvider, QWidget *parent) :
  QDialog(parent) {

  this->m_mapWidget = mapWidget;

  setWindowTitle(tr("Settings"));

#ifdef Q_WS_MAEMO_5
  resize(QSize(800, 800));

  QVBoxLayout *outerLayout = new QVBoxLayout;

  QScrollArea *scrollArea = new QScrollArea(this);
  scrollArea->setWidgetResizable(true);
  scrollArea->setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);

  QWidget *scrollWidget = new QWidget;
  QVBoxLayout *mainLayout = new QVBoxLayout;
  mainLayout->setContentsMargins(0,0,0,0);
#else
  QVBoxLayout *mainLayout = new QVBoxLayout;
#endif

  QGroupBox *groupBox = new QGroupBox();
  QGridLayout *grid = new QGridLayout;
  grid->setContentsMargins(0,0,0,0);
  grid->setVerticalSpacing(0);

  const QString mapTypeStr[] = {
    "No Map", tr("Street Map"), tr("Satellite Map Day"), 
    tr("Satellite Map Night"), tr("Terrain Map") };

  /* -------------- map type combo box --------------- */
  grid->addWidget(new QLabel(tr("Map type") + ":", this), 0, 0);

  m_typeCombo = new QComboBox(this);
  QList<QGraphicsGeoMap::MapType> types = mapWidget->supportedMapTypes(); 

  // add entry for all map types
  for(int i = 0; i < types.size(); i++) {
    m_typeCombo->addItem(mapTypeStr[types[i]], types[i]);
    
    if(types[i] == mapWidget->mapType())
      m_typeCombo->setCurrentIndex(i);
  }

  grid->addWidget(m_typeCombo, 0, 1);

  /* -------------- geo service combo box --------------- */
  grid->addWidget(new QLabel(tr("Map service") + ":", this), 1, 0);

  m_serviceCombo = new QComboBox(this);
  QStringList list = QGeoServiceProvider::availableServiceProviders();
  for(int i=0;i<list.size();i++) {
    m_serviceCombo->addItem(list[i]);

    if(list[i] == mapWidget->managerName())
      m_serviceCombo->setCurrentIndex(i);
  }
 
  grid->addWidget(m_serviceCombo, 1, 1);
  QLabel *label = new QLabel("<small>" + tr("A change of the map service "
			"takes effect after restart.") + "</small>", this);
  label->setWordWrap(true);
  grid->addWidget(label, 2, 0, 1, 2);

  groupBox->setLayout(grid);
  mainLayout->addWidget(groupBox);

  /* -------------- hirez switch ------------------ */
  m_hiRez = new QCheckBox( tr("High density display"), this);
  m_hiRez->setChecked(mapWidget->hiRez());
  mainLayout->addWidget(m_hiRez);


  /* ------------------- user configuration --------------------- */

  QSettings settings;
  settings.beginGroup("Account");

  groupBox = new QGroupBox(tr("Geocaching.com account"));
  grid = new QGridLayout;
  grid->setContentsMargins(0,0,0,0);
  grid->setVerticalSpacing(0);

  /* -------------- user name entry --------------- */

  grid->addWidget(new QLabel(tr("Username") + ":"), 0, 0);
  m_name = new QLineEdit(settings.value("Name", "").toString());
  grid->addWidget(m_name, 0, 1);

  /* -------------- password entry --------------- */
  grid->addWidget(new QLabel(tr("Password") + ":"), 1, 0);
  m_password = new QLineEdit(settings.value("Password", "").toString());
  m_password->setEchoMode(QLineEdit::PasswordEchoOnEdit);
  grid->addWidget(m_password, 1, 1);

  groupBox->setLayout(grid);
  mainLayout->addWidget(groupBox);


  settings.endGroup();

  connect(this, SIGNAL(accepted()), this, SLOT(applyChanges()));

  /* ------------------------ plugins ------------------------ */

  // currently all plugins just connect to the accept signal, but
  // don't create any own settings
  cacheProvider->pluginConfig(this, mainLayout);

  QDialogButtonBox *buttonBox = new QDialogButtonBox(QDialogButtonBox::Ok
				     | QDialogButtonBox::Cancel);

  connect(buttonBox, SIGNAL(accepted()), this, SLOT(accept()));
  connect(buttonBox, SIGNAL(rejected()), this, SLOT(reject()));

#ifdef Q_WS_MAEMO_5
  mainLayout->addStretch();
  scrollWidget->setLayout(mainLayout);
  scrollArea->setWidget(scrollWidget);
  outerLayout->addWidget(scrollArea);

  outerLayout->addWidget(buttonBox);
  setLayout(outerLayout);
#else
  mainLayout->addWidget(buttonBox);
  setLayout(mainLayout);
#endif
}
