#include <QDebug>

#include <QLabel>
#include <QFont>
#include <QHBoxLayout>

#include "iconlabel.h"
#include "iconloader.h"

int IconLabel::prepare(const QString &text, qreal scale) {
  QHBoxLayout *layout = new QHBoxLayout;
  layout->setContentsMargins(0,0,0,0);
  setLayout(layout);

  QLabel *label = new QLabel(text, this);
  QFont font = label->font();

  font.setPointSize(font.pointSize()*scale);
  label->setFont(font);
  label->setWordWrap(true);
  QFontInfo fontInfo(label->font());
  layout->addWidget(label, 1);

  return QFontMetrics(font).height();
}

IconLabel::IconLabel(IconLoader *loader, const QStringList &icon,
     const QString &text, qreal scale, QWidget *parent) : QWidget(parent) {

  int iconSize = prepare(text, scale);

  QHBoxLayout *hbox = static_cast<QHBoxLayout *>(layout());
  hbox->insertWidget(0, loader->newWidget(icon, iconSize));		      
}

IconLabel::IconLabel(IconLoader *loader, const QString &icon,
     const QString &text, qreal scale, QWidget *parent) : QWidget(parent) {

  int iconSize = prepare(text, scale);

  QHBoxLayout *hbox = static_cast<QHBoxLayout *>(layout());
  hbox->insertWidget(0, loader->newWidget(icon, iconSize));		      
}

IconLabel::IconLabel(IconLoader *loader, const Cache &cache,
     const QString &text, qreal scale, QWidget *parent) : QWidget(parent) {

  int iconSize = prepare(text, scale);

  QHBoxLayout *hbox = static_cast<QHBoxLayout *>(layout());
  hbox->insertWidget(0, loader->newWidget(cache, iconSize));		      
}
