// Filename: logwindow.cpp

#include <QDebug>

#include <QVBoxLayout>
#include <QGroupBox>
#include <QLabel>
#include <QScrollArea>

#include "htmlview.h"
#include "logwindow.h"
#include "iconlabel.h"

class LogWidget : public QGroupBox {
public:
  LogWidget(IconLoader *loader, const Log &log,
	    QWidget *parent = 0) : QGroupBox(parent) {

    QString foundByMessage("(" + log.type().toString() + ") " +
        log.date().toString() + " " + tr("by") + " " + log.finder());

    QVBoxLayout *layout = new QVBoxLayout;
    layout->setContentsMargins(0,0,0,0);

    layout->addWidget(new IconLabel(loader, log.type().iconFile(),
				    foundByMessage));

    layout->addWidget(new FixHtmlView(log.description(), this));
    setLayout(layout);
  }
};

LogWindow::LogWindow(const QList<Log> &logs, QWidget *parent) : 
  CustomWindow("LogWindow", parent),  m_logs(logs), m_iconLoader(24) {

  setWindowTitle(tr("Logs"));

  QScrollArea *scrollArea = new QScrollArea(this);
  scrollArea->setWidgetResizable(true);
  scrollArea->setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);

  QWidget *scrollWidget = new QWidget;
  QVBoxLayout *scrollvbox = new QVBoxLayout;
  scrollvbox->setContentsMargins(0,0,0,0);

  foreach(Log log, logs)
    scrollvbox->addWidget(new LogWidget(&m_iconLoader, log, this),0,0);

  scrollvbox->addStretch(1);
  scrollWidget->setLayout(scrollvbox);
  scrollArea->setWidget(scrollWidget);
  
  setCentralWidget(scrollArea);
}

LogWindow::~LogWindow() {
  qDebug() << __FUNCTION__;
}

