######################################################################
# 
# cacheme.pro - project file for cacheme
#
######################################################################

TEMPLATE = app
include(../common.pri)
MOBILITY += sensors

TARGET = $$APPNAME
DEPENDPATH += .
QT += svg xml network

# generic helpers
HEADERS += filefinder.h iconloader.h
SOURCES += filefinder.cpp iconloader.cpp 

# Input
HEADERS += customwindow.h iconlabel.h mainwindow.h cache.h cacheprovider.h cacheproviderplugin.h
SOURCES += customwindow.cpp iconlabel.cpp mainwindow.cpp main.cpp cache.cpp cacheprovider.cpp

# cache detail view
HEADERS += swapbox.h cachewindow.h htmlview.h descriptionwindow.h logwindow.h attributewindow.h
SOURCES += swapbox.cpp cachewindow.cpp htmlview.cpp descriptionwindow.cpp logwindow.cpp attributewindow.cpp

# the map
HEADERS += size.h mapwidget.h mapoverlay.h mapbutton.h mapbuttonmanager.h mapbubble.h settingsdialog.h mapbanner.h mapbannerentry.h mapspinner.h
SOURCES += mapwidget.cpp mapoverlay.cpp mapbutton.cpp mapbuttonmanager.cpp mapbubble.cpp settingsdialog.cpp mapbanner.cpp mapbannerentry.cpp mapspinner.cpp

# gps and navigation
HEADERS += locationprovider.h navigationwindow.h compass.h
SOURCES += locationprovider.cpp navigationwindow.cpp compass.cpp

unix {
  # for qt maemo5 and symbian are also unix 
  # meego may actually have a use for this
  !maemo5 || !symbian {
    HEADERS += gpsdpositioninfosource.h json.h
    SOURCES += gpsdpositioninfosource.cpp json.cpp
    DEFINES += GPSDPOSITIONINFOSOURCE
  }
}

# pocket query support
# HEADERS += gpx.h gpxparser.h gpxfileparser.h
# SOURCES += gpx.cpp gpxparser.cpp gpxfileparser.cpp

# disabled stuff
# HEADERS += cachelistpage.h cachemodel.h cachepage.h cachecell.h
# SOURCES += cachelistpage.cpp cachemodel.cpp cachepage.cpp cachecell.cpp

# Include local Quazip for ZIP handling
#HEADERS += $$QUAZIP/crypt.h $$QUAZIP/quachecksum32.h $$QUAZIP/quazipfileinfo.h $$QUAZIP/quazipnewinfo.h $$QUAZIP/zip.h $$QUAZIP/ioapi.h $$QUAZIP/quacrc32.h $$QUAZIP/quaadler32.h $$QUAZIP/quazipfile.h $$QUAZIP/quazip.h $$QUAZIP/unzip.h
#SOURCES += $$QUAZIP/ioapi.c $$QUAZIP/unzip.c $$QUAZIP/zip.c $$QUAZIP/quaadler32.cpp $$QUAZIP/quazip.cpp $$QUAZIP/quacrc32.cpp $$QUAZIP/quazipnewinfo.cpp $$QUAZIP/quazipfile.cpp

symbian: {
#    TARGET.CAPABILITY = Location \
#                        NetworkServices \
#                        ReadUserData \
#                        WriteUserData \
#                        ReadDeviceData \
#                        WriteDeviceData

  # TARGET is also the icon label
  TARGET = CacheMe
  DEFINES += APPNAME=\"$$APPNAME\" VERSION=\"$$VERSION\"
  RESOURCES = ../cacheme.qrc

  INCLUDEPATH += MW_LAYER_SYSTEMINCLUDE // Not sure if this is needed...
  LIBS += -L\epoc32\release\armv5\lib -lremconcoreapi
  LIBS += -L\epoc32\release\armv5\lib -lremconinterfacebase

  TARGET.CAPABILITY = Location NetworkServices
#  TARGET.UID3 = 0x2002BFCA
  TARGET.EPOCHEAPSIZE = 0x20000 0x1000000 // Min 128kb, Max 16Mb

  # datadir on symbian only holds the plugins as other files are included into the exe
  DATADIR = /data/$$APPNAME

  cacheprovider.sources = ../plugins/cacheprovider/gclive.dll
  cacheprovider.path = $$DATADIR/plugins/cacheprovider
  DEPLOYMENT += cacheprovider

  geoservices.sources = ../plugins/geoservices/qtgeoservices_osm.dll ../plugins/geoservices/qtgeoservices_cm.dll
  geoservices.path = $$DATADIR/plugins/geoservices
  DEPLOYMENT += geoservices

  DEFINES += DATADIR=\"$$DATADIR\" LIBDIR=\"$$DATADIR\"

  # symbian has problems with gradients, so use a solid bg for app icon
  ICON = ../data/symbian.svg

} else {

  DESTDIR = ..
  DEFINES += APPNAME=\\\"$$APPNAME\\\" VERSION=\\\"$$VERSION\\\"

  unix {
    #VARIABLES
    isEmpty(PREFIX) {
      PREFIX = /usr
    }

    LIBS += -rdynamic
    BINDIR = $$PREFIX/bin
    LIBDIR =$$PREFIX/lib
    DATADIR =$$PREFIX/share

    DEFINES += DATADIR=\\\"$$DATADIR/$$APPNAME\\\" LIBDIR=\\\"$$LIBDIR/$$APPNAME\\\"

    #MAKE INSTALL

    INSTALLS += target desktop iconsvg icon64 icon48 icon26 icons translations

    target.path =$$BINDIR

    desktop.path = $$DATADIR/applications
    desktop.files = ../data/$${APPNAME}.desktop

    iconsvg.path = $$DATADIR/icons/hicolor/scalable/apps
    iconsvg.files = ../data/scalable/$${APPNAME}.svg

    icon64.path = $$DATADIR/icons/hicolor/64x64/apps
    icon64.files = ../data/64x64/$${APPNAME}.png

    icon48.path = $$DATADIR/icons/hicolor/48x48/apps
    icon48.files = ../data/48x48/$${APPNAME}.png

    icon26.path = $$DATADIR/icons/hicolor/26x26/apps
    icon26.files = ../data/26x26/$${APPNAME}.png

    icons.path = $$DATADIR/$${APPNAME}/icons
    icons.files = ../data/icons/*.svg

    translations.path = $$DATADIR/$${APPNAME}/lang
    translations.files = ../lang/*.qm

    maemo5 {
      # maemo5 expects everything in hildon and a 64x64 png in scalable ...
      desktop.path = $$DATADIR/applications/hildon
      iconsvg.path = $$DATADIR/icons/hicolor/scalable/hildon
      iconsvg.files = ../data/64x64/$${APPNAME}.png
      icon64.path = $$DATADIR/icons/hicolor/64x64/hildon
      icon48.path = $$DATADIR/icons/hicolor/48x48/hildon
      icon26.path = $$DATADIR/icons/hicolor/26x26/hildon
    }
  }
}

simulator {
  RESOURCES = ../cacheme.qrc
}

