#include <QDebug>
#include <QQueue>

#include "mapwidget.h"
#include "mapbanner.h"

MapBanner::MapBanner(MapWidget *mapWidget) : 
  m_mapWidget(mapWidget) {
}

MapBanner::~MapBanner() {
};

void MapBanner::message(const QString &msg) {
  MapBannerEntry *entry = new MapBannerEntry(m_mapWidget, msg);

  // connect to entries "done" signal to delete it from list
  QObject::connect( entry, SIGNAL(done(MapBannerEntry*)), 
		    this, SLOT(flush(MapBannerEntry*)) );
  m_entries.append(entry);
}

void MapBanner::flush(MapBannerEntry *entry) {
  // find entry in list
  int removed = m_entries.removeAll(entry);
  Q_ASSERT(removed == 1);

  entry->deleteLater();
}

void MapBanner::paint(QPainter *painter) {
  // for some very odd reason, the list gets deleted when using
  // the "foreach" operator instead
  MapBannerEntryList::const_iterator i;
  for( i = m_entries.begin(); i != m_entries.end(); ++i )
    (*i)->paint(painter);
}
