// Filename: logwindow.cpp

#include <QDebug>

#include <QVBoxLayout>
#include <QGroupBox>
#include <QLabel>
#include <QScrollArea>

#include "htmlview.h"
#include "logwindow.h"
#include "iconlabel.h"

class LogHtmlView : public HtmlView  {
public:
  LogHtmlView(const Description &desc, QWidget *parent) : 
    HtmlView(desc, parent) {
    setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
    setVerticalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
    m_width = 0;
  }

  bool eventFilter(QObject *obj, QEvent *event) {
    if((event->type() == QEvent::KeyPress) ||
       (event->type() == QEvent::Wheel))
      return true;
    
    return QObject::eventFilter(obj, event);
  }

  void adjust() {
    if(m_width != size().width()) {
      m_width = size().width();
      
      QMargins margins = contentsMargins();
      
      int width = size().width() - 
	margins.left() - margins.right() - document()->documentMargin()*2;
      document()->setPageSize(QSizeF(width,-1));
      
      int height = document()->size().height() + 
	margins.top() + margins.bottom();
      setMaximumHeight(height);
      setMinimumHeight(height);

    }
  }

  void showEvent(QShowEvent *) {
    adjust();
  }

  void resizeEvent(QResizeEvent *) {
    adjust();
  }
private:
  int m_width;
};

class LogWidget : public QGroupBox {
public:
  LogWidget(IconLoader *loader, const Log &log,
	    QWidget *parent = 0) : QGroupBox(parent) {

    QString foundByMessage("(" + log.type().toString() + ") " +
        log.date().toString() + " " + tr("by") + " " + log.finder());

    QVBoxLayout *layout = new QVBoxLayout;
    layout->setContentsMargins(0,0,0,0);

    layout->addWidget(new IconLabel(loader, log.type().iconFile(),
				    foundByMessage));

    layout->addWidget(new LogHtmlView(log.description(), this));
    setLayout(layout);
  }
};

LogWindow::LogWindow(const QList<Log> &logs, QWidget *parent) : 
  CustomWindow("LogWindow", parent),  m_logs(logs), m_iconLoader(24) {

  setWindowTitle(tr("Logs"));

  QScrollArea *scrollArea = new QScrollArea(this);
  scrollArea->setWidgetResizable(true);
  scrollArea->setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);

  QWidget *scrollWidget = new QWidget;
  QVBoxLayout *scrollvbox = new QVBoxLayout;
  scrollvbox->setContentsMargins(0,0,0,0);

  foreach(Log log, logs)
    scrollvbox->addWidget(new LogWidget(&m_iconLoader, log, this),0,0);

  scrollvbox->addStretch(1);
  scrollWidget->setLayout(scrollvbox);
  scrollArea->setWidget(scrollWidget);
  
  setCentralWidget(scrollArea);
}

LogWindow::~LogWindow() {
  qDebug() << __FUNCTION__;
}

