#include <QDebug>
#include "htmlview.h"

#include <QTextDocument>
#include <QNetworkRequest>

#include <QBuffer>
#include <QHttp>

HtmlView::HtmlView(const Description &desc, QWidget *parent) : QTextBrowser(parent) {
  qDebug() << __FUNCTION__;

  Q_ASSERT(desc.isHtml());  // non-html not yet supported

  // setup network manager and listen for its replies
  this->m_manager = new QNetworkAccessManager(this);
  
  connect(this->m_manager, SIGNAL(finished(QNetworkReply*)),
	  this, SLOT(replyFinished(QNetworkReply*)));

  QTextDocument *doc = new QTextDocument(this);
  doc->setHtml(desc.text());
  setDocument(doc);

  // open links in external browser
  setOpenExternalLinks(true);

  setReadOnly(true);
}
 
QVariant HtmlView::loadResource ( int, const QUrl &url) {
  QUrl localUrl(url); 

  if(localUrl.host().isNull()) {
    localUrl.setScheme("http");
    localUrl.setHost("www.geocaching.com");
  }
  
  if(!m_images.contains(localUrl)) {
    qDebug() << __FUNCTION__ << localUrl;

    // request download of image
    QNetworkRequest request;
    request.setUrl(localUrl);
    this->m_manager->get(request);
    
    m_images.insert(localUrl, QPixmap());

    return QVariant();
  }

  return m_images.value(localUrl);
}

void HtmlView::replyFinished(QNetworkReply *reply) {
  qDebug() << __FUNCTION__;

  // whatever happened, we are now idle again
  if(reply->error() != QNetworkReply::NoError) {
    qDebug() << __FUNCTION__ << "Reply error:" << reply->errorString();
    return;
  }

  if(reply->isFinished()) {
    QPixmap pix;
    if(pix.loadFromData(reply->readAll())) {
      m_images.insert(reply->url(), pix);
      
      // ugly method to force relayoutDocument()
      QTextDocument *doc = document();
      setDocument(doc);
    }
  }
}
