// Filename: descriptionwindow.cpp

#include <QDebug>

#include "htmlview.h"
#include "descriptionwindow.h"

DescriptionWindow::DescriptionWindow(const Cache &cache, QWidget *parent) : 
  CustomWindow("DescriptionWindow", parent) {

  setWindowTitle(cache.description());

  HtmlView *htmlView = new HtmlView(cache.longDescription());
  connect(this, SIGNAL(zoomInPressed()), htmlView, SLOT(zoomIn()));
  connect(this, SIGNAL(zoomOutPressed()), htmlView, SLOT(zoomOut()));

  setCentralWidget(htmlView);
}

DescriptionWindow::~DescriptionWindow() {
  qDebug() << __FUNCTION__;
}
