#ifndef CACHEWINDOW_H
#define CACHEWINDOW_H

#include "locationprovider.h"
#include "customwindow.h"
#include "cache.h"
#include "iconloader.h"
#include "htmlview.h"

class CacheWindow : public CustomWindow {
  Q_OBJECT;

 public:
  CacheWindow(const Cache &, LocationProvider *, QWidget * = 0);
  ~CacheWindow();

 private slots:
  void showDescription();
  void showNavigation();
  void showHint();
  void showLogs();
  void showAttributes();
  void openCacheUrl();

 private:
  Cache m_cache;
  IconLoader m_iconLoader;
  LocationProvider *m_locationProvider;
};

#endif
