// Filename: attributewindow.cpp

#include <QDebug>

#include <QHBoxLayout>
#include <QGroupBox>
#include <QLabel>
#include <QScrollArea>
#include <QFont>

#include "attributewindow.h"

class AttributeWidget : public QGroupBox {
public:
  AttributeWidget(IconLoader *loader, const Attribute &attribute,
	    QWidget *parent = 0) : QGroupBox(parent) {

    QHBoxLayout *layout = new QHBoxLayout;
    layout->setContentsMargins(0,0,0,0);

    QLabel *label = new QLabel(attribute.toString(), this);
    QFont font = label->font();
    font.setPointSize(font.pointSize()*1.5);
    label->setFont(font);
    label->setWordWrap(true);
    QFontInfo fontInfo(label->font());
    
    layout->addWidget(loader->newWidget(attribute.iconFile(), 
					fontInfo.pixelSize()*1.5));
    layout->addWidget(label, 1);
    setLayout(layout);
  }
};

AttributeWindow::AttributeWindow(const QList<Attribute> &attributes, 
				 QWidget *parent) : 
  CustomWindow("AttributeWindow", parent),  
  m_attributes(attributes), m_iconLoader(24) {

  setWindowTitle(tr("Attributes"));

  QScrollArea *scrollArea = new QScrollArea(this);
  scrollArea->setWidgetResizable(true);
  scrollArea->setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);

  QWidget *scrollWidget = new QWidget;
  QVBoxLayout *scrollvbox = new QVBoxLayout;
  scrollvbox->setContentsMargins(0,0,0,0);

  foreach(Attribute attribute, attributes)
    scrollvbox->addWidget(new AttributeWidget(&m_iconLoader, 
					      attribute, this),0,0);

  scrollvbox->addStretch(1);
  scrollWidget->setLayout(scrollvbox);
  scrollArea->setWidget(scrollWidget);
  
  setCentralWidget(scrollArea);
}

AttributeWindow::~AttributeWindow() {
  qDebug() << __FUNCTION__;
}

