#include <QDebug>

#include <QNmeaPositionInfoSource>

#include <QApplication>
#include <QDir>
#include <QFile>

#include "locationprovider.h"

void LocationProvider::positionHasBeenUpdated(const QGeoPositionInfo &pos) {
  emit positionUpdated(pos);
}

LocationProvider::LocationProvider() : QObject(), m_location(NULL) {
  qDebug() << __FUNCTION__;

  m_location = QGeoPositionInfoSource::createDefaultSource(this);
  if(!m_location) {
    qWarning() << __FUNCTION__ << ": No default position source available!";

    QNmeaPositionInfoSource *nmeaLocation = 
      new QNmeaPositionInfoSource(QNmeaPositionInfoSource::SimulationMode, this);
    nmeaLocation->setDevice(new QFile(QApplication::applicationDirPath() + 
				      QDir::separator() + ".." +
				      QDir::separator() + "nmealog.txt", this));
    m_location = nmeaLocation;

    qDebug() << __FUNCTION__ << ": Reading simulation data from log";
  }

  if(m_location) {
    m_location->setUpdateInterval(1000);
  
    connect(m_location, SIGNAL(positionUpdated(QGeoPositionInfo)),
	    this, SLOT(positionHasBeenUpdated(QGeoPositionInfo)));  

    m_location->startUpdates();
  } else
    qWarning() << __FUNCTION__ << ": Position reporting finally failed!";
}

LocationProvider::~LocationProvider() {
  qDebug() << __FUNCTION__;

  if(m_location)
    m_location->stopUpdates();
}
