/*
 * btc-minfo-provider-test.c
 *
 * This file is part of butaca
 * Copyright (C) 2010 Simón Pena <spenap@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 */

#include <stdio.h>
#include <glib.h>

#include "btc-minfo-provider.h"
#include "btc-tmdb-movie.h"
#include "btc-watc-movie.h"

static GMainLoop *loop = NULL;
static gchar *query = "Zombieland";
static gboolean watc = FALSE;
static gboolean tmdb = FALSE;

static GOptionEntry entries[] = {
        { "watc", 'w', 0, G_OPTION_ARG_NONE, &watc, "Query WATC service", NULL },
        { "tmdb", 't', 0, G_OPTION_ARG_NONE, &tmdb, "Query TMDB service (default)", NULL },
        { "query", 'q', 0, G_OPTION_ARG_STRING, &query, "query", "query term" },
        { NULL }
};

static void
response_received_cb (BtcMInfoProvider *minfo_provider, guint service,
                      GList *list, gpointer user_data)
{
        GList *tmp = NULL;

        for (tmp = list; tmp; tmp = tmp->next) {

                if (BTC_IS_TMDB_MOVIE (tmp->data)) {

                        BtcTmdbMovie *tmdb_movie = BTC_TMDB_MOVIE (tmp->data);

                        btc_tmdb_movie_print (tmdb_movie);
                        g_print ("\n");

                        g_object_unref (tmdb_movie);
                }
                else if (BTC_IS_WATC_MOVIE (tmp->data)) {

                        BtcWatcMovie *watc_movie = BTC_WATC_MOVIE (tmp->data);

                        btc_watc_movie_print (watc_movie);
                        g_print ("\n");

                        g_object_unref (watc_movie);
                }
        }

        g_list_free (list);
        g_main_loop_quit (loop);
}

int
main (int argc, char **argv)
{
        BtcMInfoProvider *minfo_provider = NULL;
        GOptionContext *context = NULL;
        GError *error = NULL;
        BtcService service = BTC_SERVICE_TMDB;

        g_type_init ();
        if (!g_thread_supported ())
                g_thread_init (NULL);

        context = g_option_context_new (" - Tests data provider behavior");
        g_option_context_add_main_entries (context, entries, NULL);
        if (!g_option_context_parse (context, &argc, &argv, &error)) {
                g_critical ("option parsing failed: %s", error->message);
                g_error_free (error);
                g_option_context_free (context);
                return -1;
        }

        if (watc)
                service = BTC_SERVICE_WATC;
        else if (tmdb)
                service = BTC_SERVICE_TMDB;

        minfo_provider = btc_minfo_provider_new ();
        g_signal_connect (minfo_provider, "response-received",
                          G_CALLBACK (response_received_cb), NULL);

        loop = g_main_loop_new (NULL, FALSE);

        btc_minfo_provider_query (minfo_provider, service,
                                  query);

        g_main_loop_run (loop);

        g_object_unref (minfo_provider);
        g_main_loop_unref (loop);
        g_option_context_free (context);

        return 0;
}
