/*
 * btc-watc-movie-service.h
 *
 * This file is part of butaca
 * Copyright (C) 2010 Simón Pena <spenap@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 */

#ifndef _BTC_WATC_MOVIE_SERVICE
#define _BTC_WATC_MOVIE_SERVICE

#include <glib-object.h>
#include "btc-watc-movie.h"

G_BEGIN_DECLS

#define BTC_TYPE_WATC_MOVIE_SERVICE btc_watc_movie_service_get_type()
#define BTC_WATC_MOVIE_SERVICE(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj), BTC_TYPE_WATC_MOVIE_SERVICE, BtcWatcMovieService))
#define BTC_WATC_MOVIE_SERVICE_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST ((klass), BTC_TYPE_WATC_MOVIE_SERVICE, BtcWatcMovieServiceClass))
#define BTC_IS_WATC_MOVIE_SERVICE(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BTC_TYPE_WATC_MOVIE_SERVICE))
#define BTC_IS_WATC_MOVIE_SERVICE_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE ((klass), BTC_TYPE_WATC_MOVIE_SERVICE))
#define BTC_WATC_MOVIE_SERVICE_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS ((obj), BTC_TYPE_WATC_MOVIE_SERVICE, BtcWatcMovieServiceClass))

typedef struct _BtcWatcMovieServicePrivate BtcWatcMovieServicePrivate;

typedef struct {
        GObject parent;

        /* <private> */
        BtcWatcMovieServicePrivate *priv;
} BtcWatcMovieService;

typedef struct {
        GObjectClass parent_class;
} BtcWatcMovieServiceClass;

GType btc_watc_movie_service_get_type (void);
BtcWatcMovieService* btc_watc_movie_service_new (DBusGConnection *connection,
                BtcWatcMovie *movie, const gchar *suffix);

G_END_DECLS

#endif /* _BTC_WATC_MOVIE_SERVICE */
