/*
 * btc-tmdb-movie.c
 *
 * This file is part of butaca
 * Copyright (C) 2010 Simón Pena <spenap@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 */

#include "btc-tmdb-movie.h"
#include "btc-tmdb-image.h"

G_DEFINE_TYPE (BtcTmdbMovie, btc_tmdb_movie, G_TYPE_OBJECT)

enum {
        PROP_0,
        PROP_SCORE,
        PROP_POPULARITY,
        PROP_TRANSLATED,
        PROP_LANGUAGE,
        PROP_NAME,
        PROP_ALT_NAME,
        PROP_TYPE,
        PROP_ID,
        PROP_IMDB_ID,
        PROP_URL,
        PROP_RATING,
        PROP_CERTIFICATION,
        PROP_OVERVIEW,
        PROP_RELEASED,
        PROP_IMAGES,
        PROP_LAST_MODIFIED,
};

#define GET_PRIVATE(o) \
  (G_TYPE_INSTANCE_GET_PRIVATE ((o), BTC_TYPE_TMDB_MOVIE, BtcTmdbMoviePrivate))

struct _BtcTmdbMoviePrivate {
        gchar *score;
        gchar *popularity;
        gchar *translated;
        gchar *language;
        gchar *name;
        gchar *alt_name;
        gchar *type;
        gchar *id;
        gchar *imdb_id;
        gchar *url;
        gchar *rating;
        gchar *certification;
        gchar *overview;
        gchar *released;
        GList *images;
        gchar *last_modified;
};

static void
btc_tmdb_movie_get_property (GObject *object, guint property_id,
                         GValue *value, GParamSpec *pspec)
{
        BtcTmdbMovie *self = BTC_TMDB_MOVIE (object);

        switch (property_id) {
        case PROP_ALT_NAME:
                g_value_set_string (value, self->priv->alt_name);
                break;
        case PROP_CERTIFICATION:
                g_value_set_string (value, self->priv->certification);
                break;
        case PROP_ID:
                g_value_set_string (value, self->priv->id);
                break;
        case PROP_IMDB_ID:
                g_value_set_string (value, self->priv->imdb_id);
                break;
        case PROP_LANGUAGE:
                g_value_set_string (value, self->priv->language);
                break;
        case PROP_LAST_MODIFIED:
                g_value_set_string (value, self->priv->last_modified);
                break;
        case PROP_NAME:
                g_value_set_string (value, self->priv->name);
                break;
        case PROP_OVERVIEW:
                g_value_set_string (value, self->priv->overview);
                break;
        case PROP_POPULARITY:
                g_value_set_string (value, self->priv->popularity);
                break;
        case PROP_RATING:
                g_value_set_string (value, self->priv->rating);
                break;
        case PROP_RELEASED:
                g_value_set_string (value, self->priv->released);
                break;
        case PROP_SCORE:
                g_value_set_string (value, self->priv->score);
                break;
        case PROP_TRANSLATED:
                g_value_set_string (value, self->priv->id);
                break;
        case PROP_TYPE:
                g_value_set_string (value, self->priv->id);
                break;
        case PROP_URL:
                g_value_set_string (value, self->priv->url);
                break;
        default:
                G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
        }
}

static void
btc_tmdb_movie_set_property (GObject *object, guint property_id,
                         const GValue *value, GParamSpec *pspec)
{
        BtcTmdbMovie *self = BTC_TMDB_MOVIE (object);

        switch (property_id) {
        case PROP_ALT_NAME:
                btc_tmdb_movie_set_alt_name (self, g_value_get_string (value));
                break;
        case PROP_CERTIFICATION:
                btc_tmdb_movie_set_certification (self,
                                g_value_get_string (value));
                break;
        case PROP_ID:
                btc_tmdb_movie_set_id (self,
                                g_value_get_string (value));
                break;
        case PROP_IMDB_ID:
                btc_tmdb_movie_set_imdb_id (self,
                                g_value_get_string (value));
                break;
        case PROP_LANGUAGE:
                btc_tmdb_movie_set_language (self,
                                g_value_get_string (value));
                break;
        case PROP_LAST_MODIFIED:
                btc_tmdb_movie_set_last_modified (self,
                                g_value_get_string (value));
                break;
        case PROP_NAME:
                btc_tmdb_movie_set_name (self,
                                g_value_get_string (value));
                break;
        case PROP_OVERVIEW:
                btc_tmdb_movie_set_overview (self,
                                g_value_get_string (value));
                break;
        case PROP_POPULARITY:
                btc_tmdb_movie_set_popularity (self,
                                g_value_get_string (value));
                break;
        case PROP_RATING:
                btc_tmdb_movie_set_rating (self,
                                g_value_get_string (value));
                break;
        case PROP_RELEASED:
                btc_tmdb_movie_set_released (self,
                                g_value_get_string (value));
                break;
        case PROP_SCORE:
                btc_tmdb_movie_set_score (self,
                                g_value_get_string (value));
                break;
        case PROP_TRANSLATED:
                btc_tmdb_movie_set_translated (self,
                                g_value_get_string (value));
                break;
        case PROP_TYPE:
                btc_tmdb_movie_set_type (self,
                                g_value_get_string (value));
                break;
        case PROP_URL:
                btc_tmdb_movie_set_url (self,
                                g_value_get_string (value));
                break;
        default:
                G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
        }
}

static void
btc_tmdb_movie_finalize (GObject *object)
{
        BtcTmdbMovie *self = BTC_TMDB_MOVIE (object);

        g_free (self->priv->alt_name);
        g_free (self->priv->certification);
        g_free (self->priv->id);
        g_free (self->priv->imdb_id);
        g_free (self->priv->language);
        g_free (self->priv->last_modified);
        g_free (self->priv->name);
        g_free (self->priv->overview);
        g_free (self->priv->popularity);
        g_free (self->priv->rating);
        g_free (self->priv->released);
        g_free (self->priv->score);
        g_free (self->priv->translated);
        g_free (self->priv->type);
        g_free (self->priv->url);

        g_list_foreach (self->priv->images, (GFunc) g_object_unref, NULL);
        g_list_free (self->priv->images);

        G_OBJECT_CLASS (btc_tmdb_movie_parent_class)->finalize (object);
}

static void
btc_tmdb_movie_class_init (BtcTmdbMovieClass *klass)
{
        GObjectClass *object_class = G_OBJECT_CLASS (klass);

        g_type_class_add_private (klass, sizeof (BtcTmdbMoviePrivate));

        object_class->get_property = btc_tmdb_movie_get_property;
        object_class->set_property = btc_tmdb_movie_set_property;
        object_class->finalize = btc_tmdb_movie_finalize;

        g_object_class_install_property
                (object_class, PROP_ALT_NAME,
                 g_param_spec_string ("alternative_name", "Alternative name",
                                 "The movie alternative name",
                                 NULL,
                                 G_PARAM_READWRITE | G_PARAM_CONSTRUCT));

        g_object_class_install_property
                (object_class, PROP_CERTIFICATION,
                 g_param_spec_string ("certification", "Movie certification",
                                 "The movie certification",
                                 NULL,
                                 G_PARAM_READWRITE | G_PARAM_CONSTRUCT));

        g_object_class_install_property
                (object_class, PROP_ID,
                 g_param_spec_string ("id", "Movie ID", "The movie ID",
                                 NULL,
                                 G_PARAM_READWRITE | G_PARAM_CONSTRUCT));

        g_object_class_install_property
                (object_class, PROP_IMDB_ID,
                 g_param_spec_string ("imdb_id", "Movie IMDB ID",
                                 "The movie IMDB ID",
                                 NULL,
                                 G_PARAM_READWRITE | G_PARAM_CONSTRUCT));

        g_object_class_install_property
                (object_class, PROP_LANGUAGE,
                 g_param_spec_string ("language", "Movie language",
                                 "The movie language",
                                 NULL,
                                 G_PARAM_READWRITE | G_PARAM_CONSTRUCT));

        g_object_class_install_property
                (object_class, PROP_LAST_MODIFIED,
                 g_param_spec_string ("last_modified_at",
                                 "Movie last modified date",
                                 "The movie last modification date",
                                 NULL,
                                 G_PARAM_READWRITE | G_PARAM_CONSTRUCT));

        g_object_class_install_property
                (object_class, PROP_NAME,
                 g_param_spec_string ("name", "Movie name", "The movie name",
                                 NULL,
                                 G_PARAM_READWRITE | G_PARAM_CONSTRUCT));

        g_object_class_install_property
                (object_class, PROP_OVERVIEW,
                 g_param_spec_string ("overview", "Movie overview", "The movie overview",
                                 NULL,
                                 G_PARAM_READWRITE | G_PARAM_CONSTRUCT));

        g_object_class_install_property
                (object_class, PROP_POPULARITY,
                 g_param_spec_string ("popularity", "Movie popularity", "The movie popularity",
                                 NULL,
                                 G_PARAM_READWRITE | G_PARAM_CONSTRUCT));

        g_object_class_install_property
                (object_class, PROP_RATING,
                 g_param_spec_string ("rating", "Movie rating", "The movie rating",
                                 NULL,
                                 G_PARAM_READWRITE | G_PARAM_CONSTRUCT));

        g_object_class_install_property
                (object_class, PROP_RELEASED,
                 g_param_spec_string ("released", "Movie released date", "The movie released date",
                                 NULL,
                                 G_PARAM_READWRITE | G_PARAM_CONSTRUCT));

        g_object_class_install_property
                (object_class, PROP_SCORE,
                 g_param_spec_string ("score", "Movie score", "The movie score",
                                 NULL,
                                 G_PARAM_READWRITE | G_PARAM_CONSTRUCT));

        g_object_class_install_property
                (object_class, PROP_TRANSLATED,
                 g_param_spec_string ("translated", "Movie translated status", "Tells if the movie is translated",
                                 NULL,
                                 G_PARAM_READWRITE | G_PARAM_CONSTRUCT));

        g_object_class_install_property
                        (object_class, PROP_TYPE,
                         g_param_spec_string ("type", "Movie type", "The movie type",
                                 NULL,
                                 G_PARAM_READWRITE | G_PARAM_CONSTRUCT));

        g_object_class_install_property
                        (object_class, PROP_URL,
                         g_param_spec_string ("url", "Movie url", "The movie url",
                                 NULL,
                                 G_PARAM_READWRITE | G_PARAM_CONSTRUCT));
}

static void
btc_tmdb_movie_init (BtcTmdbMovie *self)
{
        self->priv = GET_PRIVATE (self);

        self->priv->alt_name = NULL;
        self->priv->certification = NULL;
        self->priv->id = NULL;
        self->priv->images = NULL;
        self->priv->imdb_id = NULL;
        self->priv->language = NULL;
        self->priv->last_modified = NULL;
        self->priv->name = NULL;
        self->priv->overview = NULL;
        self->priv->popularity = NULL;
        self->priv->rating = NULL;
        self->priv->released = NULL;
        self->priv->score = NULL;
        self->priv->translated = NULL;
        self->priv->type = NULL;
        self->priv->url = NULL;
}

BtcTmdbMovie*
btc_tmdb_movie_new (void)
{
        return g_object_new (BTC_TYPE_TMDB_MOVIE, NULL);
}

gboolean
set_property (gchar **property, const gchar *value)
{
        g_free (*property);
        *property = g_strdup (value);

        return *property != NULL;
}

gboolean
btc_tmdb_movie_set_alt_name (BtcTmdbMovie *self, const gchar *alt_name)
{
        g_return_val_if_fail (BTC_TMDB_MOVIE (self), FALSE);
        return set_property (&self->priv->alt_name, alt_name);
}

const gchar*
btc_tmdb_movie_get_alt_name (BtcTmdbMovie *self)
{
        return self->priv->alt_name;
}

gboolean
btc_tmdb_movie_set_certification (BtcTmdbMovie *self,
                                  const gchar *certification)
{
        g_return_val_if_fail (BTC_TMDB_MOVIE (self), FALSE);
        return set_property (&self->priv->certification, certification);
}

const gchar*
btc_tmdb_movie_get_certification (BtcTmdbMovie *self)
{
        return self->priv->certification;
}

gboolean
btc_tmdb_movie_set_id (BtcTmdbMovie *self, const gchar *id)
{
        g_return_val_if_fail (BTC_TMDB_MOVIE (self), FALSE);
        return set_property (&self->priv->id, id);
}

const gchar*
btc_tmdb_movie_get_id (BtcTmdbMovie *self)
{
        return self->priv->id;
}

gboolean
btc_tmdb_movie_set_images (BtcTmdbMovie *self, GList *images)
{
        g_return_val_if_fail (BTC_TMDB_MOVIE (self), FALSE);
        self->priv->images = images;
        return TRUE;
}

GList*
btc_tmdb_movie_get_images (BtcTmdbMovie *self)
{
        return self->priv->images;
}

gboolean
btc_tmdb_movie_set_imdb_id (BtcTmdbMovie *self, const gchar *imdb_id)
{
        g_return_val_if_fail (BTC_TMDB_MOVIE (self), FALSE);
        return set_property (&self->priv->imdb_id, imdb_id);
}

const gchar*
btc_tmdb_movie_get_imdb_id (BtcTmdbMovie *self)
{
        return self->priv->imdb_id;
}

gboolean
btc_tmdb_movie_set_language (BtcTmdbMovie *self, const gchar *language)
{
        g_return_val_if_fail (BTC_TMDB_MOVIE (self), FALSE);
        return set_property (&self->priv->language, language);
}

const gchar*
btc_tmdb_movie_get_language (BtcTmdbMovie *self)
{
        return self->priv->language;
}

gboolean
btc_tmdb_movie_set_last_modified (BtcTmdbMovie *self,
                                  const gchar *last_modified)
{
        g_return_val_if_fail (BTC_TMDB_MOVIE (self), FALSE);
        return set_property (&self->priv->last_modified, last_modified);
}

const gchar*
btc_tmdb_movie_get_last_movified (BtcTmdbMovie *self)
{
        return self->priv->last_modified;
}

gboolean
btc_tmdb_movie_set_name (BtcTmdbMovie *self, const gchar *name)
{
        g_return_val_if_fail (BTC_TMDB_MOVIE (self), FALSE);
        return set_property (&self->priv->name, name);
}

const gchar*
btc_tmdb_movie_get_name (BtcTmdbMovie *self)
{
        return self->priv->name;
}

gboolean
btc_tmdb_movie_set_overview (BtcTmdbMovie *self, const gchar *overview)
{
        g_return_val_if_fail (BTC_TMDB_MOVIE (self), FALSE);
        return set_property (&self->priv->overview, overview);
}

const gchar*
btc_tmdb_movie_get_overview (BtcTmdbMovie *self)
{
        return self->priv->overview;
}

gboolean
btc_tmdb_movie_set_popularity (BtcTmdbMovie *self, const gchar *popularity)
{
        g_return_val_if_fail (BTC_TMDB_MOVIE (self), FALSE);
        return set_property (&self->priv->popularity, popularity);
}

const gchar*
btc_tmdb_movie_get_popularity (BtcTmdbMovie *self)
{
        return self->priv->popularity;
}

gboolean
btc_tmdb_movie_set_rating (BtcTmdbMovie *self, const gchar *rating)
{
        g_return_val_if_fail (BTC_TMDB_MOVIE (self), FALSE);
        return set_property (&self->priv->rating, rating);
}

const gchar*
btc_tmdb_movie_get_rating (BtcTmdbMovie *self)
{
        return self->priv->rating;
}

gboolean
btc_tmdb_movie_set_released (BtcTmdbMovie *self, const gchar *released)
{
        g_return_val_if_fail (BTC_TMDB_MOVIE (self), FALSE);
        return set_property (&self->priv->released, released);
}

const gchar*
btc_tmdb_movie_get_released (BtcTmdbMovie *self)
{
        return self->priv->released;
}

gboolean
btc_tmdb_movie_set_score (BtcTmdbMovie *self, const gchar *score)
{
        g_return_val_if_fail (BTC_TMDB_MOVIE (self), FALSE);
        return set_property (&self->priv->score, score);
}

const gchar*
btc_tmdb_movie_get_score (BtcTmdbMovie *self)
{
        return self->priv->score;
}

gboolean
btc_tmdb_movie_set_translated (BtcTmdbMovie *self, const gchar *translated)
{
        g_return_val_if_fail (BTC_TMDB_MOVIE (self), FALSE);
        return set_property (&self->priv->translated, translated);
}

const gchar*
btc_tmdb_movie_get_translated (BtcTmdbMovie *self)
{
        return self->priv->translated;
}

gboolean
btc_tmdb_movie_set_type (BtcTmdbMovie *self, const gchar *type)
{
        g_return_val_if_fail (BTC_TMDB_MOVIE (self), FALSE);
        return set_property (&self->priv->type, type);
}

const gchar*
btc_tmdb_movie_get_source_type (BtcTmdbMovie *self)
{
        return self->priv->type;
}

gboolean
btc_tmdb_movie_set_url (BtcTmdbMovie *self, const gchar *url)
{
        g_return_val_if_fail (BTC_TMDB_MOVIE (self), FALSE);
        return set_property (&self->priv->url, url);
}

const gchar*
btc_tmdb_movie_get_url (BtcTmdbMovie *self)
{
        return self->priv->url;
}

void
btc_tmdb_movie_print (BtcTmdbMovie *self)
{
        g_return_if_fail (BTC_IS_TMDB_MOVIE (self));

        g_print ("[Alternative name]: %s\n", self->priv->alt_name);
        g_print ("[Certification]: %s\n", self->priv->certification);
        g_print ("[Id]: %s\n", self->priv->id);
        g_print ("[Images]: %d\n", g_list_length(self->priv->images));
        g_list_foreach (self->priv->images, (GFunc) btc_tmdb_image_print, NULL);
        g_print ("[IMDB Id]: %s\n", self->priv->imdb_id);
        g_print ("[Language]: %s\n", self->priv->language);
        g_print ("[Last modified]: %s\n", self->priv->last_modified);
        g_print ("[Name]: %s\n", self->priv->name);
        g_print ("[Overview]: %s\n", self->priv->overview);
        g_print ("[Popularity]: %s\n", self->priv->popularity);
        g_print ("[Rating]: %s\n", self->priv->rating);
        g_print ("[Released]: %s\n", self->priv->released);
        g_print ("[Score]: %s\n", self->priv->score);
        g_print ("[Translated]: %s\n", self->priv->translated);
        g_print ("[Type]: %s\n", self->priv->type);
        g_print ("[URL]: %s\n", self->priv->url);
}
