/*
 * btc-tmdb-image.h
 *
 * This file is part of butaca
 * Copyright (C) 2010 Simón Pena <spenap@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 */

#ifndef _BTC_TMDB_IMAGE
#define _BTC_TMDB_IMAGE

#include <glib-object.h>

G_BEGIN_DECLS

#define BTC_TYPE_TMDB_IMAGE btc_tmdb_image_get_type()
#define BTC_TMDB_IMAGE(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj), BTC_TYPE_TMDB_IMAGE, BtcTmdbImage))
#define BTC_TMDB_IMAGE_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST ((klass), BTC_TYPE_TMDB_IMAGE, BtcTmdbImageClass))
#define BTC_IS_TMDB_IMAGE(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BTC_TYPE_TMDB_IMAGE))
#define BTC_IS_TMDB_IMAGE_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE ((klass), BTC_TYPE_TMDB_IMAGE))
#define BTC_TMDB_IMAGE_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS ((obj), BTC_TYPE_TMDB_IMAGE, BtcTmdbImageClass))

typedef struct _BtcTmdbImagePrivate BtcTmdbImagePrivate;

typedef struct {
        GObject parent;

        /* <private> */
        BtcTmdbImagePrivate *priv;
} BtcTmdbImage;

typedef struct {
        GObjectClass parent_class;
} BtcTmdbImageClass;

enum {
        TYPE_FIELD,
        URL_FIELD,
        SIZE_FIELD,
        ID_FIELD,
        LAST_FIELD
};

GType btc_tmdb_image_get_type (void);

BtcTmdbImage* btc_tmdb_image_new ();

gboolean
btc_tmdb_image_set_imagetype (BtcTmdbImage *self, const gchar *type);

const gchar*
btc_tmdb_image_get_imagetype (BtcTmdbImage *self);

gboolean
btc_tmdb_image_set_url (BtcTmdbImage *self, const gchar *url);

const gchar*
btc_tmdb_image_get_url (BtcTmdbImage *self);

gboolean
btc_tmdb_image_set_size (BtcTmdbImage *self, const gchar *size);

const gchar*
btc_tmdb_image_get_size (BtcTmdbImage *self);

gboolean
btc_tmdb_image_set_width (BtcTmdbImage *self, gint width);

gint
btc_tmdb_image_get_width (BtcTmdbImage *self);

gboolean
btc_tmdb_image_set_height (BtcTmdbImage *self, gint height);

gint
btc_tmdb_image_get_height (BtcTmdbImage *self);

gboolean
btc_tmdb_image_set_id (BtcTmdbImage *self, const gchar *id);

const gchar*
btc_tmdb_image_get_id (BtcTmdbImage *self);

void
btc_tmdb_image_print (BtcTmdbImage *self);

const gchar*
btc_tmdb_image_get_field (int field);

G_END_DECLS

#endif /* _BTC_TMDB_IMAGE */
