/*
 * btc-minfo-provider.h
 *
 * This file is part of butaca
 * Copyright (C) 2010 Simón Pena <spenap@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 */

#ifndef _BTC_MINFO_PROVIDER
#define _BTC_MINFO_PROVIDER

#include <glib-object.h>
#include <libsoup/soup.h>

G_BEGIN_DECLS

typedef enum {
        BTC_SERVICE_TMDB,
        BTC_SERVICE_WATC
} BtcService;

#define BTC_TYPE_MINFO_PROVIDER btc_minfo_provider_get_type()
#define BTC_MINFO_PROVIDER(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj), BTC_TYPE_MINFO_PROVIDER, BtcMInfoProvider))
#define BTC_MINFO_PROVIDER_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST ((klass), BTC_TYPE_MINFO_PROVIDER, BtcMInfoProviderClass))
#define BTC_IS_MINFO_PROVIDER(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BTC_TYPE_MINFO_PROVIDER))
#define BTC_IS_MINFO_PROVIDER_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE ((klass), BTC_TYPE_MINFO_PROVIDER))
#define BTC_MINFO_PROVIDER_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS ((obj), BTC_TYPE_MINFO_PROVIDER, BtcMInfoProviderClass))

typedef struct _BtcMInfoProviderPrivate BtcMInfoProviderPrivate;

typedef struct {
        GObject parent;

        /* <private> */
        BtcMInfoProviderPrivate *priv;
} BtcMInfoProvider;

typedef struct {
        GObjectClass parent_class;

        /*< private >*/
        void (*response_callback) (BtcMInfoProvider *self, GList *list);
} BtcMInfoProviderClass;

GType btc_minfo_provider_get_type (void);

BtcMInfoProvider* btc_minfo_provider_new (void);

gboolean btc_minfo_provider_query (BtcMInfoProvider *self,
                                   BtcService service,
                                   const gchar *query);

gboolean btc_minfo_provider_set_format (BtcMInfoProvider *self,
                                        const gchar *format);

G_END_DECLS

#endif /* _BTC_MINFO_PROVIDER */
