#!/bin/sh
# A script to restore /bin/busybox and delete created symlinks as defined in $INSTALLDIR/installed-symlinks
#
# Symbolic links are only removed if they are
# a) created by the installer script ("install-binary.sh")
# b) not replaced by a binary (i.e. they are still a symbolic link)
# c) pointing to a busybox binary

# By Dennis Groenen <dennis_groenen@hotmail.com>
# GPLv3 licensed

# Version 0.1 05-06-2011 (MM-DD-YYYY)

INSTALLDIR="/opt/busybox-power"
VERBOSE="0"

if test "`id -u`" -ne 0; then
  echo "Error: you're not running me as root, aborting"
  echo "  Also, DO NOT run me as a stand-alone application"
  echo "  I will be called automatically upon deinstallation"
  echo "  of busybox-power"
  exit 1
fi

#if test -n "`pgrep dpkg`" -o "`pgrep apt`"
if ! lsof /var/lib/dpkg/lock >> /dev/null
  then 
    echo "Error: you're running me as a stand-alone application"
    echo "  Do not do this, I will be called automatically upon"
    echo "  deinstallation of busybox-power"
    exit 1
fi

####### Sanity checks before continuing deinstallation
if test ! -e $INSTALLDIR/installed
  then
    echo "Error: the busybox-power installation seems to be broken"
    echo "  You either have ran this uninstaller manually,"
    echo "  or something went wrong during (de)installation"
    echo 
    echo "  Trying to restore original busybox . . ."
    if test -e $INSTALLDIR/busybox.original
      then 
        cp -f $INSTALLDIR/busybox.original /bin/busybox
        echo "  Succes! You can probably remove $INSTALLDIR now"
      else
        echo "  Original binary not found. This doesn't have to be a"
        echo "  problem. Run \"apt-get install --reinstall busybox\""
        echo "  to reinstall Nokia's stock busybox."
    fi
    echo
    echo "  Exiting now."
    exit 0
fi

if test ! -e $INSTALLDIR/installed-symlinks
  then
    echo "Error: cannot find the list of symlinks to be removed. No symlinks will be removed at all!" >> /tmp/busybox-power-error
    echo >> /tmp/busybox-power-error
fi

if test ! -e $INSTALLDIR/busybox.original
  then
    echo "Error: original binary is missing! Continuing will only remove the symlinks made during installation, /bin/busybox stays untouched." >> /tmp/busybox-power-error
    echo >> /tmp/busybox-power-error
fi

INSTBINARY_MD5=`md5sum /bin/busybox | awk '{ print $1 }'`
ORIGBINARY_MD5=`cat $INSTALLDIR/busybox.power.md5`
if test ! "$INSTBINARY_MD5" == "$ORIGBINARY_MD5"
  then
    echo "Warning: /bin/busybox has been modified since installing busybox-power (invalid md5 checksum). The original BusyBox binary at the time of installation will replace it if you continue."  >> /tmp/busybox-power-error
    echo >> /tmp/busybox-power-error
fi

INSTBINARY_MD5=`cat $INSTALLDIR/busybox.original.md5`
ORIGBINARY_MD5=`md5sum $INSTALLDIR/busybox.original | awk '{ print $1 }'`
if test ! "$INSTBINARY_MD5" == "$ORIGBINARY_MD5"
  then
    echo "Warning: the backed-up original binary has been modified since installing busybox-power (invalid md5 checksum). Do not continue unless you're 100% sure $INSTALLDIR/busybox.original isn't corrupted."  >> /tmp/busybox-power-error
    echo >> /tmp/busybox-power-error
fi

if test -e /tmp/busybox-power-error
  then
    echo "Click \"I Agree\" to ignore the above errors/warnings. Ask for help if you don't know what to do." >> /tmp/busybox-power-error
    maemo-confirm-text "Attention!" /tmp/busybox-power-error
    res=$?
    rm /tmp/busybox-power-error
    if test ! $res == 0; then exit 1; fi

    touch $INSTALLDIR/installed-symlinks
fi
####### End of sanity checklist


# Load list of installed symlinks
source $INSTALLDIR/installed-symlinks

# Walk through all possible destinations
for DESTDIR in $DESTINATIONS
  do 
    # Enable us to see all entries in $DESTIONATION as variables
    eval "APPLICATIONS=\$$DESTDIR"
    # Set destination dirrectory accordingly
    case $DESTDIR in
      DEST_BIN)
	DIR="/bin"
      ;;
      DEST_SBIN)
	DIR="/sbin"
      ;;
      DEST_USRBIN)
	DIR="/usr/bin"
      ;;
      DEST_USRSBIN)
	DIR="/usr/sbin"
      ;;
    esac

  echo "Removing symlinks in $DIR"
  # Walk through all applications from the current destination
  for APP in $APPLICATIONS
    do
      # The following code is executed for every application in the current destination
      if test -h $DIR/$APP # Check if the app is a symbolic link
	then
	  if test -n "`ls -l $DIR/$APP | grep busybox`" # Check if the symbolic link points to busybox
	    then
	      if test $VERBOSE == 1; then echo "Removing link: $DIR/$APP"; fi
	      rm $DIR/$APP
	  fi
      fi
  done
  echo
done

rm $INSTALLDIR/installed-symlinks
rm $INSTALLDIR/busybox.power.md5
rm $INSTALLDIR/busybox.original.md5
rm $INSTALLDIR/installed

cp -f $INSTALLDIR/busybox.original /bin/busybox
if test -e /bin/busybox; then rm $INSTALLDIR/busybox.original; fi
