#include <stdlib.h>
#include <hildon/hildon-program.h>
#include <hildon/hildon.h>
#include <gtk/gtk.h>
#include <libosso.h>

#include "bullshitbingo.h"
#include "dictionary.h"

#define PACKAGE_DBUS_NAME "org.maemo.bullshitbingo"

static GtkWidget *game_board_table = NULL;
static GPtrArray *words_to_remove = NULL;
static GtkWidget *dictionary_window = NULL;
static GtkWidget *dictionary_vbox = NULL;
static HildonWindow *program_window = NULL;
static int selected_buttons = 0;
static const gint WIN_MAPS[12] = {32505856, 1015808, 31744, 992, 31, 17318416, 8659208, 4329604, 2164802, 1082401, 17043521, 1118480};

void delete_button_clicked(GtkWidget *window){
  gchar *word_to_remove;

  if(words_to_remove->len > 0){
    gint i = 0;
    for (i; i < words_to_remove->len; ++i){
      word_to_remove = (gchar*)gtk_button_get_label(GTK_BUTTON(g_ptr_array_index(words_to_remove, i)));
      if(dict_exists(word_to_remove)){
        dict_remove(word_to_remove);
      }
    }
    show_info(g_strdup_printf(WORDS_REMOVED, words_to_remove->len));
    dict_save_to_file();
    reload_dictionary_table(window);
  }else{
    show_info(NO_WORDS_SELECTED);
  }
}

void add_word_button_clicked(GtkWidget *entry){
  const gchar *new_word = g_strdup(g_strstrip(gtk_entry_get_text(GTK_ENTRY(entry))));
  if(strlen(new_word) == 0){
    show_info(NOTHING_TYPED);
    return;
  }
  if(dict_exists(new_word)){
    show_info(g_strdup_printf(WORD_ALREADY_EXISTS, new_word));
  }else{
    dict_add(new_word);
    show_info(g_strdup_printf(WORD_ADDED, new_word));
    dict_save_to_file();
    reload_dictionary_table();
  }
  gtk_widget_grab_focus(entry);
}

void word_to_delete_toggled(GtkWidget *button) {
  if(gtk_toggle_button_get_active(button))
    g_ptr_array_add(words_to_remove, (gpointer)button);
  else
    g_ptr_array_remove(words_to_remove, (gpointer)button);
}

void open_dictionary_button_clicked(){
  dictionary_window = hildon_stackable_window_new();
  create_dictionary_window(dictionary_window);
}

void close_button_clicked() {
  gtk_main_quit();
}

void reset_button_clicked() {
  reset_game_board();
}

void word_button_toggled(GtkWidget *widget, ButtonPosition *pos){
  gint flat_pos = ((gint)pos->y * BOARD_SIZE) + (gint)pos->x;
  if ((selected_buttons & (1 << flat_pos)) == (1 << flat_pos))
    selected_buttons -= 1 << flat_pos;
  else
    selected_buttons += 1 << flat_pos;

  int i;
  for (i = 0; i < 12; ++i)
    if ((selected_buttons & WIN_MAPS[i]) == WIN_MAPS[i]){
      show_note(g_strdup_printf("YEAH! Now stand up and shout BULLSHIT!"));
      return;
    }
}

void reset_game_board(){
  gtk_widget_destroy(game_board_table);
  create_board();
  selected_buttons = 0;
  gtk_widget_show_all(GTK_WIDGET(program_window));
}

static void create_board() {
  gint i, j = 0;
  gchar *word;
  GtkWidget *tbutton;
  GtkWidget *label;

  game_board_table = gtk_table_new(BOARD_SIZE, BOARD_SIZE, TRUE);
  gtk_container_add(GTK_CONTAINER(program_window), game_board_table);

  dict_mix();

  for(j; j < BOARD_SIZE; ++j){
    for(i = 0; i < BOARD_SIZE; ++i){
      tbutton = gtk_toggle_button_new();
      label = gtk_label_new(NULL);

      gtk_widget_set_size_request(label, (gint)(BUTTON_WIDTH-30), BUTTON_HEIGHT);

      gtk_label_set_line_wrap(label, TRUE);
      gtk_label_set_line_wrap_mode(label, PANGO_WRAP_WORD_CHAR);
      gtk_label_set_justify (GTK_WIDGET(label), GTK_JUSTIFY_CENTER);

      word = dict_size() > 0 ? dict_get_mixed(((j*BOARD_SIZE)+i)%dict_size()) : "";
      word = g_strdup_printf(WORD_FORMAT, word);
      gtk_label_set_markup (GTK_LABEL (label), word);

      gtk_container_add(tbutton, label);
      gtk_widget_set_size_request(tbutton, BUTTON_WIDTH, BUTTON_HEIGHT);
      gtk_table_attach(game_board_table, tbutton, i, i+1, j, j+1, GTK_FILL, GTK_EXPAND, 0, 0);

      ButtonPosition *pos = g_slice_new (ButtonPosition);
      pos->x = j;
      pos->y = i;
      g_signal_connect(G_OBJECT(tbutton), "toggled", G_CALLBACK(word_button_toggled), (gpointer) pos);
    }
  }
}

static GtkWidget *create_dictionary_list(){
  GtkWidget *word_list_table = gtk_table_new (10, 1, FALSE);
  GtkWidget *button;
  int i;

  gtk_widget_show(word_list_table);

  dict_order();

  for (i = 0; i < dict_size(); i++){
    button = gtk_toggle_button_new_with_label(dict_get(i));
    gtk_table_attach_defaults (GTK_TABLE (word_list_table), button, 0, 1, i, i+1);
    g_signal_connect(G_OBJECT(button), "toggled", G_CALLBACK(word_to_delete_toggled), button);
  }

  return word_list_table;
}

void reload_dictionary_table(){
  gtk_widget_destroy(dictionary_vbox);
  create_dictionary_window(dictionary_window);
  gtk_widget_show_all(GTK_WIDGET(dictionary_window));
}

void create_dictionary_window(GtkWidget *window){
  GtkWidget *pannable_area = hildon_pannable_area_new();
  GtkWidget *dictionary_list = create_dictionary_list();
  GtkWidget *hseparator = gtk_hseparator_new();
  GtkWidget *hbox = gtk_hbox_new(TRUE, 0);
  GtkWidget *entry = gtk_entry_new();
  GtkWidget *button =  gtk_button_new_with_label(ADD_BUTTON_LABEL);

  GtkWidget *toolbar = hildon_edit_toolbar_new_with_text(DICTIONARY_WINDOW_NAME, DELETE_BUTTON_LABEL);

  gtk_entry_set_max_length(entry, MAX_WORD_SIZE);

  dictionary_vbox = gtk_vbox_new(TRUE, 0);
  words_to_remove = g_ptr_array_new();

  hildon_window_set_edit_toolbar(HILDON_WINDOW (window), HILDON_EDIT_TOOLBAR (toolbar));
  hildon_pannable_area_add_with_viewport (HILDON_PANNABLE_AREA (pannable_area), dictionary_list);
  gtk_box_set_homogeneous(dictionary_vbox, FALSE);
  gtk_box_pack_start (GTK_BOX (dictionary_vbox), pannable_area, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (dictionary_vbox), hseparator, FALSE, FALSE, 0);

  gtk_box_set_homogeneous(hbox, FALSE);
  gtk_box_pack_start (GTK_BOX (hbox), entry, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (hbox), button, FALSE, FALSE, 0);
  gtk_box_pack_end (GTK_BOX (dictionary_vbox), hbox, FALSE, FALSE, 10);
  gtk_container_add (GTK_CONTAINER (window), dictionary_vbox);

  g_signal_connect (toolbar, "button-clicked", G_CALLBACK (delete_button_clicked), window);
  g_signal_connect_swapped (toolbar, "arrow-clicked", G_CALLBACK (gtk_widget_destroy), window);
  g_signal_connect_swapped (button, "clicked", G_CALLBACK (add_word_button_clicked), entry);

  gtk_widget_show_all(window);
  gtk_window_fullscreen(window);
}

static void create_menu() {
  GtkWidget *main_menu;
  GtkWidget *button;

  main_menu = HILDON_APP_MENU (hildon_app_menu_new ());

  button = gtk_button_new_with_label (RESET_BUTTON_LABEL);
  g_signal_connect(G_OBJECT(button), "clicked", GTK_SIGNAL_FUNC(reset_button_clicked), NULL);
  hildon_app_menu_append (main_menu, GTK_BUTTON (button));

  button = gtk_button_new_with_label (DICTIONARY_BUTTON_LABEL);
  g_signal_connect(G_OBJECT(button), "clicked", GTK_SIGNAL_FUNC(open_dictionary_button_clicked), NULL);
  hildon_app_menu_append (main_menu, GTK_BUTTON (button));

  gtk_widget_show_all(GTK_WIDGET(main_menu));

  hildon_window_set_app_menu (HILDON_WINDOW (program_window), main_menu);
}

void show_info(gchar *text) {
  GtkWidget *banner = hildon_banner_show_information(program_window, NULL, text);

  hildon_banner_set_timeout (HILDON_BANNER (banner), 1600);
}

void show_note(gchar *text) {
  //GtkWidget *banner = hildon_note_new_confirmation(parent, text);
  GtkWidget *banner = hildon_note_new_confirmation_add_buttons(program_window, text,
                                                               "Reset", GTK_RESPONSE_OK,
                                                               NULL);
  gint response = gtk_dialog_run (banner);
  if(response == GTK_RESPONSE_OK){
    reset_game_board();
  }
  gtk_object_destroy (GTK_OBJECT (banner));
}


int main(int argc, char **argv) {

  HildonProgram *program;
  osso_context_t *osso_context;
  osso_return_t result;
  AppData *appdata;

  hildon_gtk_init(&argc, &argv);

  /* Initialize maemo application */
  osso_context = osso_initialize(PACKAGE_DBUS_NAME, PACKAGE_VERSION, TRUE, NULL);

  /* Check that initialization was ok */
  if (osso_context == NULL) {
    return OSSO_ERROR;
  }

  program = HILDON_PROGRAM(hildon_program_get_instance());
  g_set_application_name(APPLICATION_NAME);
  program_window = hildon_stackable_window_new();
  hildon_program_add_window(program, program_window);

  /* Create AppData */
  appdata = g_new0(AppData, 1);
  appdata->program = program;
  appdata->window = program_window;
  appdata->osso_context = osso_context;

  dict_prepare();

  create_menu();
  //create_board();
  reset_game_board();

  g_signal_connect(G_OBJECT(program_window), "delete_event", G_CALLBACK(close_button_clicked), NULL);

  gtk_widget_show_all(GTK_WIDGET(program_window));
  gtk_main();

  /* Deinitialize OSSO */
  osso_deinitialize(osso_context);

  return 0;
}
