/*Copyright (C) 1995-1998, 2000-2002, 2004-2006 Free Software Foundation, Inc.
  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published
  by the Free Software Foundation; either version 2, or (at your option)
  any later version.
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.
  You should have received a copy of the GNU General Public
  License along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301,
  USA.  */

#ifndef GAMEFIELD_H
#define GAMEFIELD_H

#include <QWidget>
#include <QVector>

#include "shot.h"
#include "enemy.h"
#include "ship.h"
#include "medkit.h"
#include "charger.h"
#include "asteroid.h"
#include "bomb.h"

/* our widget where all game is drawing */
class GameField : public QWidget
{
	Q_OBJECT

public:
    GameField(QWidget *parent = 0); // constructor
    QRect pos; // ship position

signals:
    void hit(); // hit a bug
    void fail(); // miss a bug
    void counters(); // null counters
    void firstaid(); // +1 life
public slots:
    void restart(); // restart game
    void epicFail(); // end game
    void addLevel();
protected:
    void paintEvent(QPaintEvent* event); // drawing of widget
    void keyPressEvent(QKeyEvent* event); // handling keyboard
    void timerEvent(QTimerEvent* event); // handling timer
    void mouseMoveEvent(QMouseEvent* event); // handling mouse moving
    void mousePressEvent(QMouseEvent* event); // handling mouse pressing
    void resizeEvent(QResizeEvent* event); // handling resizing

private:
    /* objects: bug, shot, enemy, etc */
    Ship* ship;
    Bomb* bomb;
    Shot* shot;
    Enemy* enemy;
    MedKit* medkit;
    Charger* charger;
    Asteroid* asteroid;
    /* vectors for storing objects */
    QVector<Shot*>* shots;
    QVector<Charger*>* chargers;
    QVector<Enemy*>* enemys;
    QVector<MedKit*>* medkits;
    QVector<Asteroid*>* asteroids;
    QVector<Bomb*>* bombs;
    QList<QString> bg_list;
    QList<QString>::iterator bg_it;

    QPixmap background; // background picture

    int kills;
    int bugtime;
    int bonustime;
    bool gameOver; // flag
    bool level;
    int levelnum;
    int id;
    int id2;
    int id3;
    int id4;
    int patrons;
    int score;

};


#endif
