#include <QPainter>
#include <QMainWindow>
#include <QKeyEvent>
#include <QDebug>
#include <QRect>
#include <QImage>
#include <QVector>
#include <QDebug>
#include "gamefield.h"
#include <QFile>
#include <QTextStream>

/* class constructor */
GameField::GameField(QWidget *parent) : QWidget(parent)
{        
    /* painting background */
    setPalette(QPalette(QColor(0, 0, 0)));
    setAutoFillBackground(true);


    background.load("images/sp1.jpeg");// load background image

    bg_list.append("images/sp2.jpeg");
    bg_list.append("images/sp3.jpeg");
    bg_list.append("images/sp4.jpeg");
    bg_list.append("images/sp5.jpeg");
    bg_list.append("images/sp6.jpeg");
    bg_list.append("images/sp1.jpeg");

    bg_it = bg_list.begin();

    grabKeyboard(); // start handling keyboard events
    setMouseTracking(true); // start handling mouse events
	
    ship = new Ship(height()); // create ship object

    /* create vectors where objects will be stored */
    shots = new QVector<Shot*>();
    chargers = new QVector<Charger*>();
    enemys = new QVector<Enemy*>(); // bugs
    medkits = new QVector<MedKit*>();
    asteroids = new QVector<Asteroid*>();
    bombs = new QVector<Bomb*>();
    bugtime = 1000;
    bonustime = 8000;
    id = startTimer(50); // start timer which update widget
    id2 = startTimer(bugtime);
    id3 = startTimer(bonustime);
    kills = 0;
    patrons = 5;
    gameOver = false;
    levelnum = 1;
    level = false;

    /*loading file,whitch contains best score */
    QFile file("score.txt");
    if (!file.open (QIODevice::ReadOnly | QIODevice::Text)){
        score=0;
        qDebug()<<"FAIL";
    }
    else {
    QTextStream stream ( &file );
    QString line;
         line = stream.readLine();
         score=line.toInt();
         qDebug()<<score;

    file.close();
    }
}

/* function of painting our widget */
void GameField::paintEvent(QPaintEvent* event)
{
    QPainter painter(this); // create drawing object
    painter.drawPixmap(this->rect(), background); // draw background

    ship->update(&painter); // draw ship

    /* game over actions */
    if (gameOver == true) {
        /* draw game over message */
        painter.setPen(Qt::red);
        painter.setFont(QFont("Courier", 38, QFont::Bold));
        QString line = QString::number(kills);
        painter.drawText(rect(), Qt::AlignCenter, tr("Игра окончена")+"\n"+ tr("Ваш лучший счет:") + line);

        killTimer(id); // stop timer
        return;
    }

    /* new level actions */
    if (level == true) {
        painter.setPen(Qt::red);
        painter.setFont(QFont("Courier", 48, QFont::Bold));
        killTimer(id);
        killTimer(id2);
        killTimer(id3);
        id4 = startTimer(2000);

        bg_it++;
        if (bg_it == bg_list.end())
            bg_it = bg_list.begin();
        background.load(*bg_it);
        painter.drawPixmap(this->rect(), background); // draw background
        painter.drawText(rect(), Qt::AlignCenter, tr("Уровень:") + QString::number(levelnum));
        bugtime /= 1.2;
        bonustime /= 1.1;
        return;
}

    /* draw shot objects */
    for (int i = 0; i < shots->count(); i++)
        shots->at(i)->update(&painter);

    /* delete shot object if it goes out of screen */
    for (int i = 0; i < shots->count(); i++)
        if (shots->at(i)->isOut()) {
            delete shots->at(i);
            shots->remove(i);
        }

    /* draw bugs */
    for (int y = 0; y < enemys->count(); y++)
        enemys->at(y)->update(&painter);

    /* if bug object goes out of screen, delete it and reduce lifes -1 */
    for (int y = 0; y < enemys->count(); y++)
        if (enemys->at(y)->isOut(height())) {
            delete enemys->at(y);
            enemys->remove(y);
            emit fail(); // make signal to reduce life
	}

    /* draw medkit */
    for (int y = 0; y < medkits->count(); y++) {
        medkits->at(y)->update(&painter);
    }

    /* delete medkit */
    for (int y = 0; y < medkits->count(); y++) {
        if (medkits->at(y)->isOut(height())) {
            delete medkits->at(y);
            medkits->remove(y);
        }
    }

    /* draw bomb */
    for (int y = 0; y < bombs->count(); y++) {
        bombs->at(y)->update(&painter);
    }

    /* delete bomb */
    for (int y = 0; y < bombs->count(); y++) {
        if (bombs->at(y)->isOut(height())) {
            delete bombs->at(y);
            bombs->remove(y);
        }
    }

    /* draw asteroids */
    for (int y = 0; y < asteroids->count(); y++) {
        asteroids->at(y)->update(&painter);
    }

    /* delete asteroids */
    for (int y = 0; y < asteroids->count(); y++) {
        if (asteroids->at(y)->isOut(height())) {
            delete asteroids->at(y);
            asteroids->remove(y);
        }
    }

    /* draw bullet bonus */
    for (int y = 0; y < chargers->count(); y++) {
        chargers->at(y)->update(&painter);
    }

    /* delete bullet bonus */
    for (int y = 0; y < chargers->count(); y++) {
        if (chargers->at(y)->isOut(height())){
            delete chargers->at(y);
            chargers->remove(y);
        }
    }

    QRect temp = ship->getRect(); // get current coordinates of ship

    /* if ship intersects  medkit - +1 life */
    for (int y = 0; y < medkits->count(); y++) {
        QRect temp1 = medkits->at(y)->getRect();
        if (temp.intersects(temp1)) { // determine intersection
            delete medkits->at(y);
            medkits->remove(y);
            emit firstaid();
        }
    }

     /* if ship intersects  bomb - all bugs will die */
    for (int i = 0; i < bombs->count(); i++) {
        QRect temp1 = bombs->at(i)->getRect();
        if (temp.intersects(temp1)) { // determine intersection
            bombs->remove(i);
            for (int y = 0; y < enemys->count(); y++) {
                delete enemys->at(y);
                enemys->remove(y);
                kills++;
                emit hit();
            }
            enemys->clear();
        }
    }


    /* if ship intersects bullet bonus, increase number of bullets */
    for (int y = 0; y < chargers->count(); y++) {
        QRect temp1 = chargers->at(y)->getRect();
        if (temp.intersects(temp1)) {
            chargers->remove(y);
            patrons += 1;
        }
    }

    /* if shot intersects a bug, kill it */
    for (int i = 0; i < shots->count(); i++)
        for (int y = 0; y < enemys->count(); y++) {
            QRect temp1 = shots->at(i)->getRect();
            QRect temp2 = enemys->at(y)->getRect();
            if (temp1.intersects(temp2)) {
                delete shots->at(i); // delete shot object
                shots->remove(i);
                delete enemys->at(y); // delete enemy object
                enemys->remove(y);
                kills++;
                emit hit(); // +1 to score
            }
        }

    /* if ship intersects a bug, reduce life -1 */
    for (int y = 0; y < enemys->count(); y++) {
        QRect temp2 = enemys->at(y)->getRect();
        if (temp.intersects(temp2)) {
            delete enemys->at(y);
            enemys->remove(y);
            emit fail();
        }
    }

    /* if shot intersects a asteroids*/
    for (int i = 0; i < shots->count(); i++)
        for (int y = 0; y < asteroids->count(); y++) {
            QRect temp1 = shots->at(i)->getRect();
            QRect temp2 = asteroids->at(y)->getRect();
            if (temp1.intersects(temp2)) {
                delete shots->at(i); // delete shot object
                shots->remove(i);
               }
        }

    /* if ship intersects a asteroids, reduce life -1 */
    for (int y = 0; y < asteroids->count(); y++) {
        QRect temp2 = asteroids->at(y)->getRect();
        if (temp.intersects(temp2)) {
            delete asteroids->at(y);
            asteroids->remove(y);
            emit fail();
        }
    }
}


/* handling keyboard events */
void GameField::keyPressEvent(QKeyEvent* event)
{
    QRect temp = ship->getRect();

    /* right arrow - move ship right */
    if (event->key() == Qt::Key_Right) {
        if (temp.x() + 50 + 30 > width())
            temp.setRect(width()-50,temp.y(), 50, 50);
        else
            temp.setRect(temp.x() + 30,temp.y(), 50, 50);

        ship->setPos(temp);
    }
    /* left arrow - move ship left */
    else if (event->key() == Qt::Key_Left) {
        if (temp.x() - 30 < 0)
            temp.setRect(0, temp.y(), 50, 50);
        else
            temp.setRect(temp.x() - 30,temp.y(), 50, 50);
        ship->setPos(temp);
    }
    /* spacebar - shoot */
    else if (event->key() == Qt::Key_Space) {
        shot = new Shot(temp);
        shots->append(shot);
    }
}


/* actions on timer */
void GameField::timerEvent(QTimerEvent* event)
{
    int timerId = event->timerId();

    if (id == timerId)
        update();

    if (id2 == timerId)
    {
        enemy = new Enemy(width());
        enemys->append(enemy);


    }
    if (id3 == timerId)
    {
        int x=qrand()%4;
        switch (x)
        {
        case 0:
        medkit= new MedKit(width());
        medkits->append(medkit);

        break;

        case 1:

        charger= new Charger(width());
        chargers->append(charger);

        break;

        case 2:

        asteroid= new Asteroid(width());
        asteroids->append(asteroid);

        break;

        case 3:

        bomb= new Bomb(width());
        bombs->append(bomb);

        break;


        default:
        break;
        }

    }
    if (id4 == timerId)
    {
        level = false;
        killTimer(id4);
        id = startTimer(50);
        id2 = startTimer(bugtime);
        id3 = startTimer(bonustime);

    }

}


/* function deletes all objects and stops timer */
void GameField::restart()
{
    killTimer(id); // stop timer
    killTimer(id2);
    killTimer(id3);

    bugtime = 1000;
    bonustime = 8000;
    kills = 0;
    patrons = 5;
    levelnum = 1;

    emit counters(); // call signal to null counters
    /* delete all shot objects */
    for(int i = 0; i < shots->count(); i++) {
        delete shots->at(i);
        shots->remove(i);
        shots->clear();
    }

    /* delete all bug objects */
    for (int y = 0; y < enemys->count(); y++) {
        delete enemys->at(y);
        enemys->remove(y);
        enemys->clear();
    }
    id = startTimer(50); // start timer which update widget
    id2 = startTimer(bugtime);
    id3 = startTimer(bonustime);

    gameOver = false;
    level = false;
}


/* function - ending game */
void GameField::epicFail()
{
    /* delete all shot objects */
    for(int i = 0; i < shots->count(); i++) {
        shots->remove(i);
    }

    /* delete all bug objects */
    for (int y = 0; y < enemys->count(); y++) {
        enemys->remove(y);
    }
    gameOver = true; // set flag

    if (kills>score){
    QFile file("score.txt");
    file.open (QIODevice::WriteOnly | QIODevice::Text);
    QTextStream out(&file);
    out << kills;
    file.close();
    }
    else
        kills=score;


    update(); // paint widget
}

void GameField::addLevel()
{
    if (levelnum <= 10){
    /* delete all shot objects */
    for (int i = 0; i < shots->count(); i++) {
        delete shots->at(i);
        shots->remove(i);
    }
    shots->clear();

    /* delete all bug objects */
    for (int y = 0; y < enemys->count(); y++) {
        delete enemys->at(y);
        enemys->remove(y);
    }
    enemys->clear();

    level = true; // set flag
    levelnum++;
    update(); // paint widget
}
}

/* handle mouse moving, move ship with mouse */
void GameField::mouseMoveEvent(QMouseEvent* event)
{
    QRect temp = ship->getRect();   
    temp.setRect(event->x() - 25, temp.y(), 50, 50);
    if (temp.right() > width())
        return;
    if (temp.left() < 0)
        return;
    ship->setPos(temp);
}

/* handle mouse pressing buttons - shoot */
void GameField::mousePressEvent(QMouseEvent* event)
{
    /* create shot objects, not more than limitation */
    if (shots->count() < patrons) {
        shot = new Shot(ship->getRect());
        shots->append(shot);
    }
}

/* handle resize event of window - change position of ship */
void GameField::resizeEvent(QResizeEvent* event)
{
    QRect temp = ship->getRect();
    temp.setRect(temp.x(), this->height()-50, 50, 50);
    ship->setPos(temp);
}
