#include <QtGui>
#include <QMainWindow>

#ifndef BOOTSCREEN_H
#define BOOTSCREEN_H


struct bootConfFile {
    QFileInfo name;
    QFileInfo confFile;
};

class BootScreen : public QMainWindow
{
     Q_OBJECT

public:
    BootScreen(QWidget *parent = 0);
    virtual ~BootScreen();

protected:
    void closeEvent(QCloseEvent *event);

private:
    void checkSettings();
    void createList();
    void writeSettings();
    void restoreSettings();
    void createFile(QString filename, int index);
    bool random;
    QString hildonWelcome;
    QString settingsPath;
    QString videosDir;
    QString settingsDir;
    QFile settingsFile;
    QActionGroup *filterGroup;
    QAction *mRandom;
    QAction *mMultiple;
    QHash <QString, QString> mediaFiles;
    QListWidget *list;
    QPushButton *up;
    QPushButton *down;
    QPushButton *save;

private slots:
    void addVideo();
    void removeVideos();
    void showAbout();
    void disableSelection(bool state);
    void selectMultiple(bool state);
    void moveUp();
    void moveDown();
    void saveConfs();
    void setPendingChanges(QListWidgetItem* item);
};

#endif // BOOTSCREEN_H
