# show onscreen boot menu
# modify default_root,root_dev,root_fstype,root_fsoptions variables

#  Copyright (C) 2006,2007,2008 Frantisek Dufka
#  Copyright (C) 2010,2011,2012 Pali Rohar <pali.rohar@gmail.com>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

# HW keys scancodes
# up 103 down 108 left 105 right 106 select 28
# esc 1 menu 62 home 63 fullscreen 64 plus 65 minus 66
# shift 42 ctrl 29 alt 100 back 14

# do not run bootmenu when device is not un USER state
if [ "`getbootstate`" != "USER" ]; then
	return
fi

# create needed devices to boot
if [ ! -c /dev/null ]; then
	rm -f /dev/null
	mknod /dev/null c 1 3
fi
if [ ! -c /dev/console ]; then
	rm -f /dev/console
	mknod /dev/console c 5 1
fi
if [ ! -c /dev/fb0 ]; then
	rm -f /dev/fb0
	mknod /dev/fb0 c 29 0
fi
if [ ! -c /dev/mtd1 ]; then
	rm -f /dev/mtd1
	mknod /dev/mtd1 c 90 2
fi

# program for writing text on screen
T2S="${initfs_prefix}/usr/bin/text2screen"

echo "Loading BOOT MENU..."
$T2S -x 200 -y 0 -w 400 -h 55 -c
$T2S -s 2 -H center -y 20 -T 0 -t "Loading BOOT MENU..."

# Nokia Product:
#  SU-18 - Nokia 770
#  RX-34 - Nokia N800
#  RX-44 - Nokia N810
#  RX-48 - Nokia N810 WiMax
#  RX-51 - Nokia N900
PRODUCT=`awk '/product/ { print $2 }' /proc/component_version`

# keyboard event device
case $PRODUCT in
	SU-18|RX-51) EVNAME=event1;;
	RX-34) EVNAME=event2;;
	RX-4[48]) EVNAME=event0;;
esac

# power key event device
case $PRODUCT in
	RX-51) EVPOWER=event0;;
	# TODO: Add power key event file for other products
esac

# display brightness device
case $PRODUCT in
	RX-51) BRIGHTNESS=/sys/class/backlight/acx565akm/brightness;;
	# TODO: Add brightness devices for other products
esac

# set display brightness
[ "$BRIGHTNESS" != "" ] && echo 100 > $BRIGHTNESS

# load modules on RX-51
if [ "$PRODUCT" = "RX-51" ]; then

	(
	# Led
	insmod $MODULE_PATH/led-class.ko
	insmod $MODULE_PATH/leds-lp5523.ko

	# RTC
	insmod $MODULE_PATH/rtc-core.ko
	insmod $MODULE_PATH/rtc-twl4030.ko
	sleep 2
	for p in /sys/class/rtc/rtc*/; do
		n=`basename $p | sed "s/.*://"`
		rm -f /dev/$n
		mknod /dev/$n c `cat $p/dev | sed "s/:/ /g"`
	done

	# Watchdogs
	insmod $MODULE_PATH/omap_wdt.ko
	insmod $MODULE_PATH/twl4030_wdt.ko
	sleep 2
	for p in /sys/bus/platform/devices/*_wdt/misc:*; do
		n=`basename $p | sed "s/.*://"`
		rm -f /dev/$n
		mknod /dev/$n c `cat $p/dev | sed "s/:/ /g"`
	done
	/usr/sbin/watchdogs
	) &

	# eMMC and SD
	cd /dev; /sbin/MAKEDEV input; cd /
	insmod $MODULE_PATH/mmc_core.ko
	insmod $MODULE_PATH/mmc_block.ko
	insmod $MODULE_PATH/omap_hsmmc.ko
	rm -f /dev/mmcblk*
	sleep 2
	for p in /sys/block/mmcblk*/ /sys/block/mmcblk*/mmcblk*p*/; do
		n=`basename $p`
		rm -f /dev/$n
		mknod /dev/$n b `cat $p/dev | sed "s/:/ /g"`
	done

fi

# wait 1 second for keyup event
GETKEY="${initfs_prefix}/usr/bin/evkey -u -t 1000 /dev/input/${EVNAME}"

# wait until power key will be pressed
GETPOWERKEY="${initfs_prefix}/usr/bin/evkey -u -t -1 /dev/input/${EVPOWER}"

# keys
KEY_ENTER=28
KEY_SELECT=96
KEY_UP=103
KEY_DOWN=108
KEY_MENU=62
KEY_HOME=63
KEY_ESC=1

# additional RX-51 Keys
KEY_SHIFT=42
KEY_CTRL=29
KEY_ALT=100
KEY_BACK=14

# IP address for USB networking (same as in /etc/network/interfaces)
USB_IP=192.168.2.15

# default menu timeout
MENU_TIMEOUT=30

# figure out mmc slot device names, http://bugs.maemo.org/show_bug.cgi?id=2747
INT_CARD=""
EXT_CARD=""

case $PRODUCT in
	SU-18)
		[ -d /sys/block/mmcblk0 ] && EXT_CARD="mmcblk0"
		;;
	RX-*)
		for i in mmcblk0 mmcblk1; do
			if [ -d /sys/block/$i ]; then
				if [ -f /sys/block/$i/device/../slot_name ]; then
					# 2.6.21/OS2008
					slot_name=/sys/block/$i/device/../slot_name
				else
					# 2.6.18/OS2007
					slot_name=$(expr substr $(basename $(readlink /sys/block/$i/device) ) 1 4)
					slot_name=/sys/block/$i/device/../mmc_host:${slot_name}/slot_name
				fi
				case `cat $slot_name` in
					internal) INT_CARD=$i;;
					external) EXT_CARD=$i;;
				esac
			fi
		done
		;;
esac

# define default menu items (if config file was not found)
MENU_MIN=1

MENU_1_NAME="Internal Nand"
MENU_1_ID="nand"

MENU_2_NAME="Internal eMMC memory, partition 2, ext2"
MENU_2_ID="immc2"
MENU_2_DEVICE="${INT_CARD}p2"
MENU_2_MODULES="mbcache ext2"
MENU_2_FSTYPE="ext2"
MENU_2_FSOPTIONS="noatime"
[ -d "/sys/block/${INT_CARD}/${MENU_2_DEVICE}" ] || MENU_2_NAME="(${MENU_2_NAME}) N/A"

MENU_3_NAME="External SD card, partition 2, ext2"
MENU_3_ID="mmc2"
MENU_3_DEVICE="${EXT_CARD}p2"
MENU_3_MODULES="mbcache ext2"
MENU_3_FSTYPE="ext2"
MENU_3_FSOPTIONS="noatime"
[ -d "/sys/block/${EXT_CARD}/${MENU_3_DEVICE}" ] || MENU_3_NAME="(${MENU_3_NAME}) N/A"

MENU_4_NAME="USB hard drive"
MENU_4_ID="usb"

MENU_5_NAME="Power off (when not on charger)"
MENU_5_ID="off"

# change max if you add/remove items
MENU_MAX=5

# load menu customization
[ -f ${initfs_prefix}/etc/bootmenu.conf ] && . ${initfs_prefix}/etc/bootmenu.conf

MENU_IDX=$MENU_MIN

load_modules()
{
	for mod in $*; do
		if [ -f $MODULE_PATH/${mod}.ko ]; then
			insmod $MODULE_PATH/${mod}.ko
		fi
	done
}

transfer_to_linuxrc()
{
	root_dev="$1"

	[ -z "$root_dev" ] && return 1

	if [ "$root_mounted" = "1" ]; then
		${T2S} -s 2 -H center -y 40 -T 0 -t "Starting $2 ..."
		exec ${initfs_prefix}/$2
		${T2S} -s 2 -H center -y 60 -T 0 -t "Failed to start linuxrc"
		exec /sbin/init
	fi

	mkdir -p /mnt/new_root

	if [ -z $root_fstype ]; then
		if [ -z $root_fsoptions ]; then
			time mount /dev/$root_dev /mnt/new_root
		else
			time mount -o $root_fsoptions /dev/$root_dev /mnt/new_root
		fi
	else
		if [ -z $root_fsoptions ]; then
			time mount -t $root_fstype /dev/$root_dev /mnt/new_root
		else
			time mount -t $root_fstype -o $root_fsoptions /dev/$root_dev /mnt/new_root
		fi
	fi

	grep -q new_root /proc/mounts
	${T2S} -s 2 -H center -y 40 -T 0 -t "Starting $2 ..."
	cp /mnt/new_root/$2 /tmp/linuxrc
	chmod a+rx /tmp/linuxrc
	exec /tmp/linuxrc
	${T2S} -s 2 -H center -y 60 -T 0 -t "Failed to start linuxrc"
	exec /sbin/init
}

set_usb_mode()
{
	case $PRODUCT in
		SU-18) echo $1 > /sys/devices/platform/tahvo-usb/otg_mode;;
		RX-*) echo $1 > /sys/devices/platform/musb_hdrc/mode;;
	esac
}

usb_mass_storage()
{
	${T2S} -c
	DEVICES=
	[ "$INT_CARD" != "" ] && DEVICES=$DEVICES,/dev/$INT_CARD
	[ "$EXT_CARD" != "" ] && DEVICES=$DEVICES,/dev/$EXT_CARD

	for MODULE in g_nokia g_ether phonet; do
		if lsmod | grep -q $MODULE; then rmmod $MODULE; fi
	done

	insmod $MODULE_PATH/g_file_storage.ko file=$DEVICES stall=0 removable=1
	y=20
	${T2S} -s 2 -H center -y $y -T 0 -t "USB mass storage mode started"

	y=$((y+40)); ${T2S} -s 2 -H center -y $y -T 0 -t "Press ESC/SHIFT key to disconnect and go back"

	while true; do
		key=`evkey -u -t 100000 /dev/input/${EVNAME}`
		[ "$key" = "$KEY_ESC" ] && break
		[ "$key" = "$KEY_SHIFT" ] && break
	done

	rmmod g_file_storage
}

usbnet()
{
	${T2S} -c
	[ -c /dev/ptmx ] || mknod /dev/ptmx c 5 2
	[ -d /dev/pts ] || mkdir /dev/pts

	if [ "$PRODUCT" = "RX-51" ]; then
		insmod $MODULE_PATH/phonet.ko
		insmod $MODULE_PATH/g_nokia.ko
		hwclock -s # load system clock
	else
		insmod $MODULE_PATH/g_ether.ko
		retutime -i # load system clock
	fi

	if [ -f /etc/hostname ]; then
		hostname -F /etc/hostname
	fi

	cat > /var/run/resolv.conf.usb0 << EOF
nameserver ${USB_IP%.*}.$((${USB_IP##*.}-1))
nameserver 8.8.8.8
EOF

	grep -q "/var/run/resolv.conf.usb0" /etc/dnsmasq.conf || echo "resolv-file=/var/run/resolv.conf.usb0" >> /etc/dnsmasq.conf

	ifconfig usb0 $USB_IP up
	ifconfig lo 127.0.0.1 up
	route add default gw ${USB_IP%.*}.$((${USB_IP##*.}-1))
	/usr/sbin/dnsmasq -i lo -a 127.0.0.1 -z

	mount -t devpts devpts /dev/pts

	y=20
	${T2S} -s 2 -H center -y $y -T 0 -t "USB networking is up with IP $USB_IP"

	if [ -x /usr/sbin/udhcpd ]; then
		if [ -f /var/run/udhcpd.pid ]; then kill `cat /var/run/udhcpd.pid`; fi
		cat > /var/run/udhcpd.conf << EOF
pidfile /var/run/udhcpd.pid
interface usb0
static_lease 00:00:00:00:00:00 usb0
lease_file /dev/null
start ${USB_IP%.*}.$((${USB_IP##*.}-1))
end ${USB_IP%.*}.$((${USB_IP##*.}-1))
option subnet usb0
EOF
		/usr/sbin/udhcpd /var/run/udhcpd.conf &
		y=$((y+20)); ${T2S} -s 2 -H center -y $y -T 0 -t "dhcp server started"
	else
		y=$((y+20)); ${T2S} -s 2 -H center -y $y -T 0 -t "dhcp server not found"
	fi

	if [ -x /usr/sbin/utelnetd ]; then # start utelnetd
		/usr/sbin/utelnetd -l /bin/sh -d
		y=$((y+20)); ${T2S} -s 2 -H center -y $y -T 0 -t "telnet server started on port 23"
	else
		y=$((y+20)); ${T2S} -s 2 -H center -y $y -T 0 -t "telnet server not found"
	fi

	if [ -x /usr/sbin/dropbear ]; then # start dropbear
		DBCONF=/etc/dropbear
		if [ -f $DBCONF/dropbear_rsa_host_key ]; then
			/usr/sbin/dropbear
			y=$((y+20)); ${T2S} -s 2 -H center -y $y -T 0 -t "ssh server started on port 22"
		else
			DBCONF=/tmp
			y=$((y+20)); ${T2S} -s 2 -H center -y $y -T 0 -t "no ssh keys, generating, may take a while ..."
			/usr/sbin/dropbearkey -t rsa -f $DBCONF/dropbear_rsa_host_key
			/usr/sbin/dropbearkey -t dss -f $DBCONF/dropbear_dss_host_key
			/usr/sbin/dropbear -d $DBCONF/dropbear_dss_host_key -r $DBCONF/dropbear_rsa_host_key
			y=$((y+20)); ${T2S} -s 2 -H center -y $y -T 0 -t "ssh server started on port 22"
		fi
	elif [ -x /usr/sbin/sshd ]; then # start sshd
		mkdir -p -m0755 /var/run/sshd
		/usr/sbin/sshd
		y=$((y+20)); ${T2S} -s 2 -H center -y $y -T 0 -t "ssh server started on port 22"
	else
		y=$((y+20)); ${T2S} -s 2 -H center -y $y -T 0 -t "ssh server not found"
	fi

	if [ "$PRODUCT" = "RX-51" ] && [ -h /usr/sbin/avahi-daemon ]; then
		mount /home
		mount /opt
		MOUNT_OPT=1
	fi
	if [ -x /usr/sbin/avahi-daemon ]; then # start avahi-daemon (mDNS support)
		sed 's/.*enable-dbus=.*/enable-dbus=no/' /etc/avahi/avahi-daemon.conf > /var/run/avahi-daemon.conf
		/usr/sbin/avahi-daemon -D -f /var/run/avahi-daemon.conf
		y=$((y+20)); ${T2S} -s 2 -H center -y $y -T 0 -t "avahi-daemon started"
	else
		y=$((y+20)); ${T2S} -s 2 -H center -y $y -T 0 -t "avahi-daemon not found"
	fi

	y=$((y+40)); ${T2S} -s 2 -H center -y $y -T 0 -t "Press ESC/SHIFT key to disconnect and go back"

	while true; do
		key=`evkey -u -t 100000 /dev/input/${EVNAME}`
		[ "$key" = "$KEY_ESC" ] && break
		[ "$key" = "$KEY_SHIFT" ] && break
	done

	${T2S} -c
	killall avahi-daemon
	killall sshd
	killall dropbear
	killall utelnetd
	killall udhcpd
	killall dnsmasq
	kill `cat /var/run/udhcpd.pid`
	rm -f /var/run/udhcpd.pid /var/run/udhcpd.conf
	rm -f /var/run/resolv.conf.usb0
	rm -f /var/run/avahi-daemon.conf
	route del default
	ifconfig usb0 down
	ifconfig lo down
	umount /dev/pts
	if [ "$PRODUCT" = "RX-51" ]; then
		if [ "$MOUNT_OPT" = "1" ]; then
			umount /opt
			umount /home
			MOUNT_OPT=0
		fi
		rmmod g_nokia
		rmmod phonet
	else
		rmmod g_ether
	fi
}

menu_redraw()
{
	i=$MENU_MIN
	y=100
	while [ $i -le $MENU_MAX ]; do
		eval label=\$MENU_${i}_NAME
		if [ $i = $MENU_IDX ]; then t=0xffff; b=0; else t=0; b=0xffff; fi
		${T2S} -x 0 -y $y -w 800 -h 20 -c
		${T2S} -s 2 -x 40 -y $y -T $t -B $b -t " $label "
		i=$((i+1))
		y=$((y+30))
	done
}

boot_message()
{
	${T2S} -c
	${T2S} -s 2 -H center -y 20 -T 0 -t "Booting from ${default_root} (${root_dev} ${root_fstype})..."
}

menu_init()
{
	${T2S} -c
	${T2S} -s 2 -H center -y 30 -T 0 -t "BOOT MENU"
	y=480
	if [ -x /usr/sbin/utelnetd -o -x /usr/sbin/dropbear -o -x /usr/sbin/sshd ]; then
		y=$(($y-30)); ${T2S} -s 2 -H center -y $y -T 0 -t "Press HOME/SHIFT key for USB network mode"
	fi
	y=$(($y-30)); ${T2S} -s 2 -H center -y $y -T 0 -t "Press MENU/CTRL key for USB mass storage mode"
	y=$(($y-30)); ${T2S} -s 2 -H center -y $y -T 0 -t "Press UP/DOWN to move, ENTER to select"
}

timeout_redraw()
{
	${T2S} -x 760 -y 10 -w 40 -h 20 -c
	[ $1 -ge 0 ] && ${T2S} -s 2 -x 760 -y 10 -T 0 -t "$1"
}

menu_loop()
{
	i=$MENU_TIMEOUT
	key_pressed=0
	while true; do
		key=`$GETKEY`
		[ "$key" = "" ] || key_pressed=1
		if [ $key_pressed = 0 ]; then # handle menu timeout
			if [ $i -eq 0 ]; then
				break # exit menu loop
			fi
			[ $i -gt 0 ] && i=$((i-1))
		else
			i=-1
		fi
		timeout_redraw $i

		case "$key" in
			${KEY_ENTER}|${KEY_SELECT}) # enter/select key, exit menu
				break # exit menu loop
				;;
			${KEY_UP}) # up key
				if [ $MENU_IDX -gt $MENU_MIN ]; then MENU_IDX=$((MENU_IDX-1)); else MENU_IDX=$MENU_MAX; fi
				menu_redraw
				;;
			${KEY_DOWN}) # down key
				if [ $MENU_IDX -lt $MENU_MAX ]; then MENU_IDX=$((MENU_IDX+1)); else MENU_IDX=$MENU_MIN; fi
				menu_redraw
				;;
			${KEY_HOME}|${KEY_SHIFT}) # home/shift key, network recovery
				usbnet
				menu_init
				menu_redraw
				;;
			${KEY_MENU}|${KEY_CTRL}) # menu/ctrl key, usb mass storage
				usb_mass_storage
				menu_init
				menu_redraw
				;;
		esac
	done
}

if [ "$PRODUCT" != "RX-51" ]; then
	# handle ask:xxx syntax
	case "$default_root" in
		ask)
			show_bootmenu=yes
			;;
		ask:*)
			default_root=$(expr substr $default_root 5 100)
			show_bootmenu=yes
			;;
	esac
else
	show_bootmenu=yes
fi

# try to preselect item with same id as preset in default_root
i=$MENU_MIN
while [ $i -le $MENU_MAX ]; do
	eval label_id=\$MENU_${i}_ID
	[ "$label_id" = "$default_root" ] && MENU_IDX=$i
	i=$((i+1))
done

if [ "$HWKEYSTATE" = "$KEY_MENU" ]; then
	show_bootmenu=yes
	MENU_TIMEOUT=-1 # menu requested by user, no timeout needed
fi

# power off device when power button was pressed
if [ "$EVPOWER" != "" ]; then
	(
	$GETPOWERKEY > /dev/null
	[ "$BRIGHTNESS" != "" ] && echo 0 > $BRIGHTNESS
	${T2S} -c -B black
	if [ "$PRODUCT" = "RX-51" ]; then
		rm -f /etc/mtab
		/etc/init.d/minishutdown
	else
		poweroff
	fi
	return
	) &
	POWERPID=$!
fi

# show onscreeen menu
if [ "$show_bootmenu" = "yes" ]; then
	menu_init
	menu_redraw
	menu_loop
fi

if [ "$PRODUCT" = "RX-51" ]; then
	killall watchdogs
fi

if [ "$POWERPID" != "" ]; then
	kill $POWERPID
	killall evkey
fi

eval i=\$MENU_${MENU_IDX}_DEVICE; [ -z "$i" ] || root_dev=$i
eval i=\$MENU_${MENU_IDX}_FSTYPE; [ -z "$i" ] || root_fstype=$i
eval i=\$MENU_${MENU_IDX}_FSOPTIONS; [ -z "$i" ] || root_fsoptions=$i
eval i=\$MENU_${MENU_IDX}_ID; [ -z "$i" ] || default_root=$i

# handle special IDs
case "$default_root" in
	off)
		[ "$BRIGHTNESS" != "" ] && echo 0 > $BRIGHTNESS
		${T2S} -c -B black
		if [ "$PRODUCT" = "RX-51" ]; then
			rm -f /etc/mtab
			/etc/init.d/minishutdown
		else
			poweroff
		fi
		return
		;;
	flash|nand)
		if [ "$PRODUCT" = "RX-51" ]; then
			root_mounted=1
		fi
		;;
	*)
		root_mounted=0
		;;
esac

boot_message
eval i=\$MENU_${MENU_IDX}_FBMODE; [ -z "$i" ] || /usr/bin/fb_update_mode $i
eval i=\$MENU_${MENU_IDX}_MODULES; [ -z "$i" ] || load_modules $i
eval i=\$MENU_${MENU_IDX}_USBMODE; [ -z "$i" ] || set_usb_mode $i
eval i=\$MENU_${MENU_IDX}_LINUXRC; [ -z "$i" ] || transfer_to_linuxrc $root_dev $i
