/****************************************************************************
**
** Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: Nokia Corporation (qt-info@nokia.com)
**
** This file is part of the QtDeclarative module of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL$
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights.  These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** Nokia at qt-info@nokia.com.
**
**
**
**
**
**
**
**
** $QT_END_LICENSE$
**
****************************************************************************/

import Qt 4.7




Item {
    id: delegate
    height: column.height + 40
    width: delegate.ListView.view.width

    Column {
        id: column
        x: 20; y: 20
        width: parent.width - 40
        signal selected

        Text {
            id: titleText
            text:title;
            width: parent.width;
            wrapMode: Text.WordWrap;
            color: {
                if (category == "Senior School")
                    return "#cc0000"
                else
                    if (category == "Prep School")
                        return "#9900cc"
                    else
                        return "white"
            }
            font { bold: true; family: "Helvetica";
                pointSize: {
                    if (title == "Info")
                        return 12
                    else
                        return 18}
            }
            MouseArea {
                id: mouseAreaTitle
                anchors.fill: parent
                onClicked: {
                    Qt.openUrlExternally (link);
                }

        }

        }
        Text {
            id: descriptionText
            width: parent.width;
            text: description
            wrapMode: Text.WordWrap;
            font { family: "Helvetica";
                 pointSize: {if (title == "Info")
                         return 11
                    else
                         return 16}
            }
            color: "white"
            MouseArea {
                id: mouseAreaDescription
                anchors.fill: parent
                onClicked: {
                    Qt.openUrlExternally (link);
                }

            }
        }
    }

    Rectangle {
        width: parent.width; height: 1; color: "#cccccc"
        anchors.bottom: parent.bottom
    }
}
