#!/usr/bin/env python

#Librarys
###########################################################################################
import commands
from bluetooth import *
 
#Classes
###########################################################################################
class Communicate:
	def __init__(self, parent):
		self.Parent = parent
		self.connected = False
		self.startCode = chr(8) + chr(0) + chr(128) + chr(9) + chr(0)+ chr(4) + "fwd" + chr(0)
		self.stopCode = chr(0) + chr(1) #FIXME: doesn't do anything
		self.connect()

	def connect(self):
		commands.getoutput("dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:\"Connecting..\"")
		try:
			self.socket = BluetoothSocket(RFCOMM)
			self.socket.connect(("00:16:53:05:F8:3E", 1))
			commands.getoutput("dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:\"Connected to coffeemaker\"")
			self.connected = True
		except:
			commands.getoutput("dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:\"Failed to connect to coffeemaker\"")
			self.connected = False

	def disconnect(self):
		self.socket.close()
		commands.getoutput("dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:\"Disconnected\"")
		self.connected = False

	def start(self):
		try:
			self.socket.send(self.startCode)
			commands.getoutput("dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:\"Started coffeemaker\"")
		except:
			commands.getoutput("dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:\"Not connected\"")


	def stop(self):
		try:
			self.socket.send(self.stopCode)
			commands.getoutput("dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:\"Stopped coffeemaker\"")
		except:
			commands.getoutput("dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:\"Not connected\"")
