#ifndef PHYSICSSCENE_H
#define PHYSICSSCENE_H

#include <QWidget>
#include <QGraphicsScene>
#include <QTimer>
#include <QTime>
#include <QList>

#include "Box2D/Source/Box2D.h"

#include "boxitem.h"

#include <QKeyEvent>
class PhysicsScene : public QGraphicsScene
{
    Q_OBJECT
public:
    explicit PhysicsScene(QObject *parent = 0);
    ~PhysicsScene();
    void createWorld();
    void addPhysicsItem(BoxItem * item);
    void removePhysicsItem(BoxItem * item);
    void start();
    void stop();
    b2World * world(){return mWorld;}

signals:

public slots:
    virtual void mainLoop();
    void moveXYZ(QString x, QString y, QString z);

protected:
    void keyPressEvent(QKeyEvent *event);
    void computeSimulation(int32 iterations = 10);

private:
    b2World *mWorld;
    b2Vec2 mGravity;
    QTimer* mTimer;
    QTime mTime;
    double mFps;
    QList <BoxItem*> mBoxList;

    BoxItem * ground;


};

#endif // PHYSICSSCENE_H
