#ifndef BLOKGAMEVIEW_H
#define BLOKGAMEVIEW_H

#include <QGraphicsView>
#include <QMouseEvent>
#include "physicsscene.h"
#include "boxitem.h"

#include "blokitem/chimicblokitem.h"
#include "blokitem/solidblokitem.h"
#include "blokitem/normalblokitem.h"
#include "blokitem/explodeblokitem.h"
#include "blokitem/totemblokitem.h"



class BlokGameView : public QGraphicsView
{
    Q_OBJECT
public:
    explicit BlokGameView(QWidget *parent = 0);
void setWallpaper(const QString& path);
void setGround(const QString& path);

signals:

public slots:
void loadMap(const QString& path);


protected:
void mousePressEvent(QMouseEvent *event);

private:
PhysicsScene * mScene;
QGraphicsPixmapItem * mWallpaperItem;
BoxItem * mGroundItem;

};

#endif // BLOKGAMEVIEW_H
