#include <QtCore>
#include <QtGui>
#include "mainwindow.h"
#include "ui_mainwindow.h"

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow),
    progress("Setting up the theme, please wait...", "Abort", 0, 0, this)
{
    ui->setupUi(this);
    ui->scrollArea->setWidget(ui->widget);
    readdirs();
    readSettings();
}

MainWindow::~MainWindow()
{
    delete ui;
}

void MainWindow::readdirs()
{
    QDir colors("/opt/plastic-schemes");
    QStringList colorstobox = colors.entryList(QDir::AllDirs | QDir::NoDotAndDotDot, QDir::DirsFirst);
    ui->Color->addItems(colorstobox);
}

void MainWindow::writeSettings()
{
    QSettings sett("PlasticTheme", "Boxes");
    sett.setValue("color", ui->Color->currentIndex());
    sett.setValue("transitions", ui->Transition->currentIndex());
    sett.setValue("walls", ui->Walls->currentIndex());
    sett.setValue("icons", ui->Icons->currentIndex());
    sett.setValue("snap", ui->Snap->currentIndex());
    sett.setValue("fontsize", ui->FontSize->currentIndex());
    sett.setValue("iconset", ui->Iconset->currentIndex());
}

void MainWindow::readSettings()
{
    QSettings sett("PlasticTheme", "Boxes");
    int color = sett.value("color").toInt();
    int transitions = sett.value("transitions").toInt();
    int walls = sett.value("walls").toInt();
    int icons = sett.value("icons").toInt();
    int snap = sett.value("snap").toInt();
    int fontsize = sett.value("fontsize").toInt();
    int iconset = sett.value("iconset").toInt();
    ui->Color->setCurrentIndex(color);
    ui->Transition->setCurrentIndex(transitions);
    ui->Walls->setCurrentIndex(walls);
    ui->Icons->setCurrentIndex(icons);
    ui->Snap->setCurrentIndex(snap);
    ui->FontSize->setCurrentIndex(fontsize);
    ui->Iconset->setCurrentIndex(iconset);

    if ( ui->Transition->currentText() == "Use DEFAULT transitions" ) {

        ui->Snap->setDisabled(true);
    }
}



void MainWindow::on_pushButton_clicked()
{
        QString checkboxstate;
        if ( ui->checkBoxActivate->checkState() == Qt::Checked ) {
            checkboxstate = "Reboot";
        }
        else {
            checkboxstate = "0";
        }
        writeSettings();
        QString varattu;
        varattu = "Plastic Theme Setup";
        progress.setWindowModality(Qt::WindowModal);
        progress.setWindowTitle(varattu);
        progress.setCancelButton(0);
        QStringList arguments;
        arguments << ui->Transition->currentText() << ui->Fonter->currentText() << ui->Color->currentText() << ui->Activate->currentText() << checkboxstate << ui->Walls->currentText() << ui->Icons->currentText() << ui->Snap->currentText() << ui->FontSize->currentText() << ui->Iconset->currentText();
        QProcess *process = new QProcess(this);
        connect(process, SIGNAL(finished(int)), this, SLOT(processFinished(int)));
        process->start("/sbin/launchblack", arguments);
        progress.show();


}

void MainWindow::processFinished(int)
{
        progress.cancel();
}

void MainWindow::on_Transition_currentIndexChanged(QString )
{
    if ( ui->Transition->currentText() == "Use DEFAULT transitions" ) {

        ui->Snap->setDisabled(true);
    }
    else {
        ui->Snap->setEnabled(true);
    }
}
