/*
 * StationsState.h
 *
 *  Created on: Nov 3, 2010
 *      Author: Thomas Schwery
 */

#ifndef STATIONSSTATE_H_
#define STATIONSSTATE_H_

#include <QMap>
#include <QtAlgorithms>
#include <QGeoPositionInfo>

#include "gpsposition.h"
#include "Station.h"

enum StationSorting {
    alpha_name,
    alpha_network,
    numerical,
    distance_user
};

class StationsState : public QObject {
    Q_OBJECT
public:
    StationsState();
    virtual ~StationsState();

    QMap<QString, Station*> * getStationMap();
    QList<Station*> * getStationList();

    void setStations(QMap<QString, Station*>* updatedStations);
    void setSortType(StationSorting);

    static bool compareDistance(Station*&, Station*&);
    static bool compareName(Station *&, Station *&);
    static bool compareNetwork(Station *&, Station *&);
    static bool compareNumber(Station *&, Station *&);

public slots:
    void setSortType(QString);

private:
    QMap<QString, Station*> * stations;
    StationSorting sortType;
};

#endif /* STATIONSSTATE_H_ */
