/*
 * Station.cpp
 *
 *  Created on: Nov 3, 2010
 *      Author: Thomas Schwery
 */

#include "Station.h"

Station::Station(QString name, QString network, float gpsX, float gpsY, int freeBikes, int freeStations) {
    this->name = name;
    this->network = network;
    this->xPosition = gpsX;
    this->yPosition = gpsY;
    this->freeBikes = freeBikes;
    this->freeStations = freeStations;
}

Station::~Station() {
    // TODO Auto-generated destructor stub
}

QPushButton * Station::getButton() {
    QPushButton *cb = new QPushButton(QString(""));

    QString infoBikes = "";
    infoBikes += "Bikes:";
    infoBikes += QString("%1").arg(freeBikes);

    QString infoStations = "";
    infoStations += "Stations:";
    infoStations += QString("%1").arg(freeStations);

    QLabel * labelBikes = new QLabel(infoBikes);
    QLabel * labelStations = new QLabel(infoStations);


    QLabel * labelNetwork = new QLabel(network);
    QLabel * labelName = new QLabel(name);

    QHBoxLayout * layout = new QHBoxLayout(cb);

    QVBoxLayout * stationLayout = new QVBoxLayout();
    QVBoxLayout * infoLayout = new QVBoxLayout();

    stationLayout->addWidget(labelName);
    stationLayout->addWidget(labelNetwork);

    infoLayout->addWidget(labelBikes);
    infoLayout->addWidget(labelStations);

    layout->addLayout(stationLayout);
    layout->addLayout(infoLayout);

    cb->setLayout(layout);

#ifndef Q_WS_MAEMO_5
    cb->adjustSize();
#endif

    return cb;
}

qreal Station::getLatitude() const {
    return qreal(xPosition);
}

qreal Station::getLongitude() const {
    return qreal(yPosition);
}

QGeoCoordinate Station::getCoordinate() const {
    return QGeoCoordinate(xPosition, yPosition);
}

QLayout * Station::getLayout() {
    QVBoxLayout * vbox = new QVBoxLayout();

    QString label = "Station name: ";
    label += name;
    QLabel * labelName = new QLabel(label);

    QString label2 = "Station network: ";
    label2 += network;
    QLabel * labelNetwork = new QLabel(label2);

    QString label3 = "Free bikes: ";
    label3 += QString("%1").arg(freeBikes);
    QLabel * labelBikes = new QLabel(label3);

    QString label4 = "Free stations: ";
    label4 += QString("%1").arg(freeStations);
    QLabel * labelStations = new QLabel(label4);

    QGeoCoordinate stationCoordinates(getLatitude(), getLongitude());
    QGeoCoordinate userCoordinates(GPSPosition::getInstance().getCoordinate());
    qreal distance = stationCoordinates.distanceTo(userCoordinates);

    QString label5 = "Distance: ";
    label5 += QString("%1").arg(distance);
    label5 += " meters";
    QLabel * labelDistance = new QLabel(label5);

    vbox->addWidget(labelName);
    vbox->addWidget(labelNetwork);
    vbox->addWidget(labelBikes);
    vbox->addWidget(labelStations);
    vbox->addWidget(labelDistance);

    vbox->addStretch(1000);

    return vbox;
}

QString Station::getName() const {
    return name;
}

QString Station::getNetwork() const {
    return network;
}

int Station::getFreeBikes() const {
    return freeBikes;
}

int Station::getFreeStations() const {
    return freeStations;
}

QTextStream &operator<<(QTextStream &out, const Station &station) {
    out << station.getName() << "(" << station.getNetwork() << ") - Bikes:" << station.getFreeBikes() << ", Stations:" << station.getFreeStations();
    return out;
}
