#include <QApplication>

#include "MainWindow.h"
#include "UpdaterThread.h"
#include "PageParser.h"

#include "gpsposition.h"

int main(int argc, char *argv[])
{
    QTextStream out(stdout);
    QApplication app(argc, argv);

#ifdef  Q_WS_MAEMO_5
    QApplication ::setOverrideCursor(QCursor(Qt::BlankCursor));
#endif

    StationsState * state = new StationsState();

    UpdaterThread * updaterThread = new UpdaterThread(state);

    GPSPosition::getInstance();

    MainWindow window(state);

    QObject::connect(updaterThread, SIGNAL(dataUpdated()), &window, SLOT(dataUpdated()));
    QObject::connect(&window, SIGNAL(updateData()), updaterThread, SLOT(update()));

    window.show();
    window.update();

    return app.exec();
}
