/*
 * MainWindow.cpp
 *
 *  Created on: Nov 2, 2010
 *      Author: Thomas Schwery
 */

#include "MainWindow.h"
#include "StationDetail.h"

MainWindow::MainWindow(StationsState * state, QWidget *parent)
    : QMainWindow(parent)
{

#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5StackedWindow);
#endif
    setWindowFlags(windowFlags() | Qt::Window);
    this->state = state;

    QScrollArea *activityScroll = new QScrollArea(this);
    QWidget *activitiesWidget = new QWidget(activityScroll);
    mainLayout = new QVBoxLayout(activitiesWidget);
    signalMapper = new QSignalMapper(this);
    connect(signalMapper, SIGNAL(mapped(QString)), this, SLOT(popupStation(QString)));

    activityScroll->setWidgetResizable(true);
    activityScroll->setWidget(activitiesWidget);

    QAction * updateAction = new QAction(tr("&Update"), this);
    QAction * sortA = new QAction(tr("&Sort Network"), this);
    QAction * sortB = new QAction(tr("&Sort Numeric"), this);
    QAction * sortC = new QAction(tr("&Sort Name"), this);
    QAction * sortD = new QAction(tr("&Sort Distance"), this);

    QMenu * menu = menuBar()->addMenu(tr("Menu"));
    menu->addAction(updateAction);
    menu->addAction(sortA);
    menu->addAction(sortB);
    menu->addAction(sortC);
    menu->addAction(sortD);

    signalMapperMenu = new QSignalMapper(this);

    signalMapperMenu->setMapping(sortA, "network");
    signalMapperMenu->setMapping(sortB, "numeric");
    signalMapperMenu->setMapping(sortC, "name");
    signalMapperMenu->setMapping(sortD, "distance");

    connect(updateAction, SIGNAL(triggered()), this , SLOT(update()));
    connect(sortA, SIGNAL(triggered()), signalMapperMenu , SLOT(map()));
    connect(sortB, SIGNAL(triggered()), signalMapperMenu , SLOT(map()));
    connect(sortC, SIGNAL(triggered()), signalMapperMenu , SLOT(map()));
    connect(sortD, SIGNAL(triggered()), signalMapperMenu , SLOT(map()));

    connect(signalMapperMenu, SIGNAL(mapped(QString)), state , SLOT(setSortType(QString)));
    connect(signalMapperMenu, SIGNAL(mapped(QString)), this , SLOT(dataUpdated()));

    setCentralWidget(activityScroll);

    update();
}

MainWindow::~MainWindow() {
    // TODO Auto-generated destructor stub
}

void MainWindow::popupStation(QString key) {
    Station * station = state->getStationMap()->value(key);
    StationDetail * detail = new StationDetail(station, this);
    detail->show();
}

void MainWindow::clearLayout() {
    QPushButton * cb = NULL;
    while (mainLayout->count() > 0) {
        cb = dynamic_cast<QPushButton*>(mainLayout->takeAt(0));
        signalMapper->removeMappings(cb);
        delete cb;
    }
}

void MainWindow::dataUpdated() {
    clearLayout();
    QList<Station*>::iterator i;
    QList<Station*>* stations = state->getStationList();
    QPushButton * cb = NULL;

    for (i = stations->begin(); i != stations->end(); ++i) {
        cb = (*i)->getButton();
        mainLayout->addWidget(cb);
        connect(cb, SIGNAL(clicked()), signalMapper, SLOT(map()));
        signalMapper->setMapping(cb, (*i)->getName());
    }
    mainLayout->update();
}

void MainWindow::update() {
    emit updateData();
}
