/* This file is part of Beifahrer.
 *
 * Copyright (C) 2010 Philipp Zabel
 *
 * Beifahrer is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Beifahrer is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Beifahrer. If not, see <http://www.gnu.org/licenses/>.
 */

using Gtk;
using Hildon;

public class MyInformationWindow : StackableWindow {
	enum FieldIndex {
		NAME = 0,
		CELL = 1,
		PHONE = 2,
		EMAIL = 3,
		BIRTHDAY = 4,
	}

	AdacMitfahrclub adac;
	Gtk.Label[] fields;

	private async void get_information () {
		Hildon.gtk_window_set_progress_indicator (this, 1);
		bool logged_in = yield adac.login_async ();
		if (!logged_in) {
			Banner.show_information (this, null, "Login failed.");
			return;
		}

		MyInformation my_info = yield adac.get_my_information ();
		if (my_info != null) {
			fields[FieldIndex.NAME].set_label (my_info.first_name + " " + my_info.last_name);
			fields[FieldIndex.CELL].set_label (my_info.cell);
			fields[FieldIndex.PHONE].set_label (my_info.phone1);
			fields[FieldIndex.EMAIL].set_label (my_info.email1);
		}
		Hildon.gtk_window_set_progress_indicator (this, 0);
	}

	public MyInformationWindow (AdacMitfahrclub _adac) {
		adac = _adac;

		get_information.begin ();
	}

	const string[] labels = {
		"Name", "Cell", "Phone", "E-mail", "Birthday"
	};

	construct {
		set_title ("My information");

		var menu = new AppMenu ();
		var goto_website = new Gtk.Button.with_label (_("Show website"));
		goto_website.show ();
		menu.append (goto_website);
		set_main_menu (menu);

		var table = new Gtk.Table (5, 2, false);

		fields = new Gtk.Label[5];
		for (int i = 0; i < 5; i++) {
			var label = new Gtk.Label (_(labels[i]));
			label.set_alignment (0.0f, 0.0f);
			Hildon.helper_set_logical_color (label, RcFlags.FG, StateType.NORMAL, "SecondaryTextColor");
			table.attach (label, 0, 1, i, i+1, AttachOptions.FILL, AttachOptions.FILL, 0, 0);

			fields[i] = new Gtk.Label ("");
			fields[i].set_alignment (0.0f, 0.0f);
			table.attach (fields[i], 1, 2, i, i+1, AttachOptions.FILL, AttachOptions.FILL, 0, 0);
		}

		add (table);
		table.show_all ();

		goto_website.clicked.connect (on_goto_website_clicked);
	}

	void on_goto_website_clicked () {
		BeifahrerProgram.open_browser (this, adac.get_my_information_url ());
	}
}

//	Anrede
//	Date registered_since;
//	string password;
/*
	// Address
	string street; string number;
	string PLZ; string city;
	string land;

	// Contact
	string telefon1;
	string telefon2;
	string telefon3;
	string handy;
	string email1;
	string email2;
	bool smoker;
	string occupation;
	string familienstand;
	string language1; // list
	string language2;
	string language3;

	// Newsletter
	bool newsletter;
	bool newsletter_html;

	// Kfz
	int fahrleistung;
	int vmax;
	string kfz_vendor;
	string kfz_model;
	int year;
	string co2;

	bool adac_member;
*/

// 1. login
// 2. parse https://mitfahrclub.adac.de/users/view
