/****************************************************************************
**
** Copyright (C) 2007-2007 Trolltech ASA. All rights reserved.
**
** This file is part of the Graphics Dojo project on Trolltech Labs.
**
** This file may be used under the terms of the GNU General Public
** License version 2.0 as published by the Free Software Foundation
** and appearing in the file LICENSE.GPL included in the packaging of
** this file.  Please review the following information to ensure GNU
** General Public Licensing requirements will be met:
** http://www.trolltech.com/products/qt/opensource.html
**
** If you are unsure which license is appropriate for your use, please
** review the following information:
** http://www.trolltech.com/products/qt/licensing.html or contact the
** sales department at sales@trolltech.com.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/
#include "widget.h"

#include <QApplication>
#include <QHBoxLayout>
#include <QSystemDeviceInfo>
#include <QPalette>
#include <QCleanlooksStyle>
#include <QColorGroup>

#include <X11/extensions/Xrender.h>

QTM_USE_NAMESPACE

int main(int argc, char **argv)
{
    qWarning("Please make sure you're running a composition manager!");
    Display *dpy = XOpenDisplay(0); // open default display
    if (!dpy) {
        qWarning("Cannot connect to the X server");
        exit(1);
    }

    QApplication app(dpy, argc, argv);
    QSystemDeviceInfo *devInfo = new QSystemDeviceInfo();

    Widget w;
    w.setValue(devInfo->batteryLevel());
	//w.setStyleSheet("QProgressBar { font:30px }");

    QObject::connect(devInfo, SIGNAL(batteryLevelChanged(int)), &w, SLOT(setValue(int)) );

    w.show();

    return app.exec();
}
