#include "mainwindow.h"
#include "ui_mainwindow.h"

#include "about.h"
#include "help.h"
#include "resistors.h"
#include "calculations.h"
#include "caps.h"
#include "netcable.h"

#include <QtCore/QCoreApplication>
#include <QDesktopServices>
#include <QUrl>
#include <QShortcut>

MainWindow::MainWindow(QWidget *parent):
    QMainWindow(parent),
    ui(new Ui::MainWindow),
      about(0),
      help(0),
      caps(0),
      resistors(0),
      calculations(0),
      netcable(0)
{
    ui->setupUi(this);

    //Window Text
    this->setWindowTitle("Bander");
    setAttribute(Qt::WA_Maemo5StackedWindow);

    about = new About(this);
    help = new Help(this);
    caps = new Caps(this);
    resistors = new Resistors(this);
    calculations = new Calculations(this);
    netcable = new Netcable(this);

    // For Connecting Keyboard Buttons
    connectSignals();
}

MainWindow::~MainWindow()
{
    if (about) delete (about);
    if (help) delete (help);
    if (caps) delete (caps);
    if (resistors) delete (resistors);
    if (calculations) delete (calculations);
    if (netcable) delete (netcable);
    delete ui;
}

void MainWindow::setOrientation(ScreenOrientation orientation)
{
#if defined(Q_OS_SYMBIAN)
    // If the version of Qt on the device is < 4.7.2, that attribute won't work
    if (orientation != ScreenOrientationAuto) {
        const QStringList v = QString::fromAscii(qVersion()).split(QLatin1Char('.'));
        if (v.count() == 3 && (v.at(0).toInt() << 16 | v.at(1).toInt() << 8 | v.at(2).toInt()) < 0x040702) {
            qWarning("Screen orientation locking only supported with Qt 4.7.2 and above");
            return;
        }
    }
#endif // Q_OS_SYMBIAN

    Qt::WidgetAttribute attribute;
    switch (orientation) {
#if QT_VERSION < 0x040702
    // Qt < 4.7.2 does not yet have the Qt::WA_*Orientation attributes
    case ScreenOrientationLockPortrait:
        attribute = static_cast<Qt::WidgetAttribute>(128);
        break;
    case ScreenOrientationLockLandscape:
        attribute = static_cast<Qt::WidgetAttribute>(129);
        break;
    default:
    case ScreenOrientationAuto:
        attribute = static_cast<Qt::WidgetAttribute>(130);
        break;
#else // QT_VERSION < 0x040702
    case ScreenOrientationLockPortrait:
        attribute = Qt::WA_LockPortraitOrientation;
        break;
    case ScreenOrientationLockLandscape:
        attribute = Qt::WA_LockLandscapeOrientation;
        break;
    default:
    case ScreenOrientationAuto:
        attribute = Qt::WA_AutoOrientation;
        break;
#endif // QT_VERSION < 0x040702
    };
    setAttribute(attribute, true);
}

void MainWindow::showExpanded()
{
#if defined(Q_OS_SYMBIAN) || defined(Q_WS_SIMULATOR)
    showFullScreen();
#elif defined(Q_WS_MAEMO_5)
    showMaximized();
#else
    show();
#endif
}

// Keyboard Button Signals - remember to include QShortcut
void MainWindow::connectSignals()
{

// Keyboard Key Signals
  connect(new QShortcut(QKeySequence(Qt::Key_Q), this), SIGNAL(activated()), this, SLOT(on_pushButtonColors_clicked()));
  connect(new QShortcut(QKeySequence(Qt::Key_W), this), SIGNAL(activated()), this, SLOT(on_pushButtonCalculations_clicked()));
  connect(new QShortcut(QKeySequence(Qt::Key_E), this), SIGNAL(activated()), this, SLOT(on_pushButtonCaps_clicked()));
  connect(new QShortcut(QKeySequence(Qt::Key_R), this), SIGNAL(activated()), this, SLOT(on_pushButtonNetcable_clicked()));
}

// End of Keyboard Signals

//Menu

void MainWindow::on_actionAbout_triggered()
{
    about->show();
}

void MainWindow::on_actionHelp_triggered()
{
    help->show();
}

void MainWindow::on_pushButtonCalculations_clicked()
{
    calculations->show();
}

void MainWindow::on_pushButtonCaps_clicked()
{
    caps->show();
}

void MainWindow::on_pushButtonColors_clicked()
{
    resistors->show();
}

void MainWindow::on_pushButtonNetcable_clicked()
{
    netcable->show();
}
