#include "dialogsearch.h"
#include "ui_dialogsearch.h"
#include "dialogcalendar.h"
#include <QMessageBox>
#include "badgedata.h"
#include <QDebug>

DialogSearch::DialogSearch(QWidget *parent) :
    QDialog(parent)/*,
    ui(new Ui::DialogSearch)*/
{
    //ui->setupUi(this);
    setAttribute(Qt::WA_Maemo5StackedWindow);
    this->resize(299, 229);

    verticalLayout = new QVBoxLayout(this);
    verticalLayout->setObjectName(QString::fromUtf8("verticalLayout"));
    verticalLayout->setContentsMargins(0, 0, 0, 0);
    horizontalLayout = new QHBoxLayout();
    horizontalLayout->setObjectName(QString::fromUtf8("horizontalLayout"));
    //label = new QLabel(widget);
    //label->setObjectName(QString::fromUtf8("label"));

    //horizontalLayout->addWidget(label);

    pushButtonStart = new QMaemo5ValueButton("Start");
    pushButtonStart->setValueLayout(QMaemo5ValueButton::ValueUnderText);
    pushButtonStart->setPickSelector(new QMaemo5DatePickSelector());
    pushButtonStart->setObjectName(QString::fromUtf8("pushButtonStart"));
    //pushButtonStart->setMaximumSize(QSize(31, 26));

    horizontalLayout->addWidget(pushButtonStart);

    //dateEditStart = new QDateEdit(widget);
    //dateEditStart->setObjectName(QString::fromUtf8("dateEditStart"));

    //horizontalLayout->addWidget(dateEditStart);


    verticalLayout->addLayout(horizontalLayout);

    horizontalLayout_2 = new QHBoxLayout();
    horizontalLayout_2->setObjectName(QString::fromUtf8("horizontalLayout_2"));
    //label_2 = new QLabel(widget);
    //label_2->setObjectName(QString::fromUtf8("label_2"));

    //horizontalLayout_2->addWidget(label_2);

    //pushButtonEnd = new QPushButton(widget);


    pushButtonEnd = new QMaemo5ValueButton("End");
    pushButtonEnd->setValueLayout(QMaemo5ValueButton::ValueUnderText);
    pushButtonEnd->setPickSelector(new QMaemo5DatePickSelector());
    pushButtonEnd->setObjectName(QString::fromUtf8("pushButtonEnd"));
    //pushButtonEnd->setMaximumSize(QSize(31, 26));

    horizontalLayout_2->addWidget(pushButtonEnd);

    //dateEditEnd = new QDateEdit(widget);
   // dateEditEnd->setObjectName(QString::fromUtf8("dateEditEnd"));

    //horizontalLayout_2->addWidget(dateEditEnd);


    verticalLayout->addLayout(horizontalLayout_2);

    horizontalSpacer = new QSpacerItem(40, 20, QSizePolicy::Expanding, QSizePolicy::Minimum);

    verticalLayout->addItem(horizontalSpacer);

    buttonBox = new QDialogButtonBox(this);
    buttonBox->setObjectName(QString::fromUtf8("buttonBox"));
    //buttonBox->setMaximumSize(QSize(16777215, 26));
    buttonBox->setOrientation(Qt::Horizontal);
    buttonBox->setStandardButtons(QDialogButtonBox::Cancel|QDialogButtonBox::Ok);

    verticalLayout->addWidget(buttonBox);

    //label->raise();
    pushButtonStart->raise();
    //dateEditStart->raise();
    //label_2->raise();
    pushButtonEnd->raise();
    //dateEditEnd->raise();
    buttonBox->raise();
    buttonBox->raise();

    //retranslateUi(DialogSearch);
    connect(buttonBox, SIGNAL(accepted()), this, SLOT(accept()));
    //QObject::connect(buttonBox, SIGNAL(rejected()), DialogSearch, SLOT(reject()));
    //connect(pushButtonStart, SIGNAL(clicked()), this, SLOT(start()));
    //connect(pushButtonEnd, SIGNAL(clicked()), this, SLOT(end()));


}

DialogSearch::~DialogSearch()
{
    //delete ui;
}

void DialogSearch::changeEvent(QEvent *e)
{
    /*QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }*/
}



QTime DialogSearch::totalHours(bool &ok)
{

    if (this->exec() == QDialog::Accepted) {
        BadgeData data;
        ok = true;
        qDebug() << "S " << pushButtonStart->valueText() << " E " << pushButtonEnd->valueText() << endl;
        return data.totalTime(QDate::fromString(pushButtonStart->valueText(), "yyyy-M-d"), QDate::fromString(pushButtonEnd->valueText(), "yyyy-M-d"));
    }
    ok = false;


    return QTime(0, 0, 0, 0);
}

void DialogSearch::accept()
{

    if (QDate::fromString(pushButtonEnd->valueText(), "yyyy-M-d") < QDate::fromString(pushButtonStart->valueText(), "yyyy-M-d")) {
        QMessageBox::warning(this, tr("Badge"),
                                        tr("End date must to be major or equal of start date.\n"));
    }
    else
        QDialog::accept();
}
