#include "badgedata.h"
#include <QFile>
#include <QDir>
#include <QDebug>

BadgeData::BadgeData()
{

}

bool BadgeData::setTimetable(TimeTable tt)
{
    QFile data;
    TimeTable dum;
    qint64 pos = 0;

    data.setFileName(QDir::homePath() + QDir::separator() + "badge.data");
    data.open(QIODevice::ReadWrite);
    QDataStream out(&data);
    while (!data.atEnd()) {
        out >> dum;
        if (dum.day == tt.day) {
            data.seek(pos);

            out << tt;
            data.close();
            return true;
        }
         pos = data.pos();
    }
    out << tt;
    data.close();
    return true;
}

bool BadgeData::getTimetable(TimeTable &tt)
{
    QFile data;
    TimeTable dum;
    data.setFileName(QDir::homePath() + QDir::separator() + "badge.data");
    data.open(QIODevice::ReadOnly);
    QDataStream out(&data);



    while (!data.atEnd()) {
        out >> dum;
        if (dum.day == tt.day) {
            tt = dum;
            data.close();
            return true;
        }
    }
    data.close();
    return false;
}

QTime BadgeData::totalTime(QDate begin, QDate end)
{
    QFile data;
    TimeTable dum;
    QTime total(0, 0, 0, 0);

    int totalInSeconds = 0;

    data.setFileName(QDir::homePath() + QDir::separator() + "badge.data");
    data.open(QIODevice::ReadOnly);
    QDataStream out(&data);
    while (!data.atEnd()) {
        out >> dum;
        if (dum.day >=  begin && dum.day <= end) {
            totalInSeconds += dum.entrance.secsTo(dum.exit);
            if (dum.firstPause != dum.endFirstPause) {
                totalInSeconds -= dum.firstPause.secsTo(dum.endFirstPause);
            }

            if (dum.secondPause != dum.endSecondPause) {
                totalInSeconds -= dum.secondPause.secsTo(dum.endSecondPause);
            }



        }

    }
    data.close();
    total.setHMS((int)(totalInSeconds / 3600), (int) ((totalInSeconds % 3600) / 60), 0);
    return total;
}
